/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import gregtech.api.GTValues;
import gregtech.api.fluids.GTFluid;
import gregtech.api.util.TextFormattingUtil;
import java.util.Arrays;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyUtil {
    public static IKey string(String s) {
        return IKey.str((String)s);
    }

    public static IKey string(Supplier<String> s) {
        return IKey.dynamic(s);
    }

    public static IKey string(TextFormatting formatting, String string) {
        if (string == null) {
            return IKey.EMPTY;
        }
        return IKey.str((String)string).style(formatting);
    }

    public static IKey string(TextFormatting formatting, String string, Object ... args) {
        if (string == null) {
            return IKey.EMPTY;
        }
        return IKey.str((String)string, (Object[])args).style(formatting);
    }

    public static IKey string(TextFormatting formatting, Supplier<String> stringSupplier) {
        return IKey.dynamic(stringSupplier).style(formatting);
    }

    public static IKey string(TextFormatting formatting, Supplier<String> stringSupplier, Supplier<Object[]> argSupplier) {
        return IKey.dynamic(() -> String.format((String)stringSupplier.get(), (Object[])argSupplier.get())).style(formatting);
    }

    public static IKey string(Supplier<TextFormatting> formatting, String s) {
        return IKey.dynamic(() -> IKey.str((String)s).style((TextFormatting)formatting.get()).getFormatted());
    }

    public static IKey string(Supplier<TextFormatting> formatting, Supplier<String> stringSupplier) {
        return IKey.dynamic(() -> IKey.str((String)((String)stringSupplier.get())).style((TextFormatting)formatting.get()).getFormatted());
    }

    public static IKey lang(String lang, Object ... args) {
        return IKey.lang((String)lang, (Object[])args);
    }

    public static IKey lang(TextFormatting formatting, String lang, Object ... args) {
        return IKey.lang((String)lang, (Object[])args).style(formatting);
    }

    public static IKey lang(TextFormatting formatting, String lang, Supplier<Object[]> argSupplier) {
        return IKey.lang((String)lang, argSupplier).style(formatting);
    }

    public static IKey lang(Supplier<TextFormatting> formatting, String lang, Supplier<Object[]> argSupplier) {
        return IKey.dynamic(() -> KeyUtil.lang(lang, (Object[])argSupplier.get()).style((TextFormatting)formatting.get()).getFormatted());
    }

    public static IKey number(long number) {
        return KeyUtil.string(TextFormattingUtil.formatNumbers(number));
    }

    public static IKey number(TextFormatting formatting, long number) {
        return KeyUtil.number(number).style(formatting);
    }

    public static IKey number(TextFormatting formatting, long number, String suffix) {
        return KeyUtil.string(formatting, TextFormattingUtil.formatNumbers(number) + suffix);
    }

    public static IKey number(TextFormatting formatting, LongSupplier supplier) {
        return KeyUtil.string(formatting, () -> TextFormattingUtil.formatNumbers(supplier.getAsLong()));
    }

    public static IKey number(TextFormatting formatting, LongSupplier supplier, String suffix) {
        return KeyUtil.string(formatting, () -> TextFormattingUtil.formatNumbers(supplier.getAsLong()) + suffix);
    }

    public static IKey number(Supplier<TextFormatting> formatting, LongSupplier supplier) {
        return KeyUtil.string(formatting, () -> TextFormattingUtil.formatNumbers(supplier.getAsLong()));
    }

    public static IKey number(Supplier<TextFormatting> formatting, long number) {
        return KeyUtil.string(formatting, () -> TextFormattingUtil.formatNumbers(number));
    }

    public static IKey number(Supplier<TextFormatting> formatting, long number, String suffix) {
        return KeyUtil.string(formatting, () -> TextFormattingUtil.formatNumbers(number) + suffix);
    }

    public static IKey number(Supplier<TextFormatting> formatting, LongSupplier supplier, String suffix) {
        return KeyUtil.string(formatting, () -> TextFormattingUtil.formatNumbers(supplier.getAsLong()) + suffix);
    }

    public static IDrawable setHover(IKey body, IDrawable ... hover) {
        if (ArrayUtils.isEmpty((Object[])hover)) {
            return body;
        }
        if (!GTValues.isClientSide()) {
            return IDrawable.NONE;
        }
        return (IDrawable)body.asTextIcon().asHoverable().addTooltipDrawableLines(Arrays.asList(hover));
    }

    @NotNull
    public static IKey fluid(TextFormatting formatting, FluidStack fluid) {
        return KeyUtil.fluid(fluid.getFluid(), fluid).style(formatting);
    }

    @NotNull
    public static IKey fluid(TextFormatting formatting, Fluid fluid) {
        return KeyUtil.fluid(fluid).style(formatting);
    }

    @NotNull
    public static IKey fluid(@Nullable FluidStack fluid) {
        if (fluid == null) {
            return IKey.EMPTY;
        }
        return KeyUtil.fluid(fluid.getFluid(), fluid);
    }

    @NotNull
    public static IKey fluid(@Nullable Fluid fluid) {
        return KeyUtil.fluid(fluid, null);
    }

    @NotNull
    public static IKey fluid(@Nullable Fluid fluid, @Nullable FluidStack stack) {
        if (fluid == null) {
            return IKey.EMPTY;
        }
        if (fluid instanceof GTFluid.GTMaterialFluid) {
            GTFluid.GTMaterialFluid gtFluid = (GTFluid.GTMaterialFluid)fluid;
            return gtFluid.getLocalizedKey();
        }
        if (stack == null) {
            return IKey.lang((String)fluid.getUnlocalizedName());
        }
        return IKey.lang((String)fluid.getUnlocalizedName(stack));
    }
}

