/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import it.unimi.dsi.fastutil.Hash;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface ItemStackHashStrategy
extends Hash.Strategy<ItemStack> {
    public static Builder builder() {
        return new Builder();
    }

    public static ItemStackHashStrategy comparingAll() {
        return ItemStackHashStrategy.builder().compareItem(true).compareCount(true).compareDamage(true).compareTag(true).build();
    }

    public static ItemStackHashStrategy comparingAllButCount() {
        return ItemStackHashStrategy.builder().compareItem(true).compareDamage(true).compareTag(true).build();
    }

    public static ItemStackHashStrategy comparingItemDamageCount() {
        return ItemStackHashStrategy.builder().compareItem(true).compareDamage(true).compareCount(true).build();
    }

    public static class Builder {
        private boolean item;
        private boolean count;
        private boolean damage;
        private boolean tag;
        private boolean meta;

        public Builder compareItem(boolean choice) {
            this.item = choice;
            return this;
        }

        public Builder compareCount(boolean choice) {
            this.count = choice;
            return this;
        }

        public Builder compareDamage(boolean choice) {
            this.damage = choice;
            return this;
        }

        public Builder compareMetadata(boolean choice) {
            this.meta = choice;
            return this;
        }

        public Builder compareTag(boolean choice) {
            this.tag = choice;
            return this;
        }

        public ItemStackHashStrategy build() {
            return new ItemStackHashStrategy(){

                public int hashCode(@Nullable ItemStack o) {
                    return o == null || o.func_190926_b() ? 0 : Objects.hash(item ? o.func_77973_b() : null, count ? Integer.valueOf(o.func_190916_E()) : null, damage ? Integer.valueOf(o.func_77952_i()) : null, tag ? o.func_77978_p() : null, meta ? Integer.valueOf(o.func_77960_j()) : null);
                }

                public boolean equals(@Nullable ItemStack a, @Nullable ItemStack b) {
                    if (a == null || a.func_190926_b()) {
                        return b == null || b.func_190926_b();
                    }
                    if (b == null || b.func_190926_b()) {
                        return false;
                    }
                    return !(item && a.func_77973_b() != b.func_77973_b() || count && a.func_190916_E() != b.func_190916_E() || damage && a.func_77952_i() != b.func_77952_i() || meta && a.func_77960_j() != b.func_77960_j() || tag && !Objects.equals(a.func_77978_p(), b.func_77978_p()));
                }
            };
        }
    }
}

