/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.util.FluidStackHashStrategy;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ItemStackHashStrategy;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public final class GTHashMaps {
    private GTHashMaps() {
    }

    @NotNull
    public static Object2IntMap<ItemStack> fromItemHandler(@NotNull IItemHandler inputs) {
        return GTHashMaps.fromItemHandler(inputs, false);
    }

    @NotNull
    public static Object2IntMap<ItemStack> fromItemHandler(@NotNull IItemHandler inputs, boolean linked) {
        Object2IntMap<ItemStack> map = GTHashMaps.createItemStackMap(linked);
        for (int i = 0; i < inputs.getSlots(); ++i) {
            ItemStack stack = inputs.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            if (map.containsKey((Object)stack)) {
                map.merge((Object)stack, (Object)stack.func_190916_E(), Integer::sum);
                continue;
            }
            ItemStack key = GTUtility.copy(1, stack);
            map.put((Object)key, stack.func_190916_E());
        }
        return map;
    }

    @NotNull
    public static Object2IntMap<ItemStack> fromItemStackCollection(@NotNull Iterable<ItemStack> inputs) {
        return GTHashMaps.fromItemStackCollection(inputs, false);
    }

    @NotNull
    public static Object2IntMap<ItemStack> fromItemStackCollection(@NotNull Iterable<ItemStack> inputs, boolean linked) {
        Object2IntMap<ItemStack> map = GTHashMaps.createItemStackMap(linked);
        for (ItemStack stack : inputs) {
            if (stack.func_190926_b()) continue;
            if (map.containsKey((Object)stack)) {
                map.merge((Object)stack, (Object)stack.func_190916_E(), Integer::sum);
                continue;
            }
            map.put((Object)GTUtility.copy(1, stack), stack.func_190916_E());
        }
        return map;
    }

    @NotNull
    public static Object2IntMap<ItemStack> createItemStackMap(boolean linked) {
        ItemStackHashStrategy strategy = ItemStackHashStrategy.comparingAllButCount();
        return linked ? new Object2IntLinkedOpenCustomHashMap((Hash.Strategy)strategy) : new Object2IntOpenCustomHashMap((Hash.Strategy)strategy);
    }

    @NotNull
    public static Object2IntMap<FluidStack> createFluidStackMap(boolean linked) {
        FluidStackHashStrategy strategy = FluidStackHashStrategy.comparingAllButAmount();
        return linked ? new Object2IntLinkedOpenCustomHashMap((Hash.Strategy)strategy) : new Object2IntOpenCustomHashMap((Hash.Strategy)strategy);
    }

    public static Object2IntMap<FluidStack> fromFluidHandler(IFluidHandler fluidInputs) {
        return GTHashMaps.fromFluidHandler(fluidInputs, true);
    }

    public static Object2IntMap<FluidStack> fromFluidHandler(IFluidHandler fluidInputs, boolean linked) {
        Object2IntMap<FluidStack> map = GTHashMaps.createFluidStackMap(linked);
        for (IFluidTankProperties prop : fluidInputs.getTankProperties()) {
            FluidStack fluidStack = prop.getContents();
            if (GTUtility.isEmpty(fluidStack)) continue;
            if (map.containsKey((Object)fluidStack)) {
                map.merge((Object)fluidStack, (Object)fluidStack.amount, Integer::sum);
                continue;
            }
            map.put((Object)GTUtility.copy(1, fluidStack), fluidStack.amount);
        }
        return map;
    }

    public static Object2IntMap<FluidStack> fromFluidCollection(Collection<FluidStack> fluidInputs) {
        return GTHashMaps.fromFluidCollection(fluidInputs, true);
    }

    public static Object2IntMap<FluidStack> fromFluidCollection(Collection<FluidStack> fluidInputs, boolean linked) {
        Object2IntMap<FluidStack> map = GTHashMaps.createFluidStackMap(linked);
        for (FluidStack fluidStack : fluidInputs) {
            if (GTUtility.isEmpty(fluidStack)) continue;
            if (map.containsKey((Object)fluidStack)) {
                map.merge((Object)fluidStack, (Object)fluidStack.amount, Integer::sum);
                continue;
            }
            map.put((Object)GTUtility.copy(1, fluidStack), fluidStack.amount);
        }
        return map;
    }
}

