/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.screen.RichTooltip;
import gregtech.api.fluids.FluidState;
import gregtech.api.fluids.GTFluid;
import gregtech.api.unification.material.Material;
import gregtech.api.util.LocalizationUtils;
import gregtech.client.utils.TooltipHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidTooltipUtil {
    private static final Map<Fluid, List<Supplier<List<String>>>> tooltips = new HashMap<Fluid, List<Supplier<List<String>>>>();

    public static void registerTooltip(@NotNull Fluid fluid, @NotNull Supplier<List<String>> tooltip) {
        List list = tooltips.computeIfAbsent(fluid, $ -> new ArrayList(1));
        list.add(tooltip);
    }

    @NotNull
    public static List<String> getFluidTooltip(@Nullable Fluid fluid) {
        if (fluid == null) {
            return Collections.emptyList();
        }
        List<Supplier<List<String>>> list = tooltips.get(fluid);
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<String> tooltip = new ArrayList<String>();
        for (Supplier<List<String>> supplier : list) {
            tooltip.addAll((Collection<String>)supplier.get());
        }
        return tooltip;
    }

    public static void handleFluidTooltip(@NotNull RichTooltip tooltip, @Nullable Fluid fluid) {
        if (fluid == null) {
            return;
        }
        List<Supplier<List<String>>> tooltipList = tooltips.get(fluid);
        if (tooltipList == null) {
            return;
        }
        for (Supplier<List<String>> subList : tooltipList) {
            for (String tooltipStr : subList.get()) {
                tooltip.addLine((IDrawable)IKey.str((String)tooltipStr));
            }
        }
    }

    @NotNull
    public static List<String> getFluidTooltip(@Nullable FluidStack stack) {
        if (stack == null) {
            return Collections.emptyList();
        }
        return FluidTooltipUtil.getFluidTooltip(stack.getFluid());
    }

    public static void handleFluidTooltip(@NotNull RichTooltip tooltip, @Nullable FluidStack stack) {
        if (stack == null) {
            return;
        }
        FluidTooltipUtil.handleFluidTooltip(tooltip, stack.getFluid());
    }

    @NotNull
    public static List<String> getFluidTooltip(@Nullable String fluidName) {
        if (fluidName == null || fluidName.isEmpty()) {
            return Collections.emptyList();
        }
        return FluidTooltipUtil.getFluidTooltip(FluidRegistry.getFluid((String)fluidName));
    }

    public static Supplier<List<String>> createGTFluidTooltip(@NotNull GTFluid fluid) {
        Material material;
        if (fluid instanceof GTFluid.GTMaterialFluid) {
            GTFluid.GTMaterialFluid matFluid = (GTFluid.GTMaterialFluid)fluid;
            material = matFluid.getMaterial();
        } else {
            material = null;
        }
        Material material2 = material;
        return FluidTooltipUtil.createFluidTooltip(material2, fluid, fluid.getState());
    }

    public static Supplier<List<String>> createFluidTooltip(@Nullable Material material, @NotNull Fluid fluid, @NotNull FluidState fluidState) {
        return () -> {
            ArrayList<String> tooltip = new ArrayList<String>();
            if (material != null && !material.getChemicalFormula().isEmpty()) {
                tooltip.add(TextFormatting.YELLOW + material.getChemicalFormula());
            }
            tooltip.add(I18n.func_135052_a((String)"gregtech.fluid.temperature", (Object[])new Object[]{fluid.getTemperature()}));
            tooltip.add(I18n.func_135052_a((String)fluidState.getTranslationKey(), (Object[])new Object[0]));
            if (fluid instanceof GTFluid) {
                GTFluid gtFluid = (GTFluid)fluid;
                gtFluid.getAttributes().forEach(a -> a.appendFluidTooltips(tooltip));
            }
            if (fluid.getTemperature() < 120) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.fluid.temperature.cryogenic", (Object[])new Object[0]));
            }
            return tooltip;
        };
    }

    public static void addIngotMolFluidTooltip(@NotNull RichTooltip tooltip, @NotNull FluidStack fluidStack) {
        if (TooltipHelper.isShiftDown() && fluidStack.amount > 144) {
            int numIngots = fluidStack.amount / 144;
            int extra = fluidStack.amount % 144;
            String fluidAmount = String.format(" %,d L = %,d * %d L", fluidStack.amount, numIngots, 144);
            if (extra != 0) {
                fluidAmount = fluidAmount + String.format(" + %d L", extra);
            }
            tooltip.add(TextFormatting.GRAY + LocalizationUtils.format("gregtech.gui.amount_raw", new Object[0]) + fluidAmount);
        }
    }
}

