/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.jetbrains.annotations.Nullable;

public class FluidTankSwitchShim
implements IFluidTank,
IFluidHandler {
    @Nullable
    private IFluidTank tank;
    private static final FluidTankInfo NO_INFO = new FluidTankInfo(null, 0);
    private static final IFluidTankProperties[] NO_PROPS = new IFluidTankProperties[0];

    public FluidTankSwitchShim(IFluidTank tank) {
        this.changeTank(tank);
    }

    public void changeTank(IFluidTank tank) {
        if (tank != null && !(tank instanceof IFluidHandler)) {
            throw new IllegalArgumentException("Shim tank must be both IFluidTank and IFluidHandler!");
        }
        this.tank = tank;
    }

    @Nullable
    public FluidStack getFluid() {
        return this.tank == null ? null : this.tank.getFluid();
    }

    public int getFluidAmount() {
        return this.tank == null ? 0 : this.tank.getFluidAmount();
    }

    public int getCapacity() {
        return this.tank == null ? 0 : this.tank.getCapacity();
    }

    public FluidTankInfo getInfo() {
        return this.tank == null ? NO_INFO : this.tank.getInfo();
    }

    public IFluidTankProperties[] getTankProperties() {
        if (this.tank == null) {
            return NO_PROPS;
        }
        return ((IFluidHandler)this.tank).getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.tank == null) {
            return 0;
        }
        return ((IFluidHandler)this.tank).fill(resource, doFill);
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.tank == null) {
            return null;
        }
        return ((IFluidHandler)this.tank).drain(resource, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.tank == null) {
            return null;
        }
        return this.tank.drain(maxDrain, doDrain);
    }
}

