/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import it.unimi.dsi.fastutil.Hash;
import java.util.Objects;
import net.minecraftforge.fluids.FluidStack;

public interface FluidStackHashStrategy
extends Hash.Strategy<FluidStack> {
    public static Builder builder() {
        return new Builder();
    }

    public static FluidStackHashStrategy comparingAll() {
        return FluidStackHashStrategy.builder().compareFluid(true).compareAmount(true).compareNBT(true).build();
    }

    public static FluidStackHashStrategy comparingAllButAmount() {
        return FluidStackHashStrategy.builder().compareFluid(true).compareNBT(true).build();
    }

    public static class Builder {
        private boolean fluid;
        private boolean amount;
        private boolean nbt;

        public Builder compareFluid(boolean choice) {
            this.fluid = choice;
            return this;
        }

        public Builder compareAmount(boolean choice) {
            this.amount = choice;
            return this;
        }

        public Builder compareNBT(boolean choice) {
            this.nbt = choice;
            return this;
        }

        public FluidStackHashStrategy build() {
            return new FluidStackHashStrategy(){

                public int hashCode(FluidStack other) {
                    return other == null ? 0 : Objects.hash(fluid ? other.getFluid() : null, amount ? Integer.valueOf(other.amount) : null, nbt ? other.tag : null);
                }

                public boolean equals(FluidStack a, FluidStack b) {
                    if (a == null) {
                        return b == null;
                    }
                    if (b == null) {
                        return false;
                    }
                    return !(fluid && a.getFluid() != b.getFluid() || amount && a.amount != b.amount || nbt && !Objects.equals(a.tag, b.tag));
                }
            };
        }
    }
}

