/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMaps;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import org.jetbrains.annotations.NotNull;

public class BlockUtility {
    private static final BlockWrapper WRAPPER = new BlockWrapper();
    private static final Object2DoubleMap<IBlockState> walkingSpeedBonusInternal = new Object2DoubleOpenHashMap();
    public static final Object2DoubleMap<IBlockState> WALKING_SPEED_BONUS = Object2DoubleMaps.unmodifiable(walkingSpeedBonusInternal);
    public static final UUID WALKING_SPEED_UUID = UUID.fromString("415ac431-8339-4150-965c-e673a8a328be");
    public static final double ASPHALT_WALKING_SPEED_BONUS = 0.6;
    public static final double STUDS_WALKING_SPEED_BONUS = 0.25;

    public static void startCaptureDrops() {
        WRAPPER.captureDrops(true);
    }

    @NotNull
    public static NonNullList<ItemStack> stopCaptureDrops() {
        return WRAPPER.captureDrops(false);
    }

    public static void setWalkingSpeedBonus(@NotNull IBlockState state, double amount) {
        Objects.requireNonNull(state, "state == null");
        if (!Double.isFinite(amount)) {
            throw new IllegalArgumentException("Haha funny i put NaN and Infinity in your API method haha no");
        }
        if (amount == 0.0) {
            walkingSpeedBonusInternal.remove((Object)state);
        } else {
            walkingSpeedBonusInternal.put((Object)state, amount);
        }
    }

    private static class BlockWrapper
    extends Block {
        public BlockWrapper() {
            super(Material.field_151579_a);
        }

        @NotNull
        public NonNullList<ItemStack> captureDrops(boolean start) {
            return super.captureDrops(start);
        }
    }
}

