/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.stack;

import gregtech.api.unification.stack.MaterialStack;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

public final class RecyclingData {
    private final List<MaterialStack> materials;

    public RecyclingData(MaterialStack ... materials) {
        this(Arrays.asList(materials));
    }

    public RecyclingData(@NotNull List<MaterialStack> materials) {
        if (materials.isEmpty()) {
            throw new IllegalArgumentException("materials cannot be empty");
        }
        this.materials = materials;
    }

    public @UnmodifiableView @NotNull List<MaterialStack> getMaterials() {
        return Collections.unmodifiableList(this.materials);
    }

    public boolean equals(Object o) {
        if (!(o instanceof RecyclingData)) {
            return false;
        }
        RecyclingData data = (RecyclingData)o;
        return this.materials.equals(data.materials);
    }

    public int hashCode() {
        return this.materials.hashCode();
    }

    public String toString() {
        return "RecyclingData{materials=" + this.materials + '}';
    }
}

