/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.stack;

import crafttweaker.annotations.ZenRegister;
import gregtech.api.unification.material.Material;
import gregtech.api.util.SmallDigits;
import org.jetbrains.annotations.NotNull;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenProperty;

@ZenClass(value="mods.gregtech.material.MaterialStack")
@ZenRegister
public class MaterialStack {
    @ZenProperty
    public final Material material;
    @ZenProperty
    public final long amount;

    public MaterialStack(Material material, long amount) {
        this.material = material;
        this.amount = amount;
    }

    @ZenMethod
    public MaterialStack copy(long amount) {
        return new MaterialStack(this.material, amount);
    }

    @ZenMethod
    public MaterialStack copy() {
        return new MaterialStack(this.material, this.amount);
    }

    @ZenMethod
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaterialStack that = (MaterialStack)o;
        if (this.amount != that.amount) {
            return false;
        }
        return this.material.equals(that.material);
    }

    public int hashCode() {
        return this.material.hashCode();
    }

    @ZenMethod(value="toString")
    @NotNull
    public String toFormatted() {
        String chemicalFormula = this.material.getChemicalFormula();
        StringBuilder builder = new StringBuilder(chemicalFormula.length());
        if (chemicalFormula.isEmpty()) {
            builder.append('?');
        } else if (this.material.getMaterialComponents().size() > 1) {
            builder.append('(');
            builder.append(chemicalFormula);
            builder.append(')');
        } else {
            builder.append(chemicalFormula);
        }
        if (this.amount > 1L) {
            builder.append(SmallDigits.toSmallDownNumbers(String.valueOf(this.amount)));
        }
        return builder.toString();
    }

    public String toString() {
        return "MaterialStack{material=" + this.material + ", amount=" + this.amount + '}';
    }
}

