/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.properties;

import gregtech.api.GTValues;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.MaterialProperties;
import gregtech.api.unification.material.properties.PropertyKey;
import java.util.Objects;

public class WireProperties
implements IMaterialProperty {
    private int voltage;
    private int amperage;
    private int lossPerBlock;
    private int superconductorCriticalTemperature;
    private boolean isSuperconductor;

    public WireProperties(int voltage, int baseAmperage, int lossPerBlock) {
        this(voltage, baseAmperage, lossPerBlock, false);
    }

    public WireProperties(int voltage, int baseAmperage, int lossPerBlock, boolean isSuperCon) {
        this(voltage, baseAmperage, lossPerBlock, isSuperCon, 0);
    }

    public WireProperties(int voltage, int baseAmperage, int lossPerBlock, boolean isSuperCon, int criticalTemperature) {
        this.voltage = voltage;
        this.amperage = baseAmperage;
        this.lossPerBlock = isSuperCon ? 0 : lossPerBlock;
        this.superconductorCriticalTemperature = isSuperCon ? criticalTemperature : 0;
        this.isSuperconductor = isSuperCon;
    }

    public WireProperties() {
        this(8, 1, 1, false);
    }

    public int getVoltage() {
        return this.voltage;
    }

    public WireProperties setVoltage(int voltage) {
        this.voltage = voltage;
        return this;
    }

    public int getAmperage() {
        return this.amperage;
    }

    public WireProperties setAmperage(int amperage) {
        this.amperage = amperage;
        return this;
    }

    public int getLossPerBlock() {
        return this.lossPerBlock;
    }

    public WireProperties setLossPerBlock(int lossPerBlock) {
        this.lossPerBlock = lossPerBlock;
        return this;
    }

    public boolean isSuperconductor() {
        return this.isSuperconductor;
    }

    public WireProperties setSuperconductor(boolean isSuperconductor) {
        this.isSuperconductor = isSuperconductor;
        return this;
    }

    public int getSuperconductorCriticalTemperature() {
        return this.superconductorCriticalTemperature;
    }

    public WireProperties setSuperconductorCriticalTemperature(int criticalTemperature) {
        this.superconductorCriticalTemperature = this.isSuperconductor ? criticalTemperature : 0;
        return this;
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
        properties.ensureSet(PropertyKey.DUST, true);
        if (properties.hasProperty(PropertyKey.INGOT)) {
            Material thisMaterial = properties.getMaterial();
            if (!this.isSuperconductor && (long)this.voltage >= GTValues.V[5] && !thisMaterial.hasFlag(MaterialFlags.GENERATE_FOIL)) {
                thisMaterial.addFlags(MaterialFlags.GENERATE_FOIL);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WireProperties)) {
            return false;
        }
        WireProperties that = (WireProperties)o;
        return this.voltage == that.voltage && this.amperage == that.amperage && this.lossPerBlock == that.lossPerBlock && this.superconductorCriticalTemperature == that.superconductorCriticalTemperature && this.isSuperconductor == that.isSuperconductor;
    }

    public int hashCode() {
        return Objects.hash(this.voltage, this.amperage, this.lossPerBlock);
    }
}

