/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.properties;

import gregtech.api.items.toolitem.EnchantmentLevel;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import net.minecraft.enchantment.Enchantment;

public class ToolProperty {
    private float harvestSpeed;
    private float attackDamage;
    private float attackSpeed;
    private int durability;
    private int harvestLevel;
    private int enchantability;
    private int durabilityMultiplier;
    private boolean ignoreCraftingTools;
    private boolean isUnbreakable;
    private boolean isMagnetic;
    private final Object2ObjectMap<Enchantment, EnchantmentLevel> enchantments;

    public ToolProperty(float harvestSpeed, float attackDamage, int durability, int harvestLevel) {
        this.harvestSpeed = harvestSpeed;
        this.attackDamage = attackDamage;
        this.durability = durability;
        this.harvestLevel = harvestLevel;
        this.enchantments = new Object2ObjectArrayMap();
    }

    public ToolProperty() {
        this(1.0f, 1.0f, 100, 2);
    }

    public ToolProperty(ToolProperty property) {
        this.harvestSpeed = property.harvestSpeed;
        this.attackDamage = property.attackDamage;
        this.attackSpeed = property.attackSpeed;
        this.durability = property.durability;
        this.harvestLevel = property.harvestLevel;
        this.enchantability = property.enchantability;
        this.durabilityMultiplier = property.durabilityMultiplier;
        this.ignoreCraftingTools = property.ignoreCraftingTools;
        this.isUnbreakable = property.isUnbreakable;
        this.isMagnetic = property.isMagnetic;
        this.enchantments = new Object2ObjectArrayMap(property.enchantments);
    }

    public float getToolSpeed() {
        return this.harvestSpeed;
    }

    public ToolProperty setToolSpeed(float toolSpeed) {
        this.harvestSpeed = toolSpeed;
        return this;
    }

    public float getToolAttackDamage() {
        return this.attackDamage;
    }

    public ToolProperty setToolAttackDamage(float toolAttackDamage) {
        this.attackDamage = toolAttackDamage;
        return this;
    }

    public float getToolAttackSpeed() {
        return this.attackSpeed;
    }

    public ToolProperty setToolAttackSpeed(float toolAttackSpeed) {
        this.attackSpeed = toolAttackSpeed;
        return this;
    }

    public int getToolDurability() {
        return this.durability;
    }

    public ToolProperty setToolDurability(int toolDurability) {
        this.durability = toolDurability;
        return this;
    }

    public int getToolHarvestLevel() {
        return this.harvestLevel;
    }

    public ToolProperty setToolHarvestLevel(int toolHarvestLevel) {
        this.harvestLevel = toolHarvestLevel;
        return this;
    }

    public int getToolEnchantability() {
        return this.enchantability;
    }

    public ToolProperty setToolEnchantability(int toolEnchantability) {
        this.enchantability = toolEnchantability;
        return this;
    }

    public boolean getShouldIgnoreCraftingTools() {
        return this.ignoreCraftingTools;
    }

    public ToolProperty setShouldIgnoreCraftingTools(boolean ignore) {
        this.ignoreCraftingTools = ignore;
        return this;
    }

    public boolean getUnbreakable() {
        return this.isUnbreakable;
    }

    public ToolProperty setUnbreakable(boolean isUnbreakable) {
        this.isUnbreakable = isUnbreakable;
        return this;
    }

    public Object2ObjectMap<Enchantment, EnchantmentLevel> getEnchantments() {
        return this.enchantments;
    }

    public ToolProperty setMagnetic(boolean isMagnetic) {
        this.isMagnetic = isMagnetic;
        return this;
    }

    public boolean isMagnetic() {
        return this.isMagnetic;
    }

    public ToolProperty setDurabilityMultiplier(int multiplier) {
        this.durabilityMultiplier = multiplier;
        return this;
    }

    public int getDurabilityMultiplier() {
        return this.durabilityMultiplier;
    }

    public void addEnchantmentForTools(Enchantment enchantment, int level) {
        this.addEnchantmentForTools(enchantment, level, 0.0);
    }

    public void addEnchantmentForTools(Enchantment enchantment, double level, double levelGrowth) {
        this.enchantments.put((Object)enchantment, (Object)new EnchantmentLevel(level, levelGrowth));
    }
}

