/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.properties;

import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.MaterialProperties;
import gregtech.api.unification.material.properties.PropertyKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OreProperty
implements IMaterialProperty {
    private final List<Material> oreByProducts = new ArrayList<Material>();
    private int oreMultiplier;
    private int byProductMultiplier;
    private boolean emissive;
    @Nullable
    private Material directSmeltResult;
    @Nullable
    private Material washedIn;
    private int washedAmount = 100;
    private final List<Material> separatedInto = new ArrayList<Material>();

    public OreProperty(int oreMultiplier, int byProductMultiplier) {
        this.oreMultiplier = oreMultiplier;
        this.byProductMultiplier = byProductMultiplier;
        this.emissive = false;
    }

    public OreProperty(int oreMultiplier, int byProductMultiplier, boolean emissive) {
        this.oreMultiplier = oreMultiplier;
        this.byProductMultiplier = byProductMultiplier;
        this.emissive = emissive;
    }

    public OreProperty() {
        this(1, 1);
    }

    public OreProperty setOreMultiplier(int multiplier) {
        this.oreMultiplier = multiplier;
        return this;
    }

    public int getOreMultiplier() {
        return this.oreMultiplier;
    }

    public OreProperty setByProductMultiplier(int multiplier) {
        this.byProductMultiplier = multiplier;
        return this;
    }

    public int getByProductMultiplier() {
        return this.byProductMultiplier;
    }

    public boolean isEmissive() {
        return this.emissive;
    }

    public OreProperty setEmissive(boolean emissive) {
        this.emissive = emissive;
        return this;
    }

    public OreProperty setDirectSmeltResult(@Nullable Material m) {
        this.directSmeltResult = m;
        return this;
    }

    @Nullable
    public Material getDirectSmeltResult() {
        return this.directSmeltResult;
    }

    public OreProperty setWashedIn(@Nullable Material m) {
        this.washedIn = m;
        return this;
    }

    public OreProperty setWashedIn(@Nullable Material m, int washedAmount) {
        this.washedIn = m;
        this.washedAmount = washedAmount;
        return this;
    }

    public Pair<Material, Integer> getWashedIn() {
        return Pair.of((Object)this.washedIn, (Object)this.washedAmount);
    }

    public OreProperty setSeparatedInto(Material ... materials) {
        this.separatedInto.addAll(Arrays.asList(materials));
        return this;
    }

    @Nullable
    public List<Material> getSeparatedInto() {
        return this.separatedInto;
    }

    public OreProperty setOreByProducts(Material ... materials) {
        this.setOreByProducts(Arrays.asList(materials));
        return this;
    }

    public OreProperty setOreByProducts(@NotNull Collection<Material> materials) {
        this.oreByProducts.clear();
        this.oreByProducts.addAll(materials);
        return this;
    }

    public OreProperty addOreByProducts(Material ... materials) {
        this.oreByProducts.addAll(Arrays.asList(materials));
        return this;
    }

    public List<Material> getOreByProducts() {
        return this.oreByProducts;
    }

    @Nullable
    public final Material getOreByProduct(int index) {
        if (this.oreByProducts.isEmpty()) {
            return null;
        }
        return this.oreByProducts.get(MathHelper.func_76125_a((int)index, (int)0, (int)(this.oreByProducts.size() - 1)));
    }

    @NotNull
    public final Material getOreByProduct(int index, @NotNull Material fallback) {
        Material material = this.getOreByProduct(index);
        return material != null ? material : fallback;
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
        properties.ensureSet(PropertyKey.DUST, true);
        if (this.directSmeltResult != null) {
            this.directSmeltResult.getProperties().ensureSet(PropertyKey.DUST, true);
        }
        if (this.washedIn != null) {
            this.washedIn.getProperties().ensureSet(PropertyKey.FLUID, true);
        }
        this.separatedInto.forEach(m -> m.getProperties().ensureSet(PropertyKey.DUST, true));
        this.oreByProducts.forEach(m -> m.getProperties().ensureSet(PropertyKey.DUST, true));
    }
}

