/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.properties;

import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.MaterialProperties;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.material.properties.ToolProperty;
import net.minecraft.enchantment.Enchantment;

public class MaterialToolProperty
extends ToolProperty
implements IMaterialProperty {
    public MaterialToolProperty(float harvestSpeed, float attackDamage, int durability, int harvestLevel) {
        super(harvestSpeed, attackDamage, durability, harvestLevel);
        this.setToolEnchantability(10);
        this.setDurabilityMultiplier(1);
    }

    public MaterialToolProperty() {
        this(1.0f, 1.0f, 100, 2);
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
        if (!properties.hasProperty(PropertyKey.GEM)) {
            properties.ensureSet(PropertyKey.INGOT, true);
        }
    }

    public static class Builder {
        private final MaterialToolProperty materialToolProperty;

        public static Builder of(float harvestSpeed, float attackDamage, int durability, int harvestLevel) {
            return new Builder(harvestSpeed, attackDamage, durability, harvestLevel);
        }

        private Builder(float harvestSpeed, float attackDamage, int durability, int harvestLevel) {
            this.materialToolProperty = new MaterialToolProperty(harvestSpeed, attackDamage, durability, harvestLevel);
        }

        public Builder enchantability(int enchantability) {
            this.materialToolProperty.setToolEnchantability(enchantability);
            return this;
        }

        public Builder attackSpeed(float attackSpeed) {
            this.materialToolProperty.setToolAttackSpeed(attackSpeed);
            return this;
        }

        public Builder ignoreCraftingTools() {
            this.materialToolProperty.setShouldIgnoreCraftingTools(true);
            return this;
        }

        public Builder unbreakable() {
            this.materialToolProperty.setUnbreakable(true);
            return this;
        }

        public Builder enchantment(Enchantment enchantment, int level) {
            this.materialToolProperty.addEnchantmentForTools(enchantment, level);
            return this;
        }

        public Builder magnetic() {
            this.materialToolProperty.setMagnetic(true);
            return this;
        }

        public Builder durabilityMultiplier(int multiplier) {
            this.materialToolProperty.setDurabilityMultiplier(multiplier);
            return this;
        }

        public MaterialToolProperty build() {
            return this.materialToolProperty;
        }
    }
}

