/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.properties;

import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.MaterialProperties;
import gregtech.api.unification.material.properties.PropertyKey;
import java.util.Objects;

public class ItemPipeProperties
implements IMaterialProperty {
    private int priority;
    private float transferRate;

    public ItemPipeProperties(int priority, float transferRate) {
        this.priority = priority;
        this.transferRate = transferRate;
    }

    public ItemPipeProperties() {
        this(1, 0.25f);
    }

    public int getPriority() {
        return this.priority;
    }

    public ItemPipeProperties setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public float getTransferRate() {
        return this.transferRate;
    }

    public ItemPipeProperties setTransferRate(float transferRate) {
        this.transferRate = transferRate;
        return this;
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
        if (!properties.hasProperty(PropertyKey.WOOD)) {
            properties.ensureSet(PropertyKey.INGOT, true);
        }
        if (properties.hasProperty(PropertyKey.FLUID_PIPE)) {
            throw new IllegalStateException("Material " + properties.getMaterial() + " has both Fluid and Item Pipe Property, which is not allowed!");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemPipeProperties that = (ItemPipeProperties)o;
        return this.priority == that.priority && Float.compare(that.transferRate, this.transferRate) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.priority, Float.valueOf(this.transferRate));
    }

    public String toString() {
        return "ItemPipeProperties{priority=" + this.priority + ", transferRate=" + this.transferRate + '}';
    }
}

