/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.properties;

import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.MaterialProperties;
import gregtech.api.unification.material.properties.PropertyKey;
import org.jetbrains.annotations.Nullable;

public class IngotProperty
implements IMaterialProperty {
    private Material smeltInto;
    private Material arcSmeltInto;
    private Material macerateInto;
    @Nullable
    private Material magneticMaterial;

    public IngotProperty setSmeltingInto(Material smeltInto) {
        this.smeltInto = smeltInto;
        return this;
    }

    public Material getSmeltingInto() {
        return this.smeltInto;
    }

    public IngotProperty setArcSmeltingInto(Material arcSmeltingInto) {
        this.arcSmeltInto = arcSmeltingInto;
        return this;
    }

    public Material getArcSmeltInto() {
        return this.arcSmeltInto;
    }

    public IngotProperty setMagneticMaterial(@Nullable Material magneticMaterial) {
        this.magneticMaterial = magneticMaterial;
        return this;
    }

    @Nullable
    public Material getMagneticMaterial() {
        return this.magneticMaterial;
    }

    public IngotProperty setMacerateInto(Material macerateInto) {
        this.macerateInto = macerateInto;
        return this;
    }

    public Material getMacerateInto() {
        return this.macerateInto;
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
        properties.ensureSet(PropertyKey.DUST, true);
        if (properties.hasProperty(PropertyKey.GEM)) {
            throw new IllegalStateException("Material " + properties.getMaterial() + " has both Ingot and Gem Property, which is not allowed!");
        }
        if (this.smeltInto == null) {
            this.smeltInto = properties.getMaterial();
        } else {
            this.smeltInto.getProperties().ensureSet(PropertyKey.INGOT, true);
        }
        if (this.arcSmeltInto == null) {
            this.arcSmeltInto = properties.getMaterial();
        } else {
            this.arcSmeltInto.getProperties().ensureSet(PropertyKey.INGOT, true);
        }
        if (this.macerateInto == null) {
            this.macerateInto = properties.getMaterial();
        } else {
            this.macerateInto.getProperties().ensureSet(PropertyKey.INGOT, true);
        }
        if (this.magneticMaterial != null) {
            this.magneticMaterial.getProperties().ensureSet(PropertyKey.INGOT, true);
        }
    }
}

