/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.properties;

import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.MaterialProperties;
import gregtech.api.unification.material.properties.MaterialToolProperty;
import gregtech.api.unification.material.properties.ToolProperty;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraToolProperty
implements IMaterialProperty {
    private final Map<String, OverrideToolProperty> overrideMap = new HashMap<String, OverrideToolProperty>();

    public void setOverrideProperty(String toolId, OverrideToolProperty overrideProperty) {
        this.overrideMap.put(toolId, overrideProperty);
    }

    @Nullable
    public OverrideToolProperty getOverrideProperty(String toolId) {
        return this.overrideMap.get(toolId);
    }

    public boolean hasOverrideProperty(String toolId) {
        return this.overrideMap.containsKey(toolId);
    }

    public ToolProperty getOverriddenResult(String toolId, @Nullable MaterialToolProperty materialToolProperty) {
        if (materialToolProperty == null) {
            materialToolProperty = new MaterialToolProperty();
        }
        return this.overrideMap.getOrDefault(toolId, new OverrideToolProperty()).override(materialToolProperty);
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
    }

    public static class OverrideToolProperty
    extends ToolProperty {
        public OverrideToolProperty() {
            this.setToolSpeed(Float.NaN);
            this.setToolAttackSpeed(Float.NaN);
            this.setToolAttackDamage(Float.NaN);
            this.setToolDurability(-1);
            this.setToolHarvestLevel(-1);
            this.setToolEnchantability(-1);
            this.setDurabilityMultiplier(-1);
        }

        @Override
        public OverrideToolProperty setShouldIgnoreCraftingTools(boolean ignore) {
            throw new UnsupportedOperationException();
        }

        @Override
        public OverrideToolProperty setUnbreakable(boolean isUnbreakable) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isMagnetic() {
            throw new UnsupportedOperationException();
        }

        private ToolProperty override(@NotNull ToolProperty property) {
            ToolProperty result = new ToolProperty(property);
            if (!Float.isNaN(this.getToolSpeed())) {
                result.setToolSpeed(this.getToolSpeed());
            }
            if (!Float.isNaN(this.getToolAttackSpeed())) {
                result.setToolAttackSpeed(this.getToolAttackSpeed());
            }
            if (!Float.isNaN(this.getToolAttackDamage())) {
                result.setToolAttackDamage(this.getToolAttackDamage());
            }
            if (this.getToolDurability() != -1) {
                result.setToolDurability(this.getToolDurability());
            }
            if (this.getToolHarvestLevel() != -1) {
                result.setToolHarvestLevel(this.getToolHarvestLevel());
            }
            if (this.getToolEnchantability() != -1) {
                result.setToolEnchantability(this.getToolEnchantability());
            }
            if (this.getDurabilityMultiplier() != -1) {
                result.setDurabilityMultiplier(this.getDurabilityMultiplier());
            }
            result.getEnchantments().putAll(this.getEnchantments());
            return result;
        }
    }

    public static class Builder {
        private final OverrideToolProperty toolProperty = new OverrideToolProperty();

        public static Builder of() {
            return new Builder();
        }

        public static Builder of(int durability) {
            Builder builder = new Builder();
            builder.durability(durability);
            return builder;
        }

        public static Builder of(float harvestSpeed, float attackDamage, int durability, int harvestLevel) {
            Builder builder = new Builder();
            builder.harvestSpeed(harvestSpeed).attackDamage(attackDamage).durability(durability).harvestLevel(harvestLevel);
            return builder;
        }

        public Builder harvestSpeed(float harvestSpeed) {
            this.toolProperty.setToolSpeed(harvestSpeed);
            return this;
        }

        public Builder attackDamage(float attackDamage) {
            this.toolProperty.setToolAttackDamage(attackDamage);
            return this;
        }

        public Builder durability(int durability) {
            this.toolProperty.setToolDurability(durability);
            return this;
        }

        public Builder attackSpeed(float attackSpeed) {
            this.toolProperty.setToolAttackSpeed(attackSpeed);
            return this;
        }

        public Builder harvestLevel(int harvestLevel) {
            this.toolProperty.setToolHarvestLevel(harvestLevel);
            return this;
        }

        public Builder enchantment(Enchantment enchantment, int level) {
            this.toolProperty.addEnchantmentForTools(enchantment, level);
            return this;
        }

        public Builder durabilityMultiplier(int multiplier) {
            this.toolProperty.setDurabilityMultiplier(multiplier);
            return this;
        }

        public OverrideToolProperty build() {
            return this.toolProperty;
        }
    }
}

