/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.properties;

import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.MaterialProperties;

public class DustProperty
implements IMaterialProperty {
    private int harvestLevel;
    private int burnTime;

    public DustProperty(int harvestLevel, int burnTime) {
        this.harvestLevel = harvestLevel;
        this.burnTime = burnTime;
    }

    public DustProperty() {
        this(2, 0);
    }

    public DustProperty setHarvestLevel(int harvestLevel) {
        if (harvestLevel <= 0) {
            throw new IllegalArgumentException("Harvest Level must be greater than zero!");
        }
        this.harvestLevel = harvestLevel;
        return this;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public DustProperty setBurnTime(int burnTime) {
        if (burnTime < 0) {
            throw new IllegalArgumentException("Burn Time cannot be negative!");
        }
        this.burnTime = burnTime;
        return this;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
    }
}

