/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.materials;

import gregtech.api.recipes.ModHandler;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.properties.ExtraToolProperty;
import gregtech.api.unification.material.properties.PropertyKey;

public class SoftToolAddition {
    public static final Material[] softMaterials = new Material[]{Materials.Wood, Materials.Rubber, Materials.Polyethylene, Materials.Polytetrafluoroethylene, Materials.Polybenzimidazole};

    public static void register() {
        for (int i = 0; i < softMaterials.length; ++i) {
            ExtraToolProperty extraToolProperty;
            Material material = softMaterials[i];
            if (ModHandler.isMaterialWood(material)) {
                material.getProperties().ensureSet(PropertyKey.EXTRATOOL);
                extraToolProperty = material.getProperty(PropertyKey.EXTRATOOL);
                extraToolProperty.setOverrideProperty("mallet", ExtraToolProperty.Builder.of(4.0f, 1.0f, 48, 1).build());
                continue;
            }
            material.getProperties().ensureSet(PropertyKey.EXTRATOOL);
            extraToolProperty = material.getProperty(PropertyKey.EXTRATOOL);
            extraToolProperty.setOverrideProperty("mallet", ExtraToolProperty.Builder.of(4.0f, 1.0f, 128 * (1 << i), 1).build());
            extraToolProperty.setOverrideProperty("plunger", ExtraToolProperty.Builder.of(4.0f, 0.0f, 128 * (1 << i), 1).build());
        }
    }
}

