/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification;

import gregtech.api.unification.stack.ItemAndMetadata;
import gregtech.api.unification.stack.RecyclingData;
import gregtech.api.util.GTUtility;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RecyclingManager {
    private final Map<ItemAndMetadata, RecyclingData> map = new Object2ObjectOpenHashMap();

    public void registerRecyclingData(@NotNull ItemStack stack, @NotNull RecyclingData data) {
        if (stack.func_190926_b()) {
            return;
        }
        this.registerRecyclingData(new ItemAndMetadata(stack), data);
    }

    public void registerRecyclingData(@NotNull ItemAndMetadata key, @NotNull RecyclingData data) {
        this.map.put(key, data);
    }

    @Nullable
    public RecyclingData getRecyclingData(@NotNull ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        return this.getRecyclingData(new ItemAndMetadata(stack));
    }

    @Nullable
    public RecyclingData getRecyclingData(@NotNull ItemAndMetadata key) {
        return GTUtility.getOrWildcardMeta(this.map, key);
    }

    public void removeRecyclingData(@NotNull ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        this.removeRecyclingData(new ItemAndMetadata(stack));
    }

    public void removeRecyclingData(@NotNull ItemAndMetadata key) {
        this.map.remove(key);
    }

    public void iterate(@NotNull BiConsumer<ItemAndMetadata, RecyclingData> action) {
        this.map.forEach(action);
    }
}

