/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import gregtech.api.GregTechAPI;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.material.registry.MaterialRegistry;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.ItemAndMetadata;
import gregtech.api.unification.stack.ItemVariantMap;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.unification.stack.MultiItemVariantMap;
import gregtech.api.unification.stack.SingleItemVariantMap;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.CustomModPriorityComparator;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OreDictUnifier {
    private static final Map<ItemAndMetadata, UnificationEntry> stackUnificationInfo = new Object2ObjectOpenHashMap();
    private static final Map<UnificationEntry, ArrayList<ItemAndMetadata>> stackUnificationItems = new Object2ObjectOpenHashMap();
    private static final Map<Item, ItemVariantMap.Mutable<Set<String>>> stackOreDictName = new Object2ObjectOpenHashMap();
    private static final Map<String, List<ItemStack>> oreDictNameStacks = new Object2ObjectOpenHashMap();
    @Nullable
    private static Comparator<ItemAndMetadata> stackComparator;

    private OreDictUnifier() {
    }

    public static Comparator<ItemAndMetadata> getSimpleItemStackComparator() {
        if (stackComparator == null) {
            List<String> modPriorities = Arrays.asList(ConfigHolder.compat.modPriorities);
            if (modPriorities.isEmpty()) {
                Function<ItemAndMetadata, String> modIdExtractor = stack -> stack.item.getRegistryName().func_110624_b();
                stackComparator = Comparator.comparing(modIdExtractor);
            } else {
                stackComparator = Collections.reverseOrder(new CustomModPriorityComparator(modPriorities));
            }
        }
        return stackComparator;
    }

    public static Comparator<ItemStack> getItemStackComparator() {
        Comparator<ItemAndMetadata> comparator = OreDictUnifier.getSimpleItemStackComparator();
        return (first, second) -> comparator.compare(new ItemAndMetadata((ItemStack)first), new ItemAndMetadata((ItemStack)second));
    }

    public static void registerOre(ItemStack itemStack, OrePrefix orePrefix, @Nullable Material material) {
        OreDictUnifier.registerOre(itemStack, orePrefix.name(), material);
    }

    public static void registerOre(ItemStack itemStack, String customOrePrefix, @Nullable Material material) {
        if (itemStack.func_190926_b()) {
            return;
        }
        OreDictionary.registerOre((String)(customOrePrefix + (material == null ? "" : material.toCamelCaseString())), (ItemStack)itemStack);
    }

    public static void registerOre(ItemStack itemStack, String oreDict) {
        if (itemStack.func_190926_b()) {
            return;
        }
        OreDictionary.registerOre((String)oreDict, (ItemStack)itemStack);
    }

    public static void init() {
        for (String registeredOreName : OreDictionary.getOreNames()) {
            for (ItemStack itemStack : OreDictionary.getOres((String)registeredOreName)) {
                OreDictUnifier.onItemRegistration(new OreDictionary.OreRegisterEvent(registeredOreName, itemStack));
            }
        }
        MinecraftForge.EVENT_BUS.register(OreDictUnifier.class);
    }

    @SubscribeEvent
    public static void onItemRegistration(OreDictionary.OreRegisterEvent event) {
        String oreName = event.getName();
        ItemVariantMap.Mutable entry = stackOreDictName.computeIfAbsent(event.getOre().func_77973_b(), item -> item.func_77614_k() ? new MultiItemVariantMap() : new SingleItemVariantMap());
        Set set = (Set)entry.get(event.getOre());
        if (set == null) {
            set = new ObjectOpenHashSet();
            entry.put(event.getOre(), set);
        }
        set.add(oreName);
        List itemStackListForOreDictName = oreDictNameStacks.computeIfAbsent(oreName, k -> new ArrayList());
        OreDictUnifier.addAndSort(itemStackListForOreDictName, event.getOre().func_77946_l(), OreDictUnifier.getItemStackComparator());
        OrePrefix orePrefix = OrePrefix.getPrefix(oreName);
        Material material = null;
        if (orePrefix == null) {
            ArrayList<String> splits = new ArrayList<String>();
            StringBuilder builder = new StringBuilder();
            for (char character : oreName.toCharArray()) {
                if (Character.isUpperCase(character)) {
                    if (builder.length() > 0) {
                        splits.add(builder.toString());
                        builder = new StringBuilder().append(character);
                        continue;
                    }
                    splits.add(Character.toString(character));
                    continue;
                }
                builder.append(character);
            }
            if (builder.length() > 0) {
                splits.add(builder.toString());
            }
            Object object = GregTechAPI.materialManager.getRegistries().iterator();
            while (object.hasNext()) {
                MaterialRegistry registry = (MaterialRegistry)((Object)object.next());
                StringBuilder buffer = new StringBuilder();
                for (int i = 0; i < splits.size(); ++i) {
                    buffer.append((String)splits.get(i));
                    OrePrefix maybePrefix = OrePrefix.getPrefix(buffer.toString());
                    String possibleMaterialName = Joiner.on((String)"").join(splits.subList(i + 1, splits.size()));
                    String underscoreName = GTUtility.toLowerCaseUnderscore(possibleMaterialName);
                    Material possibleMaterial = (Material)registry.func_82594_a(underscoreName);
                    if (possibleMaterial == null) {
                        possibleMaterial = GregTechAPI.markerMaterialRegistry.getMarkerMaterial(underscoreName);
                    }
                    if (maybePrefix == null || possibleMaterial == null) continue;
                    orePrefix = maybePrefix;
                    material = possibleMaterial;
                    break;
                }
                if (material == null) continue;
                break;
            }
        }
        if (orePrefix != null && (material != null || orePrefix.isSelfReferencing)) {
            ItemAndMetadata key = new ItemAndMetadata(event.getOre());
            UnificationEntry unificationEntry = new UnificationEntry(orePrefix, material);
            ArrayList itemListForUnifiedEntry = stackUnificationItems.computeIfAbsent(unificationEntry, p -> new ArrayList());
            OreDictUnifier.addAndSort(itemListForUnifiedEntry, key, OreDictUnifier.getSimpleItemStackComparator());
            if (!unificationEntry.orePrefix.isMarkerPrefix()) {
                stackUnificationInfo.put(key, unificationEntry);
            }
            orePrefix.processOreRegistration(material);
        }
    }

    @NotNull
    public static Set<String> getOreDictionaryNames(@NotNull ItemStack itemStack) {
        Set wildcardNames;
        if (itemStack.func_190926_b()) {
            return Collections.emptySet();
        }
        ItemVariantMap nameEntry = stackOreDictName.get(itemStack.func_77973_b());
        if (nameEntry == null) {
            return Collections.emptySet();
        }
        short itemDamage = (short)itemStack.func_77952_i();
        Set names = (Set)nameEntry.get(itemDamage);
        Set set = wildcardNames = itemDamage == Short.MAX_VALUE ? null : (Set)nameEntry.get((short)Short.MAX_VALUE);
        if (names == null) {
            return wildcardNames == null ? Collections.emptySet() : Collections.unmodifiableSet(wildcardNames);
        }
        if (wildcardNames == null || names == wildcardNames) {
            return Collections.unmodifiableSet(names);
        }
        return Sets.union((Set)names, (Set)wildcardNames);
    }

    @Nullable
    public static ItemVariantMap<Set<String>> getOreDictionaryEntry(@NotNull Item item) {
        ItemVariantMap.Mutable<Set<String>> entry = stackOreDictName.get(item);
        return entry == null ? null : ItemVariantMap.unmodifiableSetView(entry);
    }

    @NotNull
    public static ItemVariantMap<Set<String>> getOreDictionaryEntryOrEmpty(@NotNull Item item) {
        ItemVariantMap.Mutable<Set<String>> entry = stackOreDictName.get(item);
        return entry == null ? ItemVariantMap.empty() : ItemVariantMap.unmodifiableSetView(entry);
    }

    public static boolean hasOreDictionaryEntry(@NotNull Item item) {
        return stackOreDictName.containsKey(item);
    }

    public static boolean hasOreDictionary(@NotNull ItemStack itemStack, @NotNull String oreDictName) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        ItemVariantMap nameEntry = stackOreDictName.get(itemStack.func_77973_b());
        if (nameEntry == null) {
            return false;
        }
        short itemDamage = (short)itemStack.func_77952_i();
        Set names = (Set)nameEntry.get(itemDamage);
        if (names != null && names.contains(oreDictName)) {
            return true;
        }
        if (itemDamage == Short.MAX_VALUE) {
            return false;
        }
        Set wildcardNames = (Set)nameEntry.get((short)Short.MAX_VALUE);
        return wildcardNames != null && wildcardNames != names && wildcardNames.contains(oreDictName);
    }

    @NotNull
    public static @NotNull List<@NotNull ItemStack> getAllWithOreDictionaryName(@NotNull String oreDictionaryName) {
        List<ItemStack> stacks = oreDictNameStacks.get(oreDictionaryName);
        if (stacks == null) {
            return Collections.emptyList();
        }
        return stacks.stream().map(ItemStack::func_77946_l).collect(Collectors.toList());
    }

    @Nullable
    public static MaterialStack getMaterial(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        ItemAndMetadata key = new ItemAndMetadata(itemStack);
        UnificationEntry entry = GTUtility.getOrWildcardMeta(stackUnificationInfo, key);
        if (entry != null) {
            Material entryMaterial = entry.material;
            if (entryMaterial == null) {
                entryMaterial = entry.orePrefix.materialType;
            }
            if (entryMaterial != null) {
                return new MaterialStack(entryMaterial, entry.orePrefix.getMaterialAmount(entryMaterial));
            }
        }
        return null;
    }

    @Nullable
    public static OrePrefix getPrefix(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        UnificationEntry entry = GTUtility.getOrWildcardMeta(stackUnificationInfo, new ItemAndMetadata(itemStack));
        return entry != null ? entry.orePrefix : null;
    }

    @Nullable
    public static UnificationEntry getUnificationEntry(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        return GTUtility.getOrWildcardMeta(stackUnificationInfo, new ItemAndMetadata(itemStack));
    }

    public static ItemStack getUnificated(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        UnificationEntry unificationEntry = OreDictUnifier.getUnificationEntry(itemStack);
        if (unificationEntry == null || !stackUnificationItems.containsKey(unificationEntry) || !unificationEntry.orePrefix.isUnificationEnabled) {
            return itemStack;
        }
        ArrayList<ItemAndMetadata> keys = stackUnificationItems.get(unificationEntry);
        return keys.size() > 0 ? keys.get(0).toItemStack(itemStack.func_190916_E()) : itemStack;
    }

    public static ItemStack get(UnificationEntry unificationEntry) {
        return OreDictUnifier.get(unificationEntry.orePrefix, unificationEntry.material);
    }

    public static ItemStack get(OrePrefix orePrefix, Material material) {
        return OreDictUnifier.get(orePrefix, material, 1);
    }

    public static ItemStack get(OrePrefix orePrefix, Material material, int stackSize) {
        UnificationEntry unificationEntry = new UnificationEntry(orePrefix, material);
        if (!stackUnificationItems.containsKey(unificationEntry)) {
            return ItemStack.field_190927_a;
        }
        ArrayList<ItemAndMetadata> keys = stackUnificationItems.get(unificationEntry);
        return keys.size() > 0 ? keys.get(0).toItemStack(stackSize) : ItemStack.field_190927_a;
    }

    public static ItemStack get(String oreDictName) {
        List<ItemStack> itemStacks = oreDictNameStacks.get(oreDictName);
        if (itemStacks == null || itemStacks.size() == 0) {
            return ItemStack.field_190927_a;
        }
        return itemStacks.get(0).func_77946_l();
    }

    public static List<ItemStack> getAll(UnificationEntry unificationEntry) {
        if (!stackUnificationItems.containsKey(unificationEntry)) {
            return Collections.emptyList();
        }
        ArrayList<ItemAndMetadata> keys = stackUnificationItems.get(unificationEntry);
        return keys.stream().map(ItemAndMetadata::toItemStack).collect(Collectors.toList());
    }

    public static ItemStack getDust(Material material, long materialAmount) {
        if (!material.hasProperty(PropertyKey.DUST) || materialAmount <= 0L) {
            return ItemStack.field_190927_a;
        }
        if (materialAmount % 3628800L == 0L || materialAmount >= 58060800L) {
            return OreDictUnifier.get(OrePrefix.dust, material, (int)(materialAmount / 3628800L));
        }
        if (materialAmount * 4L % 3628800L == 0L || materialAmount >= 29030400L) {
            return OreDictUnifier.get(OrePrefix.dustSmall, material, (int)(materialAmount * 4L / 3628800L));
        }
        if (materialAmount * 9L >= 3628800L) {
            return OreDictUnifier.get(OrePrefix.dustTiny, material, (int)(materialAmount * 9L / 3628800L));
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getDust(MaterialStack materialStack) {
        return OreDictUnifier.getDust(materialStack.material, materialStack.amount);
    }

    public static ItemStack getIngot(Material material, long materialAmount) {
        if (!material.hasProperty(PropertyKey.INGOT) || materialAmount <= 0L) {
            return ItemStack.field_190927_a;
        }
        if (materialAmount % 32659200L == 0L) {
            return OreDictUnifier.get(OrePrefix.block, material, (int)(materialAmount / 32659200L));
        }
        if (materialAmount % 3628800L == 0L || materialAmount >= 58060800L) {
            return OreDictUnifier.get(OrePrefix.ingot, material, (int)(materialAmount / 3628800L));
        }
        if (materialAmount * 9L >= 3628800L) {
            return OreDictUnifier.get(OrePrefix.nugget, material, (int)(materialAmount * 9L / 3628800L));
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getIngot(MaterialStack materialStack) {
        return OreDictUnifier.getIngot(materialStack.material, materialStack.amount);
    }

    public static ItemStack getIngotOrDust(Material material, long materialAmount) {
        ItemStack ingotStack = OreDictUnifier.getIngot(material, materialAmount);
        if (ingotStack != ItemStack.field_190927_a) {
            return ingotStack;
        }
        return OreDictUnifier.getDust(material, materialAmount);
    }

    public static ItemStack getIngotOrDust(MaterialStack materialStack) {
        return OreDictUnifier.getIngotOrDust(materialStack.material, materialStack.amount);
    }

    public static ItemStack getGem(MaterialStack materialStack) {
        if (materialStack.material.hasProperty(PropertyKey.GEM) && !OrePrefix.gem.isIgnored(materialStack.material) && materialStack.amount == OrePrefix.gem.getMaterialAmount(materialStack.material)) {
            return OreDictUnifier.get(OrePrefix.gem, materialStack.material, (int)(materialStack.amount / 3628800L));
        }
        return OreDictUnifier.getDust(materialStack);
    }

    private static synchronized <T> void addAndSort(List<T> list, T itemToAdd, Comparator<T> comparator) {
        list.add(itemToAdd);
        if (list.size() > 1) {
            list.sort(comparator);
        }
    }
}

