/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification;

import com.google.common.base.CaseFormat;
import crafttweaker.annotations.ZenRegister;
import gregtech.api.unification.Element;
import gregtech.api.util.GTLog;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.material.Elements")
@ZenRegister
public class Elements {
    private static final Pattern namePattern = Pattern.compile("[A-Z]+[A-Za-z]*(-\\d+)?");
    private static final Map<String, Element> elements = new Object2ObjectOpenHashMap();
    private static final Map<String, Element> elementsBySymbol = new Object2ObjectOpenHashMap();
    private static final List<Element> elementList = new ArrayList<Element>();
    private static final List<Element> elementsView = Collections.unmodifiableList(elementList);
    public static final Element H = Elements.add(1L, 0L, "Hydrogen", "H");
    public static final Element D = Elements.add(1L, 1L, -1.0, "H", "Deuterium", "D", true);
    public static final Element T = Elements.add(1L, 2L, -1.0, "D", "Tritium", "T", true);
    public static final Element He = Elements.add(2L, 2L, "Helium", "He");
    public static final Element He3 = Elements.add(2L, 1L, -1.0, "H&D", "Helium-3", "He-3", true);
    public static final Element Li = Elements.add(3L, 4L, "Lithium", "Li");
    public static final Element Be = Elements.add(4L, 5L, "Beryllium", "Be");
    public static final Element B = Elements.add(5L, 5L, "Boron", "B");
    public static final Element C = Elements.add(6L, 6L, "Carbon", "C");
    public static final Element N = Elements.add(7L, 7L, "Nitrogen", "N");
    public static final Element O = Elements.add(8L, 8L, "Oxygen", "O");
    public static final Element F = Elements.add(9L, 9L, "Fluorine", "F");
    public static final Element Ne = Elements.add(10L, 10L, "Neon", "Ne");
    public static final Element Na = Elements.add(11L, 11L, "Sodium", "Na");
    public static final Element Mg = Elements.add(12L, 12L, "Magnesium", "Mg");
    public static final Element Al = Elements.add(13L, 13L, "Aluminium", "Al");
    public static final Element Si = Elements.add(14L, 14L, "Silicon", "Si");
    public static final Element P = Elements.add(15L, 15L, "Phosphorus", "P");
    public static final Element S = Elements.add(16L, 16L, "Sulfur", "S");
    public static final Element Cl = Elements.add(17L, 18L, "Chlorine", "Cl");
    public static final Element Ar = Elements.add(18L, 22L, "Argon", "Ar");
    public static final Element K = Elements.add(19L, 20L, "Potassium", "K");
    public static final Element Ca = Elements.add(20L, 20L, "Calcium", "Ca");
    public static final Element Sc = Elements.add(21L, 24L, "Scandium", "Sc");
    public static final Element Ti = Elements.add(22L, 26L, "Titanium", "Ti");
    public static final Element V = Elements.add(23L, 28L, "Vanadium", "V");
    public static final Element Cr = Elements.add(24L, 28L, "Chrome", "Cr");
    public static final Element Mn = Elements.add(25L, 30L, "Manganese", "Mn");
    public static final Element Fe = Elements.add(26L, 30L, "Iron", "Fe");
    public static final Element Co = Elements.add(27L, 32L, "Cobalt", "Co");
    public static final Element Ni = Elements.add(28L, 30L, "Nickel", "Ni");
    public static final Element Cu = Elements.add(29L, 34L, "Copper", "Cu");
    public static final Element Zn = Elements.add(30L, 35L, "Zinc", "Zn");
    public static final Element Ga = Elements.add(31L, 39L, "Gallium", "Ga");
    public static final Element Ge = Elements.add(32L, 40L, "Germanium", "Ge");
    public static final Element As = Elements.add(33L, 42L, "Arsenic", "As");
    public static final Element Se = Elements.add(34L, 45L, "Selenium", "Se");
    public static final Element Br = Elements.add(35L, 45L, "Bromine", "Br");
    public static final Element Kr = Elements.add(36L, 48L, "Krypton", "Kr");
    public static final Element Rb = Elements.add(37L, 48L, "Rubidium", "Rb");
    public static final Element Sr = Elements.add(38L, 49L, "Strontium", "Sr");
    public static final Element Y = Elements.add(39L, 50L, "Yttrium", "Y");
    public static final Element Zr = Elements.add(40L, 51L, "Zirconium", "Zr");
    public static final Element Nb = Elements.add(41L, 53L, "Niobium", "Nb");
    public static final Element Mo = Elements.add(42L, 53L, "Molybdenum", "Mo");
    public static final Element Tc = Elements.add(43L, 55L, "Technetium", "Tc");
    public static final Element Ru = Elements.add(44L, 57L, "Ruthenium", "Ru");
    public static final Element Rh = Elements.add(45L, 58L, "Rhodium", "Rh");
    public static final Element Pd = Elements.add(46L, 60L, "Palladium", "Pd");
    public static final Element Ag = Elements.add(47L, 60L, "Silver", "Ag");
    public static final Element Cd = Elements.add(48L, 64L, "Cadmium", "Cd");
    public static final Element In = Elements.add(49L, 65L, "Indium", "In");
    public static final Element Sn = Elements.add(50L, 68L, "Tin", "Sn");
    public static final Element Sb = Elements.add(51L, 70L, "Antimony", "Sb");
    public static final Element Te = Elements.add(52L, 75L, "Tellurium", "Te");
    public static final Element I = Elements.add(53L, 74L, "Iodine", "I");
    public static final Element Xe = Elements.add(54L, 77L, "Xenon", "Xe");
    public static final Element Cs = Elements.add(55L, 77L, "Caesium", "Cs");
    public static final Element Ba = Elements.add(56L, 81L, "Barium", "Ba");
    public static final Element La = Elements.add(57L, 81L, "Lanthanum", "La");
    public static final Element Ce = Elements.add(58L, 82L, "Cerium", "Ce");
    public static final Element Pr = Elements.add(59L, 81L, "Praseodymium", "Pr");
    public static final Element Nd = Elements.add(60L, 84L, "Neodymium", "Nd");
    public static final Element Pm = Elements.add(61L, 83L, "Promethium", "Pm");
    public static final Element Sm = Elements.add(62L, 88L, "Samarium", "Sm");
    public static final Element Eu = Elements.add(63L, 88L, "Europium", "Eu");
    public static final Element Gd = Elements.add(64L, 93L, "Gadolinium", "Gd");
    public static final Element Tb = Elements.add(65L, 93L, "Terbium", "Tb");
    public static final Element Dy = Elements.add(66L, 96L, "Dysprosium", "Dy");
    public static final Element Ho = Elements.add(67L, 97L, "Holmium", "Ho");
    public static final Element Er = Elements.add(68L, 99L, "Erbium", "Er");
    public static final Element Tm = Elements.add(69L, 99L, "Thulium", "Tm");
    public static final Element Yb = Elements.add(70L, 103L, "Ytterbium", "Yb");
    public static final Element Lu = Elements.add(71L, 103L, "Lutetium", "Lu");
    public static final Element Hf = Elements.add(72L, 106L, "Hafnium", "Hf");
    public static final Element Ta = Elements.add(73L, 107L, "Tantalum", "Ta");
    public static final Element W = Elements.add(74L, 109L, "Tungsten", "W");
    public static final Element Re = Elements.add(75L, 111L, "Rhenium", "Re");
    public static final Element Os = Elements.add(76L, 114L, "Osmium", "Os");
    public static final Element Ir = Elements.add(77L, 115L, "Iridium", "Ir");
    public static final Element Pt = Elements.add(78L, 117L, "Platinum", "Pt");
    public static final Element Au = Elements.add(79L, 117L, "Gold", "Au");
    public static final Element Hg = Elements.add(80L, 120L, "Mercury", "Hg");
    public static final Element Tl = Elements.add(81L, 123L, "Thallium", "Tl");
    public static final Element Pb = Elements.add(82L, 125L, "Lead", "Pb");
    public static final Element Bi = Elements.add(83L, 125L, "Bismuth", "Bi");
    public static final Element Po = Elements.add(84L, 124L, "Polonium", "Po");
    public static final Element At = Elements.add(85L, 124L, "Astatine", "At");
    public static final Element Rn = Elements.add(86L, 134L, "Radon", "Rn");
    public static final Element Fr = Elements.add(87L, 134L, "Francium", "Fr");
    public static final Element Ra = Elements.add(88L, 136L, "Radium", "Ra");
    public static final Element Ac = Elements.add(89L, 136L, "Actinium", "Ac");
    public static final Element Th = Elements.add(90L, 140L, "Thorium", "Th");
    public static final Element Pa = Elements.add(91L, 138L, "Protactinium", "Pa");
    public static final Element U = Elements.add(92L, 146L, 1.4090285E17, null, "Uranium", "U", false);
    public static final Element U238 = Elements.add(92L, 146L, 1.4090285E17, null, "Uranium-238", "U-238", true);
    public static final Element U235 = Elements.add(92L, 143L, 2.2195037E16, null, "Uranium-235", "U-235", true);
    public static final Element Np = Elements.add(93L, 144L, "Neptunium", "Np");
    public static final Element Pu = Elements.add(94L, 152L, 7.6033296E11, null, "Plutonium", "Pu", false);
    public static final Element Pu239 = Elements.add(94L, 145L, 7.6033296E11, null, "Plutonium-239", "Pu-239", true);
    public static final Element Pu241 = Elements.add(94L, 147L, 4.5064944E8, null, "Plutonium-241", "Pu-241", true);
    public static final Element Am = Elements.add(95L, 150L, "Americium", "Am");
    public static final Element Cm = Elements.add(96L, 153L, "Curium", "Cm");
    public static final Element Bk = Elements.add(97L, 152L, "Berkelium", "Bk");
    public static final Element Cf = Elements.add(98L, 153L, "Californium", "Cf");
    public static final Element Es = Elements.add(99L, 153L, "Einsteinium", "Es");
    public static final Element Fm = Elements.add(100L, 157L, "Fermium", "Fm");
    public static final Element Md = Elements.add(101L, 157L, "Mendelevium", "Md");
    public static final Element No = Elements.add(102L, 157L, "Nobelium", "No");
    public static final Element Lr = Elements.add(103L, 159L, "Lawrencium", "Lr");
    public static final Element Rf = Elements.add(104L, 161L, "Rutherfordium", "Rf");
    public static final Element Db = Elements.add(105L, 163L, "Dubnium", "Db");
    public static final Element Sg = Elements.add(106L, 165L, "Seaborgium", "Sg");
    public static final Element Bh = Elements.add(107L, 163L, "Bohrium", "Bh");
    public static final Element Hs = Elements.add(108L, 169L, "Hassium", "Hs");
    public static final Element Mt = Elements.add(109L, 167L, "Meitnerium", "Mt");
    public static final Element Ds = Elements.add(110L, 171L, "Darmstadtium", "Ds");
    public static final Element Rg = Elements.add(111L, 169L, "Roentgenium", "Rg");
    public static final Element Cn = Elements.add(112L, 173L, "Copernicium", "Cn");
    public static final Element Nh = Elements.add(113L, 171L, "Nihonium", "Nh");
    public static final Element Fl = Elements.add(114L, 175L, "Flerovium", "Fl");
    public static final Element Mc = Elements.add(115L, 173L, "Moscovium", "Mc");
    public static final Element Lv = Elements.add(116L, 177L, "Livermorium", "Lv");
    public static final Element Ts = Elements.add(117L, 177L, "Tennessine", "Ts");
    public static final Element Og = Elements.add(118L, 176L, "Oganesson", "Og");
    public static final Element Tr = Elements.add(119L, 178L, "Tritanium", "Tr");
    public static final Element Dr = Elements.add(120L, 180L, "Duranium", "Dr");
    public static final Element Ke = Elements.add(125L, 198L, "Trinium", "Ke");
    public static final Element Nq = Elements.add(174L, 352L, 140.0, null, "Naquadah", "Nq", true);
    public static final Element Nq1 = Elements.add(174L, 354L, 140.0, null, "NaquadahEnriched", "Nq+", true);
    public static final Element Nq2 = Elements.add(174L, 348L, 140.0, null, "Naquadria", "*Nq*", true);
    public static final Element Nt = Elements.add(0L, 1000L, "Neutronium", "Nt");
    public static final Element Sp = Elements.add(1L, 0L, "Space", "Sp");
    public static final Element Ma = Elements.add(1L, 0L, "Magic", "Ma");

    private Elements() {
    }

    @ZenMethod
    public static Element add(long protons, long neutrons, String name, String symbol) {
        return Elements.add(protons, neutrons, -1.0, null, name, symbol, false);
    }

    @ZenMethod
    public static Element add(long protons, long neutrons, String name, String symbol, boolean isotope) {
        return Elements.add(protons, neutrons, -1.0, null, name, symbol, isotope);
    }

    @ZenMethod
    public static Element add(long protons, long neutrons, double halfLifeSeconds, String decayTo, String name, String symbol, boolean isIsotope) {
        Elements.validateNameAndSymbol(name, symbol);
        String key = Elements.toMapKey(name);
        Element current = elements.get(key);
        if (current != null) {
            GTLog.logger.warn("Element with name '{}' already exists. Current element will be overwritten!", (Object)name);
            elements.remove(key);
            elementsBySymbol.remove(current.symbol);
            elementList.remove(current);
        }
        if (elementsBySymbol.containsKey(symbol)) {
            GTLog.logger.warn("Element with symbol '{}' already exists. The element in the symbol map will be overwritten!", (Object)symbol);
        }
        Element element = new Element(protons, neutrons, halfLifeSeconds, decayTo, name, symbol, isIsotope);
        elements.put(key, element);
        elementsBySymbol.put(symbol, element);
        elementList.add(element);
        return element;
    }

    private static String toMapKey(String name) {
        name = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
        return name;
    }

    private static void validateNameAndSymbol(String name, String symbol) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Element name must not be null or empty");
        }
        if (!namePattern.matcher(name).matches()) {
            throw new IllegalArgumentException("Element name '" + name + "' does not match required format! Name must be in upper camel case format. Isotope number must be separated with an - at the end.");
        }
        if (symbol == null || symbol.isEmpty()) {
            throw new IllegalArgumentException("Element symbol must not be null or empty!");
        }
    }

    public static List<Element> getAllElements() {
        return elementsView;
    }

    @ZenMethod(value="getAllElements")
    public static Element[] getAllElementsCT() {
        return elementsView.toArray(new Element[0]);
    }

    public static Element getByName(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        return elements.get(Elements.toMapKey(name));
    }

    public static Element getBySymbol(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        return elementsBySymbol.get(name);
    }

    @ZenMethod
    public static Element get(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        Element e = elementsBySymbol.get(name);
        if (e != null) {
            return e;
        }
        return elements.get(Elements.toMapKey(name));
    }
}

