/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.ui.impl;

import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.gui.widgets.RecipeProgressWidget;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.ui.RecipeMapUI;
import gregtech.api.util.GTUtility;
import java.util.function.DoubleSupplier;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class CrackerUnitUI<R extends RecipeMap<?>>
extends RecipeMapUI<R> {
    public CrackerUnitUI(@NotNull R recipeMap) {
        super(recipeMap, true, true, false, true, false);
        this.setFluidSlotOverlay(GuiTextures.CRACKING_OVERLAY_1, false);
        this.setFluidSlotOverlay(GuiTextures.CRACKING_OVERLAY_2, true);
        this.setItemSlotOverlay(GuiTextures.CIRCUIT_OVERLAY, false);
        this.setProgressBar(GuiTextures.PROGRESS_BAR_CRACKING, ProgressWidget.MoveType.HORIZONTAL);
    }

    @Override
    public ModularUI.Builder createJeiUITemplate(IItemHandlerModifiable importItems, IItemHandlerModifiable exportItems, FluidTankList importFluids, FluidTankList exportFluids, int yOffset) {
        ModularUI.Builder builder = ModularUI.defaultBuilder(yOffset);
        if (((RecipeMap)this.recipeMap()).getMaxInputs() == 1) {
            this.addSlot(builder, 52, 24 + yOffset, 0, importItems, importFluids, false, false);
        } else {
            int[] grid = CrackerUnitUI.determineSlotsGrid(((RecipeMap)this.recipeMap()).getMaxInputs());
            for (int y = 0; y < grid[1]; ++y) {
                for (int x = 0; x < grid[0]; ++x) {
                    this.addSlot(builder, 34 + x * 18 - Math.max(0, grid[0] - 2) * 18, 24 + y * 18 - Math.max(0, grid[1] - 1) * 18 + yOffset, y * grid[0] + x, importItems, importFluids, false, false);
                }
            }
        }
        this.addInventorySlotGroup(builder, exportItems, exportFluids, true, yOffset);
        this.addSlot(builder, 52, 24 + yOffset + 19 + 18, 0, importItems, importFluids, true, false);
        this.addSlot(builder, 34, 24 + yOffset + 19 + 18, 1, importItems, importFluids, true, false);
        Pair<DoubleSupplier, DoubleSupplier> suppliers = GTUtility.createPairedSupplier(200, 41, 0.5);
        builder.widget(new RecipeProgressWidget((DoubleSupplier)suppliers.getLeft(), 42, 24 + yOffset + 18, 21, 19, GuiTextures.PROGRESS_BAR_CRACKING_INPUT, ProgressWidget.MoveType.VERTICAL, (RecipeMap<?>)this.recipeMap()));
        builder.widget(new RecipeProgressWidget((DoubleSupplier)suppliers.getRight(), 78, 23 + yOffset, 20, 20, this.progressBarTexture(), this.progressBarMoveType(), (RecipeMap<?>)this.recipeMap()));
        return builder;
    }
}

