/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.ui.impl;

import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.ui.RecipeMapUI;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class AssemblyLineUI<R extends RecipeMap<?>>
extends RecipeMapUI<R> {
    public AssemblyLineUI(@NotNull R recipeMap) {
        super(recipeMap, false, false, false, false, false);
        this.setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressWidget.MoveType.HORIZONTAL);
    }

    @Override
    @NotNull
    public ModularUI.Builder createJeiUITemplate(IItemHandlerModifiable importItems, IItemHandlerModifiable exportItems, FluidTankList importFluids, FluidTankList exportFluids, int yOffset) {
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, 176, 176).widget(new ProgressWidget(200, 80, 1, 54, 72, GuiTextures.PROGRESS_BAR_ASSEMBLY_LINE, ProgressWidget.MoveType.HORIZONTAL)).widget(new ProgressWidget(200, 138, 19, 10, 18, GuiTextures.PROGRESS_BAR_ASSEMBLY_LINE_ARROW, ProgressWidget.MoveType.VERTICAL));
        this.addInventorySlotGroup(builder, importItems, importFluids, false, yOffset);
        this.addInventorySlotGroup(builder, exportItems, exportFluids, true, yOffset);
        return builder;
    }

    @Override
    protected void addInventorySlotGroup(@NotNull ModularUI.Builder builder, @NotNull IItemHandlerModifiable itemHandler, @NotNull FluidTankList fluidHandler, boolean isOutputs, int yOffset) {
        int startInputsX = 8;
        int startInputsY = 1;
        if (!isOutputs) {
            builder.widget(new SlotWidget((IItemHandler)itemHandler, 16, startInputsX + 126, 37, true, true).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.DATA_ORB_OVERLAY));
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    int slotIndex = i * 4 + j;
                    this.addSlot(builder, startInputsX + 18 * j, startInputsY + 18 * i, slotIndex, itemHandler, fluidHandler, false, false);
                }
            }
            int startFluidX = startInputsX + 90;
            for (int i = 0; i < 4; ++i) {
                this.addSlot(builder, startFluidX, startInputsY + 18 * i, i, itemHandler, fluidHandler, true, false);
            }
        } else {
            this.addSlot(builder, startInputsX + 126, 1, 0, itemHandler, fluidHandler, false, true);
        }
    }
}

