/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.ui;

import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.gui.widgets.RecipeProgressWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import java.util.function.DoubleSupplier;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

@ApiStatus.Experimental
public class RecipeMapUI<R extends RecipeMap<?>> {
    private final Byte2ObjectMap<TextureArea> slotOverlays = new Byte2ObjectOpenHashMap();
    private final R recipeMap;
    private final boolean modifyItemInputs;
    private final boolean modifyItemOutputs;
    private final boolean modifyFluidInputs;
    private final boolean modifyFluidOutputs;
    private final boolean isGenerator;
    private TextureArea progressBarTexture = GuiTextures.PROGRESS_BAR_ARROW;
    private ProgressWidget.MoveType moveType = ProgressWidget.MoveType.HORIZONTAL;
    @Nullable
    private TextureArea specialTexture;
    private int @Nullable [] specialTexturePosition;
    private boolean isJEIVisible = true;

    public RecipeMapUI(@NotNull R recipeMap, boolean modifyItemInputs, boolean modifyItemOutputs, boolean modifyFluidInputs, boolean modifyFluidOutputs, boolean isGenerator) {
        this.recipeMap = recipeMap;
        this.modifyItemInputs = modifyItemInputs;
        this.modifyItemOutputs = modifyItemOutputs;
        this.modifyFluidInputs = modifyFluidInputs;
        this.modifyFluidOutputs = modifyFluidOutputs;
        this.isGenerator = isGenerator;
    }

    @ApiStatus.Internal
    public static byte computeOverlayKey(boolean isOutput, boolean isFluid, boolean isLast) {
        return (byte)((isOutput ? 2 : 0) + (isFluid ? 1 : 0) + (isLast ? 4 : 0));
    }

    @Contract(value="_ -> new")
    public static int @NotNull [] determineSlotsGrid(int itemInputsCount) {
        int itemSlotsToDown;
        int itemSlotsToLeft;
        double sqrt = Math.sqrt(itemInputsCount);
        if (sqrt % 1.0 == 0.0) {
            itemSlotsToDown = itemSlotsToLeft = (int)sqrt;
        } else if (itemInputsCount == 3) {
            itemSlotsToLeft = 3;
            itemSlotsToDown = 1;
        } else {
            itemSlotsToLeft = (int)Math.ceil(sqrt);
            if (itemInputsCount > itemSlotsToLeft * (itemSlotsToDown = itemSlotsToLeft - 1)) {
                itemSlotsToDown = itemSlotsToLeft;
            }
        }
        return new int[]{itemSlotsToLeft, itemSlotsToDown};
    }

    public ModularUI.Builder createJeiUITemplate(IItemHandlerModifiable importItems, IItemHandlerModifiable exportItems, FluidTankList importFluids, FluidTankList exportFluids, int yOffset) {
        ModularUI.Builder builder = ModularUI.defaultBuilder(yOffset);
        builder.widget(new RecipeProgressWidget(200, 78, 23 + yOffset, 20, 20, this.progressBarTexture, this.moveType, (RecipeMap<?>)this.recipeMap));
        this.addInventorySlotGroup(builder, importItems, importFluids, false, yOffset);
        this.addInventorySlotGroup(builder, exportItems, exportFluids, true, yOffset);
        if (this.specialTexture != null && this.specialTexturePosition != null) {
            this.addSpecialTexture(builder);
        }
        return builder;
    }

    public ModularUI.Builder createUITemplate(DoubleSupplier progressSupplier, IItemHandlerModifiable importItems, IItemHandlerModifiable exportItems, FluidTankList importFluids, FluidTankList exportFluids, int yOffset) {
        ModularUI.Builder builder = ModularUI.defaultBuilder(yOffset);
        builder.widget(new RecipeProgressWidget(progressSupplier, 78, 23 + yOffset, 20, 20, this.progressBarTexture, this.moveType, (RecipeMap<?>)this.recipeMap));
        this.addInventorySlotGroup(builder, importItems, importFluids, false, yOffset);
        this.addInventorySlotGroup(builder, exportItems, exportFluids, true, yOffset);
        if (this.specialTexture != null && this.specialTexturePosition != null) {
            this.addSpecialTexture(builder);
        }
        return builder;
    }

    public ModularUI.Builder createUITemplateNoOutputs(DoubleSupplier progressSupplier, IItemHandlerModifiable importItems, IItemHandlerModifiable exportItems, FluidTankList importFluids, FluidTankList exportFluids, int yOffset) {
        ModularUI.Builder builder = ModularUI.defaultBuilder(yOffset);
        builder.widget(new RecipeProgressWidget(progressSupplier, 78, 23 + yOffset, 20, 20, this.progressBarTexture, this.moveType, (RecipeMap<?>)this.recipeMap));
        this.addInventorySlotGroup(builder, importItems, importFluids, false, yOffset);
        if (this.specialTexture != null && this.specialTexturePosition != null) {
            this.addSpecialTexture(builder);
        }
        return builder;
    }

    protected void addInventorySlotGroup(@NotNull ModularUI.Builder builder, @NotNull IItemHandlerModifiable itemHandler, @NotNull FluidTankList fluidHandler, boolean isOutputs, int yOffset) {
        block11: {
            int i;
            boolean wasGroup;
            int itemInputsCount = itemHandler.getSlots();
            int fluidInputsCount = fluidHandler.getTanks();
            boolean invertFluids = false;
            if (itemInputsCount == 0) {
                int tmp = itemInputsCount;
                itemInputsCount = fluidInputsCount;
                fluidInputsCount = tmp;
                invertFluids = true;
            }
            int[] inputSlotGrid = RecipeMapUI.determineSlotsGrid(itemInputsCount);
            int itemSlotsToLeft = inputSlotGrid[0];
            int itemSlotsToDown = inputSlotGrid[1];
            int startInputsX = isOutputs ? 106 : 70 - itemSlotsToLeft * 18;
            int startInputsY = 33 - (int)((double)itemSlotsToDown / 2.0 * 18.0) + yOffset;
            boolean bl = wasGroup = itemHandler.getSlots() + fluidHandler.getTanks() == 12;
            if (wasGroup) {
                startInputsY -= 9;
            } else if (itemHandler.getSlots() >= 6 && fluidHandler.getTanks() >= 2 && !isOutputs) {
                startInputsY -= 9;
            }
            for (int i2 = 0; i2 < itemSlotsToDown; ++i2) {
                int slotIndex;
                for (int j = 0; j < itemSlotsToLeft && (slotIndex = i2 * itemSlotsToLeft + j) < itemInputsCount; ++j) {
                    int x = startInputsX + 18 * j;
                    int y = startInputsY + 18 * i2;
                    this.addSlot(builder, x, y, slotIndex, itemHandler, fluidHandler, invertFluids, isOutputs);
                }
            }
            if (wasGroup) {
                startInputsY += 2;
            }
            if (fluidInputsCount <= 0 && !invertFluids) break block11;
            if (itemSlotsToDown >= fluidInputsCount && itemSlotsToLeft < 3) {
                int startSpecX = isOutputs ? startInputsX + itemSlotsToLeft * 18 : startInputsX - 18;
                for (i = 0; i < fluidInputsCount; ++i) {
                    int y = startInputsY + 18 * i;
                    this.addSlot(builder, startSpecX, y, i, itemHandler, fluidHandler, !invertFluids, isOutputs);
                }
            } else {
                int startSpecY = startInputsY + itemSlotsToDown * 18;
                for (i = 0; i < fluidInputsCount; ++i) {
                    int x = isOutputs ? startInputsX + 18 * (i % 3) : startInputsX + itemSlotsToLeft * 18 - 18 - 18 * (i % 3);
                    int y = startSpecY + i / 3 * 18;
                    this.addSlot(builder, x, y, i, itemHandler, fluidHandler, !invertFluids, isOutputs);
                }
            }
        }
    }

    protected void addSlot(ModularUI.Builder builder, int x, int y, int slotIndex, IItemHandlerModifiable itemHandler, FluidTankList fluidHandler, boolean isFluid, boolean isOutputs) {
        if (!isFluid) {
            builder.widget(new SlotWidget((IItemHandler)itemHandler, slotIndex, x, y, true, !isOutputs).setBackgroundTexture(this.getOverlaysForSlot(isOutputs, false, slotIndex == itemHandler.getSlots() - 1)));
        } else {
            builder.widget(new TankWidget(fluidHandler.getTankAt(slotIndex), x, y, 18, 18).setAlwaysShowFull(true).setBackgroundTexture(this.getOverlaysForSlot(isOutputs, true, slotIndex == fluidHandler.getTanks() - 1)).setContainerClicking(true, !isOutputs));
        }
    }

    protected TextureArea[] getOverlaysForSlot(boolean isOutput, boolean isFluid, boolean isLast) {
        TextureArea base = isFluid ? GuiTextures.FLUID_SLOT : GuiTextures.SLOT;
        byte overlayKey = RecipeMapUI.computeOverlayKey(isOutput, isFluid, isLast);
        if (this.slotOverlays.containsKey(overlayKey)) {
            return new TextureArea[]{base, (TextureArea)this.slotOverlays.get(overlayKey)};
        }
        return new TextureArea[]{base};
    }

    public int getPropertyHeightShift() {
        int maxPropertyCount = 0;
        if (this.shouldShiftWidgets()) {
            for (Recipe recipe : ((RecipeMap)this.recipeMap).getRecipeList()) {
                int count = recipe.propertyStorage().size();
                if (count <= maxPropertyCount) continue;
                maxPropertyCount = count;
            }
        }
        return maxPropertyCount * 10;
    }

    private boolean shouldShiftWidgets() {
        return ((RecipeMap)this.recipeMap).getMaxInputs() + ((RecipeMap)this.recipeMap).getMaxOutputs() >= 6 || ((RecipeMap)this.recipeMap).getMaxFluidInputs() + ((RecipeMap)this.recipeMap).getMaxFluidOutputs() >= 6;
    }

    @NotNull
    public ProgressWidget.MoveType progressBarMoveType() {
        return this.moveType;
    }

    public void setProgressBarMoveType(@NotNull ProgressWidget.MoveType moveType) {
        this.moveType = moveType;
    }

    @NotNull
    public TextureArea progressBarTexture() {
        return this.progressBarTexture;
    }

    public void setProgressBarTexture(@NotNull TextureArea progressBarTexture) {
        this.progressBarTexture = progressBarTexture;
    }

    public void setProgressBar(@NotNull TextureArea progressBarTexture, @NotNull ProgressWidget.MoveType moveType) {
        this.progressBarTexture = progressBarTexture;
        this.moveType = moveType;
    }

    public void setSpecialTexture(@NotNull TextureArea specialTexture, int x, int y, int width, int height) {
        this.setSpecialTexture(specialTexture, new int[]{x, y, width, height});
    }

    public void setSpecialTexture(@NotNull TextureArea specialTexture, int @NotNull [] position) {
        this.specialTexture = specialTexture;
        this.specialTexturePosition = position;
    }

    @Nullable
    public TextureArea specialTexture() {
        return this.specialTexture;
    }

    public int @Nullable @UnmodifiableView [] specialTexturePosition() {
        return this.specialTexturePosition;
    }

    @NotNull
    public ModularUI.Builder addSpecialTexture(@NotNull ModularUI.Builder builder) {
        if (this.specialTexturePosition != null) {
            builder.image(this.specialTexturePosition[0], this.specialTexturePosition[1], this.specialTexturePosition[2], this.specialTexturePosition[3], this.specialTexture);
        }
        return builder;
    }

    public boolean isJEIVisible() {
        return this.isJEIVisible;
    }

    public void setJEIVisible(boolean isJEIVisible) {
        this.isJEIVisible = isJEIVisible;
    }

    public boolean canModifyItemInputs() {
        return this.modifyItemInputs;
    }

    public boolean canModifyItemOutputs() {
        return this.modifyItemOutputs;
    }

    public boolean canModifyFluidInputs() {
        return this.modifyFluidInputs;
    }

    public boolean canModifyFluidOutputs() {
        return this.modifyFluidOutputs;
    }

    public boolean isGenerator() {
        return this.isGenerator;
    }

    public void setItemSlotOverlay(@NotNull TextureArea texture, boolean isOutput) {
        this.slotOverlays.put(RecipeMapUI.computeOverlayKey(isOutput, false, false), (Object)texture);
        this.slotOverlays.put(RecipeMapUI.computeOverlayKey(isOutput, false, true), (Object)texture);
    }

    public void setItemSlotOverlay(@NotNull TextureArea texture, boolean isOutput, boolean isLastSlot) {
        this.slotOverlays.put(RecipeMapUI.computeOverlayKey(isOutput, false, isLastSlot), (Object)texture);
    }

    public void setFluidSlotOverlay(@NotNull TextureArea texture, boolean isOutput) {
        this.slotOverlays.put(RecipeMapUI.computeOverlayKey(isOutput, true, false), (Object)texture);
        this.slotOverlays.put(RecipeMapUI.computeOverlayKey(isOutput, true, true), (Object)texture);
    }

    public void setFluidSlotOverlay(@NotNull TextureArea texture, boolean isOutput, boolean isLastSlot) {
        this.slotOverlays.put(RecipeMapUI.computeOverlayKey(isOutput, true, isLastSlot), (Object)texture);
    }

    @ApiStatus.Internal
    public void setSlotOverlay(byte key, @NotNull TextureArea texture) {
        this.slotOverlays.put(key, (Object)texture);
    }

    @NotNull
    public R recipeMap() {
        return this.recipeMap;
    }
}

