/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.properties.impl;

import gregtech.api.GregTechAPI;
import gregtech.api.recipes.properties.RecipeProperty;
import gregtech.api.unification.material.Material;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public final class TemperatureProperty
extends RecipeProperty<Integer> {
    public static final String KEY = "temperature";
    private static final TreeMap<Integer, Object> registeredCoilTypes = new TreeMap((x, y) -> y - x);
    private static TemperatureProperty INSTANCE;

    private TemperatureProperty() {
        super(KEY, Integer.class);
    }

    public static TemperatureProperty getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TemperatureProperty();
            GregTechAPI.RECIPE_PROPERTIES.register(KEY, INSTANCE);
        }
        return INSTANCE;
    }

    @Override
    @NotNull
    public NBTBase serialize(@NotNull Object value) {
        return new NBTTagInt(((Integer)this.castValue(value)).intValue());
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull NBTBase nbt) {
        return ((NBTTagInt)nbt).func_150287_d();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInfo(Minecraft minecraft, int x, int y, int color, Object value) {
        minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gregtech.recipe.temperature", (Object[])new Object[]{value, this.getMinTierForTemperature((Integer)this.castValue(value))}), x, y, color);
    }

    @NotNull
    private String getMinTierForTemperature(Integer value) {
        String name = "";
        for (Map.Entry<Integer, Object> coil : registeredCoilTypes.entrySet()) {
            if (value > coil.getKey()) continue;
            Object mapValue = coil.getValue();
            if (mapValue instanceof Material) {
                name = ((Material)mapValue).getLocalizedName();
                continue;
            }
            if (!(mapValue instanceof String)) continue;
            name = I18n.func_135052_a((String)((String)mapValue), (Object[])new Object[0]);
        }
        if (name.length() >= 13) {
            name = name.substring(0, 10) + "..";
        }
        return name;
    }

    public static void registerCoilType(int temperature, Material coilMaterial, String coilName) {
        Validate.notNull((Object)coilName);
        if (coilMaterial == null) {
            registeredCoilTypes.put(temperature, coilName);
        } else {
            registeredCoilTypes.put(temperature, coilMaterial);
        }
    }
}

