/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.properties.impl;

import gregtech.api.GregTechAPI;
import gregtech.api.recipes.properties.RecipeProperty;
import gregtech.api.util.TextFormattingUtil;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagLong;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public final class FusionEUToStartProperty
extends RecipeProperty<Long> {
    public static final String KEY = "eu_to_start";
    private static final TreeMap<Long, Pair<Integer, String>> registeredFusionTiers = new TreeMap();
    private static FusionEUToStartProperty INSTANCE;

    private FusionEUToStartProperty() {
        super(KEY, Long.class);
    }

    public static FusionEUToStartProperty getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FusionEUToStartProperty();
            GregTechAPI.RECIPE_PROPERTIES.register(KEY, INSTANCE);
        }
        return INSTANCE;
    }

    @Override
    @NotNull
    public NBTBase serialize(@NotNull Object value) {
        return new NBTTagLong(((Long)this.castValue(value)).longValue());
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull NBTBase nbt) {
        return ((NBTTagLong)nbt).func_150291_c();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInfo(Minecraft minecraft, int x, int y, int color, Object value) {
        minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gregtech.recipe.eu_to_start", (Object[])new Object[]{TextFormattingUtil.formatLongToCompactString((Long)this.castValue(value))}) + FusionEUToStartProperty.getFusionTierName((Long)this.castValue(value)), x, y, color);
    }

    private static String getFusionTierName(Long eu) {
        Map.Entry<Long, Pair<Integer, String>> mapEntry = registeredFusionTiers.ceilingEntry(eu);
        if (mapEntry == null) {
            throw new IllegalArgumentException("Value is above registered maximum EU values");
        }
        return String.format(" %s", mapEntry.getValue().getRight());
    }

    public static int getFusionTier(Long eu) {
        Map.Entry<Long, Pair<Integer, String>> mapEntry = registeredFusionTiers.ceilingEntry(eu);
        return mapEntry == null ? 0 : (Integer)mapEntry.getValue().getLeft();
    }

    public static void registerFusionTier(int tier, String shortName) {
        Validate.notNull((Object)shortName);
        long maxEU = 160000000L * (long)Math.pow(2.0, tier - 6);
        registeredFusionTiers.put(maxEU, (Pair<Integer, String>)Pair.of((Object)tier, (Object)shortName));
    }
}

