/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.properties.impl;

import gregtech.api.GregTechAPI;
import gregtech.api.recipes.properties.RecipeProperty;
import gregtech.api.worldgen.config.WorldGenRegistry;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public final class DimensionProperty
extends RecipeProperty<DimensionPropertyList> {
    public static final String KEY = "dimension";
    private static DimensionProperty INSTANCE;

    private DimensionProperty() {
        super(KEY, DimensionPropertyList.class);
    }

    public static DimensionProperty getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DimensionProperty();
            GregTechAPI.RECIPE_PROPERTIES.register(KEY, INSTANCE);
        }
        return INSTANCE;
    }

    @Override
    @NotNull
    public NBTBase serialize(@NotNull Object value) {
        DimensionPropertyList list = (DimensionPropertyList)this.castValue(value);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74783_a("whiteListDimensions", list.whiteListDimensions.toArray(new int[0]));
        tag.func_74783_a("blackListDimensions", list.blackListDimensions.toArray(new int[0]));
        return tag;
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull NBTBase nbt) {
        NBTTagCompound tag = (NBTTagCompound)nbt;
        DimensionPropertyList list = new DimensionPropertyList();
        for (int i : tag.func_74759_k("whiteListDimensions")) {
            list.add(i, false);
        }
        for (int i : tag.func_74759_k("blackListDimensions")) {
            list.add(i, true);
        }
        return tag;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInfo(Minecraft minecraft, int x, int y, int color, Object value) {
        DimensionPropertyList list = (DimensionPropertyList)this.castValue(value);
        if (list.whiteListDimensions.size() > 0) {
            minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gregtech.recipe.dimensions", (Object[])new Object[]{DimensionProperty.getDimensionsForRecipe(((DimensionPropertyList)this.castValue((Object)value)).whiteListDimensions)}), x, y, color);
        }
        if (list.blackListDimensions.size() > 0) {
            minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gregtech.recipe.dimensions_blocked", (Object[])new Object[]{DimensionProperty.getDimensionsForRecipe(((DimensionPropertyList)this.castValue((Object)value)).blackListDimensions)}), x, y, color);
        }
    }

    private static String getDimensionsForRecipe(IntList value) {
        Int2ObjectMap<String> dimNames = WorldGenRegistry.getNamedDimensions();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < value.size(); ++i) {
            builder.append((String)dimNames.getOrDefault((Object)value.getInt(i), (Object)String.valueOf(value.getInt(i))));
            if (i == value.size() - 1) continue;
            builder.append(", ");
        }
        String str = builder.toString();
        if (str.length() >= 13) {
            str = str.substring(0, 10) + "..";
        }
        return str;
    }

    public static class DimensionPropertyList {
        public static DimensionPropertyList EMPTY_LIST = new DimensionPropertyList();
        public final IntList whiteListDimensions = new IntArrayList();
        public final IntList blackListDimensions = new IntArrayList();

        public void add(int key, boolean toBlacklist) {
            if (toBlacklist) {
                this.blackListDimensions.add(key);
                this.whiteListDimensions.rem(key);
            } else {
                this.whiteListDimensions.add(key);
                this.blackListDimensions.rem(key);
            }
        }

        public void merge(@NotNull DimensionPropertyList list) {
            this.whiteListDimensions.addAll(list.whiteListDimensions);
            this.blackListDimensions.addAll(list.blackListDimensions);
        }

        public boolean checkDimension(int dim) {
            return !this.blackListDimensions.contains(dim) && this.whiteListDimensions.contains(dim);
        }
    }
}

