/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.properties.impl;

import gregtech.api.GregTechAPI;
import gregtech.api.metatileentity.multiblock.CleanroomType;
import gregtech.api.recipes.properties.RecipeProperty;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public final class CleanroomProperty
extends RecipeProperty<CleanroomType> {
    public static final String KEY = "cleanroom";
    private static CleanroomProperty INSTANCE;

    private CleanroomProperty() {
        super(KEY, CleanroomType.class);
    }

    public static CleanroomProperty getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CleanroomProperty();
            GregTechAPI.RECIPE_PROPERTIES.register(KEY, INSTANCE);
        }
        return INSTANCE;
    }

    @Override
    @NotNull
    public NBTBase serialize(@NotNull Object value) {
        return new NBTTagString(((CleanroomType)this.castValue(value)).getName());
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull NBTBase nbt) {
        return Objects.requireNonNull(CleanroomType.getByName(((NBTTagString)nbt).func_150285_a_()));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInfo(@NotNull Minecraft minecraft, int x, int y, int color, Object value) {
        CleanroomType type = (CleanroomType)this.castValue(value);
        minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gregtech.recipe.cleanroom", (Object[])new Object[]{CleanroomProperty.getName(type)}), x, y, color);
    }

    @NotNull
    private static String getName(@NotNull CleanroomType value) {
        String name = I18n.func_135052_a((String)value.getTranslationKey(), (Object[])new Object[0]);
        if (name.length() >= 20) {
            return name.substring(0, 20) + "..";
        }
        return name;
    }
}

