/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.properties;

import gregtech.api.GregTechAPI;
import gregtech.api.recipes.properties.RecipeProperty;
import gregtech.api.recipes.properties.RecipePropertyStorage;
import gregtech.api.util.GTLog;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public final class RecipePropertyStorageImpl
implements RecipePropertyStorage {
    private final Map<RecipeProperty<?>, Object> map;

    public RecipePropertyStorageImpl() {
        this((Map<RecipeProperty<?>, Object>)new Object2ObjectArrayMap(1));
    }

    private RecipePropertyStorageImpl(@NotNull Map<RecipeProperty<?>, Object> map) {
        this.map = map;
    }

    @Override
    public boolean store(@NotNull RecipeProperty<?> recipeProperty, @NotNull Object value) {
        String key = recipeProperty.getKey();
        if (this.map.containsKey(recipeProperty)) {
            GTLog.logger.warn("Duplicate recipe property added: {} -> {}", (Object)key, value, (Object)new Throwable());
            return false;
        }
        try {
            recipeProperty.castValue(value);
        }
        catch (ClassCastException e) {
            GTLog.logger.error("Provided incorrect value for RecipeProperty with key {}", (Object)key, (Object)e);
            return false;
        }
        this.map.put(recipeProperty, value);
        return true;
    }

    @Override
    @NotNull
    public RecipePropertyStorage copy() {
        return new RecipePropertyStorageImpl((Map<RecipeProperty<?>, Object>)new Object2ObjectArrayMap(this.map));
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    @NotNull
    public Set<Map.Entry<RecipeProperty<?>, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    @Contract(value="_, !null -> !null")
    @Nullable
    public <T> T get(@NotNull RecipeProperty<T> recipeProperty, @Nullable T defaultValue) {
        Object value = this.map.get(recipeProperty);
        if (value == null) {
            return defaultValue;
        }
        return recipeProperty.castValue(value);
    }

    @Override
    public boolean contains(@NotNull RecipeProperty<?> recipeProperty) {
        return this.map.containsKey(recipeProperty);
    }

    @Override
    @NotNull
    public @UnmodifiableView @NotNull Set<@NotNull RecipeProperty<?>> values() {
        return this.map.keySet();
    }

    @NotNull
    public String toString() {
        return "RecipePropertyStorage{" + this.map + '}';
    }

    @Override
    @NotNull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        for (Map.Entry<RecipeProperty<?>, Object> entry : this.map.entrySet()) {
            RecipeProperty<?> property = entry.getKey();
            tag.func_74782_a(property.getKey(), property.serialize(entry.getValue()));
        }
        return tag;
    }

    @Override
    public void deserializeNBT(@NotNull NBTTagCompound nbt) {
        for (Map.Entry entry : nbt.field_74784_a.entrySet()) {
            RecipeProperty<?> property = GregTechAPI.RECIPE_PROPERTIES.get((String)entry.getKey());
            if (property == null) {
                GTLog.logger.warn("Failed to read property with key {}", entry.getKey());
                continue;
            }
            this.map.put(property, property.deserialize((NBTBase)entry.getValue()));
        }
    }
}

