/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.properties;

import gregtech.api.recipes.properties.RecipeProperty;
import gregtech.api.util.GTLog;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public interface RecipePropertyStorage {
    public static final RecipePropertyStorage EMPTY = new RecipePropertyStorage(){

        @Override
        public boolean store(@NotNull RecipeProperty<?> recipeProperty, @NotNull Object value) {
            throw new UnsupportedOperationException("empty");
        }

        @Override
        @NotNull
        public RecipePropertyStorage copy() {
            return this;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        @NotNull
        public Set<Map.Entry<RecipeProperty<?>, Object>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        @Nullable
        public <T> T get(@NotNull RecipeProperty<T> recipeProperty, @Nullable T defaultValue) {
            return defaultValue;
        }

        @Override
        public boolean contains(@NotNull RecipeProperty<?> recipeProperty) {
            return false;
        }

        @Override
        @NotNull
        public @UnmodifiableView @NotNull Set<@NotNull RecipeProperty<?>> values() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public NBTTagCompound serializeNBT() {
            return new NBTTagCompound();
        }

        @Override
        public void deserializeNBT(@NotNull NBTTagCompound nbt) {
            if (!nbt.func_82582_d()) {
                GTLog.logger.warn("Tried to deserialize non-empty tag in RecipePropertyStorage.EMPTY: {}", (Object)nbt, (Object)new Throwable());
            }
        }
    };

    public boolean store(@NotNull RecipeProperty<?> var1, @NotNull Object var2);

    @NotNull
    public RecipePropertyStorage copy();

    public int size();

    @NotNull
    public Set<Map.Entry<RecipeProperty<?>, Object>> entrySet();

    @Contract(value="_, !null -> !null")
    @Nullable
    public <T> T get(@NotNull RecipeProperty<T> var1, @Nullable T var2);

    public boolean contains(@NotNull RecipeProperty<?> var1);

    @NotNull
    public @UnmodifiableView @NotNull Set<@NotNull RecipeProperty<?>> values();

    @NotNull
    public NBTTagCompound serializeNBT();

    public void deserializeNBT(@NotNull NBTTagCompound var1);
}

