/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.properties;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public abstract class RecipeProperty<T> {
    private final Class<T> type;
    private final String key;

    protected RecipeProperty(String key, Class<T> type) {
        this.key = key;
        this.type = type;
    }

    @NotNull
    public abstract NBTBase serialize(@NotNull Object var1);

    @NotNull
    public abstract Object deserialize(@NotNull NBTBase var1);

    @SideOnly(value=Side.CLIENT)
    public abstract void drawInfo(Minecraft var1, int var2, int var3, int var4, Object var5);

    @SideOnly(value=Side.CLIENT)
    public void drawInfo(Minecraft minecraft, int x, int y, int color, Object value, int mouseX, int mouseY) {
        this.drawInfo(minecraft, x, y, color, value);
    }

    @SideOnly(value=Side.CLIENT)
    public void getTooltipStrings(List<String> tooltip, int mouseX, int mouseY, Object value) {
    }

    public int getInfoHeight(@NotNull Object value) {
        return 10;
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    protected final T castValue(@NotNull Object value) {
        return this.type.cast(value);
    }

    public boolean isHidden() {
        return false;
    }

    public boolean hideTotalEU() {
        return false;
    }

    public boolean hideEUt() {
        return false;
    }

    public boolean hideDuration() {
        return false;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecipeProperty)) {
            return false;
        }
        RecipeProperty that = (RecipeProperty)o;
        return this.type.equals(that.type) && this.getKey().equals(that.getKey());
    }

    public final int hashCode() {
        return 31 * this.type.hashCode() + this.getKey().hashCode();
    }

    public String toString() {
        return "RecipeProperty{key='" + this.key + "'}";
    }
}

