/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.map;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class Either<L, R> {
    private Either() {
    }

    public abstract <C, D> Either<C, D> mapBoth(Function<? super L, ? extends C> var1, Function<? super R, ? extends D> var2);

    public abstract <T> T map(Function<? super L, ? extends T> var1, Function<? super R, ? extends T> var2);

    public abstract Either<L, R> ifLeft(Consumer<? super L> var1);

    public abstract Either<L, R> ifRight(Consumer<? super R> var1);

    public abstract Optional<L> left();

    public abstract Optional<R> right();

    public <T> Either<T, R> mapLeft(Function<? super L, ? extends T> l) {
        return this.map(t -> Either.left(l.apply((Object)t)), Either::right);
    }

    public <T> Either<L, T> mapRight(Function<? super R, ? extends T> l) {
        return this.map(Either::left, t -> Either.right(l.apply((Object)t)));
    }

    public static <L, R> Either<L, R> left(L value) {
        return new Left(value);
    }

    public static <L, R> Either<L, R> right(R value) {
        return new Right(value);
    }

    public L orThrow() {
        return (L)this.map(l -> l, r -> {
            if (r instanceof Throwable) {
                throw new RuntimeException((Throwable)r);
            }
            throw new RuntimeException(r.toString());
        });
    }

    public Either<R, L> swap() {
        return this.map(Either::right, Either::left);
    }

    public <L2> Either<L2, R> flatMap(Function<L, Either<L2, R>> function) {
        return this.map(function, Either::right);
    }

    private static final class Left<L, R>
    extends Either<L, R> {
        private final L value;

        public Left(L value) {
            this.value = value;
        }

        @Override
        public <C, D> Either<C, D> mapBoth(Function<? super L, ? extends C> f1, Function<? super R, ? extends D> f2) {
            return new Left<C, R>(f1.apply(this.value));
        }

        @Override
        public <T> T map(Function<? super L, ? extends T> l, Function<? super R, ? extends T> r) {
            return l.apply(this.value);
        }

        @Override
        public Either<L, R> ifLeft(Consumer<? super L> consumer) {
            consumer.accept(this.value);
            return this;
        }

        @Override
        public Either<L, R> ifRight(Consumer<? super R> consumer) {
            return this;
        }

        @Override
        public Optional<L> left() {
            return Optional.of(this.value);
        }

        @Override
        public Optional<R> right() {
            return Optional.empty();
        }

        public String toString() {
            return "Left[" + this.value + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Left left = (Left)o;
            return Objects.equals(this.value, left.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    private static final class Right<L, R>
    extends Either<L, R> {
        private final R value;

        public Right(R value) {
            this.value = value;
        }

        @Override
        public <C, D> Either<C, D> mapBoth(Function<? super L, ? extends C> f1, Function<? super R, ? extends D> f2) {
            return new Right<L, D>(f2.apply(this.value));
        }

        @Override
        public <T> T map(Function<? super L, ? extends T> l, Function<? super R, ? extends T> r) {
            return r.apply(this.value);
        }

        @Override
        public Either<L, R> ifLeft(Consumer<? super L> consumer) {
            return this;
        }

        @Override
        public Either<L, R> ifRight(Consumer<? super R> consumer) {
            consumer.accept(this.value);
            return this;
        }

        @Override
        public Optional<L> left() {
            return Optional.empty();
        }

        @Override
        public Optional<R> right() {
            return Optional.of(this.value);
        }

        public String toString() {
            return "Right[" + this.value + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Right right = (Right)o;
            return Objects.equals(this.value, right.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

