/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.machines;

import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.recipes.machines.IScannerRecipeMap;
import gregtech.api.recipes.ui.RecipeMapUIFunction;
import gregtech.core.sound.GTSoundEvents;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class RecipeMapScanner
extends RecipeMap<SimpleRecipeBuilder>
implements IScannerRecipeMap {
    private static final List<IScannerRecipeMap.ICustomScannerLogic> CUSTOM_SCANNER_LOGICS = new ArrayList<IScannerRecipeMap.ICustomScannerLogic>();

    public RecipeMapScanner(@NotNull String unlocalizedName, @NotNull SimpleRecipeBuilder defaultRecipeBuilder, @NotNull RecipeMapUIFunction recipeMapUI) {
        super(unlocalizedName, defaultRecipeBuilder, recipeMapUI, 2, 1, 1, 0);
        this.setSound(GTSoundEvents.ELECTROLYZER);
        this.getPrimaryRecipeCategory().jeiSortToBack(true);
    }

    @Override
    @NotNull
    public List<Recipe> getRepresentativeRecipes() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        for (IScannerRecipeMap.ICustomScannerLogic logic : CUSTOM_SCANNER_LOGICS) {
            List<Recipe> logicRecipes = logic.getRepresentativeRecipes();
            if (logicRecipes == null || logicRecipes.isEmpty()) continue;
            recipes.addAll(logicRecipes);
        }
        return recipes;
    }

    public static void registerCustomScannerLogic(IScannerRecipeMap.ICustomScannerLogic logic) {
        CUSTOM_SCANNER_LOGICS.add(logic);
    }

    @Override
    @Nullable
    public Recipe findRecipe(long voltage, List<ItemStack> inputs, List<FluidStack> fluidInputs, boolean exactVoltage) {
        Recipe recipe = super.findRecipe(voltage, inputs, fluidInputs, exactVoltage);
        if (recipe != null) {
            return recipe;
        }
        for (IScannerRecipeMap.ICustomScannerLogic logic : CUSTOM_SCANNER_LOGICS) {
            recipe = logic.createCustomRecipe(voltage, inputs, fluidInputs, exactVoltage);
            if (recipe == null) continue;
            return recipe;
        }
        return null;
    }
}

