/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.logic;

import gregtech.api.recipes.logic.OCParams;
import gregtech.api.recipes.logic.OCResult;
import org.jetbrains.annotations.NotNull;

public final class OverclockingLogic {
    public static final double STD_VOLTAGE_FACTOR = 4.0;
    public static final double PERFECT_HALF_VOLTAGE_FACTOR = 2.0;
    public static final double STD_DURATION_FACTOR = 0.5;
    public static final double STD_DURATION_FACTOR_INV = 2.0;
    public static final double PERFECT_DURATION_FACTOR = 0.25;
    public static final double PERFECT_DURATION_FACTOR_INV = 4.0;
    public static final double PERFECT_HALF_DURATION_FACTOR = 0.5;
    public static final double PERFECT_HALF_DURATION_FACTOR_INV = 2.0;
    public static final int COIL_EUT_DISCOUNT_TEMPERATURE = 900;

    private OverclockingLogic() {
    }

    public static void standardOC(@NotNull OCParams params, @NotNull OCResult result, long maxVoltage, double durationFactor, double voltageFactor) {
        double potentialDuration;
        double potentialEUt;
        double duration = params.duration();
        double eut = params.eut();
        int ocAmount = params.ocAmount();
        while (ocAmount-- > 0 && !((potentialEUt = eut * voltageFactor) > (double)maxVoltage) && !((potentialDuration = duration * durationFactor) < 1.0)) {
            eut = potentialEUt;
            duration = potentialDuration;
        }
        result.init((long)eut, (int)duration);
    }

    public static void subTickNonParallelOC(@NotNull OCParams params, @NotNull OCResult result, long maxVoltage, double durationFactor, double voltageFactor) {
        double potentialEUt;
        double duration = params.duration();
        double eut = params.eut();
        int ocAmount = params.ocAmount();
        while (ocAmount-- > 0 && !((potentialEUt = eut * voltageFactor) > (double)maxVoltage) && !(potentialEUt < 1.0)) {
            double potentialDuration = duration * durationFactor;
            if (potentialDuration < 1.0) {
                potentialEUt = eut * durationFactor;
                if (potentialEUt > (double)maxVoltage || potentialEUt < 1.0) {
                    break;
                }
            } else {
                duration = potentialDuration;
            }
            eut = potentialEUt;
        }
        result.init((long)eut, (int)duration);
    }

    public static void subTickParallelOC(@NotNull OCParams params, @NotNull OCResult result, long maxVoltage, double durationFactor, double voltageFactor) {
        double potentialEUt;
        double duration = params.duration();
        double eut = params.eut();
        int ocAmount = params.ocAmount();
        double parallel = 1.0;
        int parallelIterAmount = 0;
        boolean shouldParallel = false;
        while (ocAmount-- > 0 && !((potentialEUt = eut * voltageFactor) > (double)maxVoltage)) {
            eut = potentialEUt;
            if (shouldParallel) {
                parallel /= durationFactor;
                ++parallelIterAmount;
                continue;
            }
            double potentialDuration = duration * durationFactor;
            if (potentialDuration < 1.0) {
                parallel /= durationFactor;
                ++parallelIterAmount;
                shouldParallel = true;
                continue;
            }
            duration = potentialDuration;
        }
        result.init((long)(eut / Math.pow(voltageFactor, parallelIterAmount)), (int)duration, (int)parallel, (long)eut);
    }

    public static void heatingCoilOC(@NotNull OCParams params, @NotNull OCResult result, long maxVoltage, int providedTemp, int requiredTemp) {
        int perfectOCAmount = OverclockingLogic.calculateAmountCoilEUtDiscount(providedTemp, requiredTemp) / 2;
        double duration = params.duration();
        double eut = params.eut();
        int ocAmount = params.ocAmount();
        double parallel = 1.0;
        int parallelIterAmount = 0;
        boolean shouldParallel = false;
        while (ocAmount-- > 0) {
            boolean perfect = perfectOCAmount-- > 0;
            double potentialEUt = eut * 4.0;
            if (potentialEUt > (double)maxVoltage) break;
            eut = potentialEUt;
            if (shouldParallel) {
                parallel = perfect ? (parallel *= 4.0) : (parallel *= 2.0);
                ++parallelIterAmount;
                continue;
            }
            double potentialDuration = perfect ? duration * 0.25 : duration * 0.5;
            if (potentialDuration < 1.0) {
                parallel = perfect ? (parallel *= 4.0) : (parallel *= 2.0);
                ++parallelIterAmount;
                shouldParallel = true;
                continue;
            }
            duration = potentialDuration;
        }
        result.init((long)(eut / Math.pow(4.0, parallelIterAmount)), (int)duration, (int)parallel, (long)eut);
    }

    public static void heatingCoilNonSubTickOC(@NotNull OCParams params, @NotNull OCResult result, long maxVoltage, int providedTemp, int requiredTemp) {
        int perfectOCAmount = OverclockingLogic.calculateAmountCoilEUtDiscount(providedTemp, requiredTemp) / 2;
        double duration = params.duration();
        double eut = params.eut();
        int ocAmount = params.ocAmount();
        while (ocAmount-- > 0) {
            boolean perfect = perfectOCAmount-- > 0;
            double potentialEUt = eut * 4.0;
            if (potentialEUt > (double)maxVoltage) break;
            eut = potentialEUt;
            double potentialDuration = perfect ? duration * 0.25 : duration * 0.5;
            if (potentialDuration < 1.0) break;
            duration = potentialDuration;
        }
        result.init((long)eut, (int)duration);
    }

    private static int calculateAmountCoilEUtDiscount(int providedTemp, int requiredTemp) {
        return Math.max(0, (providedTemp - requiredTemp) / 900);
    }

    public static long applyCoilEUtDiscount(long recipeEUt, int providedTemp, int requiredTemp) {
        if (requiredTemp < 900) {
            return recipeEUt;
        }
        int amountEUtDiscount = OverclockingLogic.calculateAmountCoilEUtDiscount(providedTemp, requiredTemp);
        if (amountEUtDiscount < 1) {
            return recipeEUt;
        }
        return (long)((double)recipeEUt * Math.min(1.0, Math.pow(0.95, amountEUtDiscount)));
    }
}

