/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.logic;

import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.metatileentity.IVoidable;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.multiblock.ParallelLogicType;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.logic.ParallelLogic;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IParallelableRecipeLogic {
    default public void applyParallelBonus(@NotNull RecipeBuilder<?> builder) {
    }

    default public RecipeBuilder<?> findMultipliedParallelRecipe(@NotNull RecipeMap<?> recipeMap, @NotNull Recipe currentRecipe, @NotNull IItemHandlerModifiable inputs, @NotNull IMultipleTankHandler fluidInputs, @NotNull IItemHandlerModifiable outputs, @NotNull IMultipleTankHandler fluidOutputs, int parallelLimit, long maxVoltage, @NotNull IVoidable voidable) {
        return ParallelLogic.doParallelRecipes(currentRecipe, recipeMap, inputs, fluidInputs, outputs, fluidOutputs, parallelLimit, maxVoltage, voidable);
    }

    default public RecipeBuilder<?> findAppendedParallelItemRecipe(@NotNull RecipeMap<?> recipeMap, @NotNull IItemHandlerModifiable inputs, @NotNull IItemHandlerModifiable outputs, int parallelLimit, long maxVoltage, @NotNull IVoidable voidable) {
        return ParallelLogic.appendItemRecipes(recipeMap, inputs, outputs, parallelLimit, maxVoltage, voidable);
    }

    default public Recipe findParallelRecipe(@NotNull Recipe currentRecipe, @NotNull IItemHandlerModifiable inputs, @NotNull IMultipleTankHandler fluidInputs, @NotNull IItemHandlerModifiable outputs, @NotNull IMultipleTankHandler fluidOutputs, long maxVoltage, int parallelLimit) {
        if (parallelLimit > 1 && this.getRecipeMap() != null) {
            RecipeBuilder<?> parallelBuilder;
            switch (this.getParallelLogicType()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case MULTIPLY: {
                    RecipeBuilder<?> recipeBuilder = this.findMultipliedParallelRecipe(this.getRecipeMap(), currentRecipe, inputs, fluidInputs, outputs, fluidOutputs, parallelLimit, maxVoltage, this.getMetaTileEntity());
                    break;
                }
                case APPEND_ITEMS: {
                    RecipeBuilder<?> recipeBuilder = parallelBuilder = this.findAppendedParallelItemRecipe(this.getRecipeMap(), inputs, outputs, parallelLimit, maxVoltage, this.getMetaTileEntity());
                }
            }
            if (parallelBuilder == null) {
                this.invalidateInputs();
                return null;
            }
            if (parallelBuilder.getParallel() == 0) {
                this.invalidateOutputs();
                return null;
            }
            this.setParallelRecipesPerformed(parallelBuilder.getParallel());
            this.applyParallelBonus(parallelBuilder);
            return parallelBuilder.build().getResult();
        }
        return currentRecipe;
    }

    @NotNull
    public MetaTileEntity getMetaTileEntity();

    @Nullable
    public RecipeMap<?> getRecipeMap();

    @NotNull
    public ParallelLogicType getParallelLogicType();

    public void setParallelRecipesPerformed(int var1);

    public void invalidateInputs();

    public void invalidateOutputs();
}

