/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.ingredients.nbtmatch;

import gregtech.api.recipes.ingredients.nbtmatch.NBTCondition;
import gregtech.api.recipes.ingredients.nbtmatch.NBTTagType;
import gregtech.api.util.GTLog;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.NBTBase;

public class ListNBTCondition
extends NBTCondition {
    public final NBTTagType listTagType;

    public static ListNBTCondition create(NBTTagType listTagType, String nbtKey, List<NBTBase> value) {
        return new ListNBTCondition(listTagType, nbtKey, value);
    }

    protected ListNBTCondition(NBTTagType listTagType, String nbtKey, Object value) {
        super(NBTTagType.LIST, nbtKey, value);
        this.listTagType = listTagType;
        if (listTagType == null) {
            GTLog.logger.error("ListNBTCondition must not have null parameters.", new Throwable());
        }
    }

    @Override
    public String toString() {
        return this.nbtKey + " (type " + (Object)((Object)this.listTagType) + ") :" + this.value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.tagType, this.nbtKey, this.value, this.listTagType});
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ListNBTCondition) {
            ListNBTCondition o = (ListNBTCondition)obj;
            return this.tagType == o.tagType && this.nbtKey.equals(o.nbtKey) && this.value.equals(o.value) && this.listTagType == o.listTagType;
        }
        return false;
    }
}

