/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.ingredients;

import gregtech.api.recipes.ingredients.GTRecipeInput;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

public class GTRecipeItemInput
extends GTRecipeInput {
    private final ItemStack[] inputStacks;
    private final List<GTRecipeInput.ItemToMetaList> itemList = new ObjectArrayList();

    public GTRecipeItemInput(ItemStack stack) {
        this(new ItemStack[]{stack}, stack.func_190916_E());
    }

    public GTRecipeItemInput(ItemStack stack, int amount) {
        this(new ItemStack[]{stack}, amount);
    }

    public GTRecipeItemInput(GTRecipeInput input) {
        this(input.getInputStacks());
    }

    public GTRecipeItemInput(GTRecipeInput input, int amount) {
        this(input.getInputStacks(), amount);
    }

    public GTRecipeItemInput(ItemStack ... stacks) {
        this(stacks, stacks[0].func_190916_E());
    }

    public GTRecipeItemInput(ItemStack[] stack, int amount) {
        this.amount = amount;
        NonNullList lst = NonNullList.func_191196_a();
        for (ItemStack is2 : stack) {
            if (is2.func_77960_j() == Short.MAX_VALUE) {
                is2.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, lst);
                continue;
            }
            lst.add((Object)is2);
        }
        for (ItemStack is3 : lst) {
            boolean addedStack = false;
            if (is3.func_190926_b()) continue;
            for (GTRecipeInput.ItemToMetaList item : this.itemList) {
                if (item.getKey() != is3.func_77973_b()) continue;
                Object metaList = item.getValue();
                Iterator iterator = metaList.iterator();
                while (iterator.hasNext()) {
                    GTRecipeInput.MetaToTAGList meta = (GTRecipeInput.MetaToTAGList)iterator.next();
                    if (meta.getIntKey() != is3.func_77960_j()) continue;
                    meta.addStackToList(is3);
                    addedStack = true;
                    break;
                }
                if (addedStack) break;
                item.addStackToLists(is3);
                addedStack = true;
                break;
            }
            if (addedStack) continue;
            this.itemList.add(new GTRecipeInput.ItemToMetaList(is3));
        }
        this.inputStacks = (ItemStack[])lst.stream().map(is -> {
            is = is.func_77946_l();
            is.func_190920_e(this.amount);
            return is;
        }).toArray(ItemStack[]::new);
    }

    @Deprecated
    public static GTRecipeInput getOrCreate(ItemStack stack, int amount) {
        return new GTRecipeItemInput(stack, amount);
    }

    @Deprecated
    public static GTRecipeInput getOrCreate(GTRecipeInput ri, int i) {
        return new GTRecipeItemInput(ri, i);
    }

    @Deprecated
    public static GTRecipeInput getOrCreate(GTRecipeInput input) {
        return new GTRecipeItemInput(input);
    }

    @Deprecated
    public static GTRecipeInput getOrCreate(ItemStack stack) {
        return new GTRecipeItemInput(stack);
    }

    @Deprecated
    public static GTRecipeInput getOrCreate(ItemStack[] stacks) {
        return new GTRecipeItemInput(stacks);
    }

    @Override
    protected GTRecipeItemInput copy() {
        GTRecipeItemInput copy = new GTRecipeItemInput(this.inputStacks, this.amount);
        copy.isConsumable = this.isConsumable;
        copy.nbtMatcher = this.nbtMatcher;
        copy.nbtCondition = this.nbtCondition;
        return copy;
    }

    @Override
    public GTRecipeInput copyWithAmount(int amount) {
        GTRecipeItemInput copy = new GTRecipeItemInput(this.inputStacks, amount);
        copy.isConsumable = this.isConsumable;
        copy.nbtMatcher = this.nbtMatcher;
        copy.nbtCondition = this.nbtCondition;
        return copy;
    }

    @Override
    public ItemStack[] getInputStacks() {
        return this.inputStacks;
    }

    @Override
    public boolean acceptsStack(ItemStack input) {
        if (input == null || input.func_190926_b()) {
            return false;
        }
        List<GTRecipeInput.ItemToMetaList> itemList = this.itemList;
        Item inputItem = input.func_77973_b();
        for (GTRecipeInput.ItemToMetaList metaList : itemList) {
            if (metaList.item != inputItem) continue;
            List<GTRecipeInput.MetaToTAGList> tagLists = metaList.metaToTAGList;
            for (GTRecipeInput.MetaToTAGList tagList : tagLists) {
                if (tagList.meta != input.func_77960_j()) continue;
                NBTTagCompound inputNBT = input.func_77978_p();
                if (this.nbtMatcher != null) {
                    return this.nbtMatcher.evaluate(input, this.nbtCondition);
                }
                List<GTRecipeInput.TagToStack> tagMaps = tagList.tagToStack;
                for (GTRecipeInput.TagToStack tagMapping : tagMaps) {
                    if ((inputNBT != null || tagMapping.tag != null) && (inputNBT == null || !inputNBT.equals((Object)tagMapping.tag))) continue;
                    return tagMapping.stack.areCapsCompatible(input);
                }
            }
        }
        return false;
    }

    @Override
    protected int computeHash() {
        int hash = 1;
        for (ItemStack stack : this.inputStacks) {
            hash = 31 * hash + stack.func_77973_b().hashCode();
            hash = 31 * hash + stack.func_77960_j();
            if (!stack.func_77942_o() || stack.func_77978_p() == null || this.nbtMatcher != null) continue;
            hash = 31 * hash + stack.func_77978_p().hashCode();
        }
        hash = 31 * hash + this.amount;
        hash = 31 * hash + (this.isConsumable ? 1 : 0);
        hash = 31 * hash + (this.nbtMatcher != null ? this.nbtMatcher.hashCode() : 0);
        hash = 31 * hash + (this.nbtCondition != null ? this.nbtCondition.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GTRecipeItemInput)) {
            return false;
        }
        GTRecipeItemInput other = (GTRecipeItemInput)obj;
        if (this.amount != other.amount || this.isConsumable != other.isConsumable) {
            return false;
        }
        if (!Objects.equals(this.nbtMatcher, other.nbtMatcher)) {
            return false;
        }
        if (!Objects.equals(this.nbtCondition, other.nbtCondition)) {
            return false;
        }
        if (this.inputStacks.length != other.inputStacks.length) {
            return false;
        }
        for (int i = 0; i < this.inputStacks.length; ++i) {
            if (ItemStack.func_77989_b((ItemStack)this.inputStacks[i], (ItemStack)other.inputStacks[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalIgnoreAmount(GTRecipeInput input) {
        if (this == input) {
            return true;
        }
        if (!(input instanceof GTRecipeItemInput)) {
            return false;
        }
        GTRecipeItemInput other = (GTRecipeItemInput)input;
        if (!Objects.equals(this.nbtMatcher, other.nbtMatcher)) {
            return false;
        }
        if (!Objects.equals(this.nbtCondition, other.nbtCondition)) {
            return false;
        }
        if (this.inputStacks.length != other.inputStacks.length) {
            return false;
        }
        for (int i = 0; i < this.inputStacks.length; ++i) {
            if (ItemStack.func_179545_c((ItemStack)this.inputStacks[i], (ItemStack)other.inputStacks[i]) && ItemStack.func_77970_a((ItemStack)this.inputStacks[i], (ItemStack)other.inputStacks[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        switch (this.inputStacks.length) {
            case 0: {
                return this.amount + "x[]";
            }
            case 1: {
                return this.amount + "x" + GTRecipeItemInput.toStringWithoutQuantity(this.inputStacks[0]);
            }
        }
        return this.amount + "x[" + Arrays.stream(this.inputStacks).map(GTRecipeItemInput::toStringWithoutQuantity).collect(Collectors.joining("|")) + "]";
    }

    private static String toStringWithoutQuantity(ItemStack stack) {
        return stack.func_77973_b().func_77667_c(stack) + "@" + stack.func_77952_i();
    }
}

