/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.ingredients;

import gregtech.api.recipes.ingredients.GTRecipeFluidInput;
import gregtech.api.recipes.ingredients.GTRecipeItemInput;
import gregtech.api.recipes.ingredients.GTRecipeOreInput;
import gregtech.api.recipes.ingredients.nbtmatch.NBTCondition;
import gregtech.api.recipes.ingredients.nbtmatch.NBTMatcher;
import gregtech.api.util.GTLog;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public abstract class GTRecipeInput {
    public static final int SORTING_ORDER_COMMON = 0;
    public static final int SORTING_ORDER_NC = 5;
    public static final int SORTING_ORDER_INT_CIRCUIT = 10;
    public static final Comparator<GTRecipeInput> RECIPE_INPUT_COMPARATOR = Comparator.comparingInt(GTRecipeInput::getSortingOrder);
    protected int amount;
    protected boolean isConsumable = true;
    protected NBTMatcher nbtMatcher;
    protected NBTCondition nbtCondition;
    private boolean cached;
    private int hash;
    protected boolean hashCached;

    @Deprecated
    public static GTRecipeInput getOrCreate(GTRecipeInput gtRecipeIngredient) {
        return gtRecipeIngredient;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached() {
        this.cached = true;
    }

    protected abstract GTRecipeInput copy();

    public abstract GTRecipeInput copyWithAmount(int var1);

    public GTRecipeInput withAmount(int amount) {
        if (this.getAmount() == amount) {
            return this;
        }
        if (this.isCached()) {
            return this.copyWithAmount(amount);
        }
        this.amount = amount;
        this.hashCached = false;
        return this;
    }

    public GTRecipeInput setNonConsumable() {
        if (!this.isConsumable) {
            return this;
        }
        GTRecipeInput recipeInput = this.cached ? this.copy() : this;
        recipeInput.isConsumable = false;
        recipeInput.hashCached = false;
        return recipeInput;
    }

    public GTRecipeInput setNBTMatchingCondition(NBTMatcher nbtMatcher, NBTCondition nbtCondition) {
        GTRecipeInput recipeInput = this.cached ? this.copy() : this;
        recipeInput.nbtMatcher = nbtMatcher;
        recipeInput.nbtCondition = nbtCondition;
        recipeInput.hashCached = false;
        return recipeInput;
    }

    public boolean hasNBTMatchingCondition() {
        return this.nbtMatcher != null;
    }

    public NBTMatcher getNBTMatcher() {
        return this.nbtMatcher;
    }

    public NBTCondition getNBTMatchingCondition() {
        return this.nbtCondition;
    }

    public boolean isNonConsumable() {
        return !this.isConsumable;
    }

    public ItemStack[] getInputStacks() {
        return null;
    }

    public FluidStack getInputFluidStack() {
        return null;
    }

    public boolean isOreDict() {
        return false;
    }

    public int getOreDict() {
        return -1;
    }

    public boolean acceptsStack(@Nullable ItemStack input) {
        return false;
    }

    public boolean acceptsFluid(@Nullable FluidStack input) {
        return false;
    }

    public int hashCode() {
        if (!this.hashCached) {
            this.hash = this.computeHash();
            this.hashCached = true;
        }
        return this.hash;
    }

    protected abstract int computeHash();

    public abstract boolean equals(Object var1);

    public abstract boolean equalIgnoreAmount(GTRecipeInput var1);

    public int getSortingOrder() {
        return this.isNonConsumable() ? 5 : 0;
    }

    public static NBTTagCompound writeToNBT(GTRecipeInput input) {
        NBTTagCompound tag = new NBTTagCompound();
        if (input instanceof GTRecipeItemInput) {
            NBTTagList stackList = new NBTTagList();
            for (ItemStack stack : input.getInputStacks()) {
                stackList.func_74742_a((NBTBase)stack.serializeNBT());
            }
            tag.func_74782_a("stacks", (NBTBase)stackList);
        } else if (input instanceof GTRecipeOreInput) {
            tag.func_74768_a("ore", input.getOreDict());
        } else if (input instanceof GTRecipeFluidInput) {
            tag.func_74782_a("fluid", (NBTBase)input.getInputFluidStack().writeToNBT(new NBTTagCompound()));
        }
        tag.func_74768_a("amount", input.getAmount());
        return tag;
    }

    public static GTRecipeInput readFromNBT(NBTTagCompound tag) {
        int amount = tag.func_74762_e("amount");
        if (tag.func_74764_b("stacks")) {
            NBTTagList list = tag.func_150295_c("stacks", 10);
            ItemStack[] stacks = new ItemStack[list.func_74745_c()];
            Arrays.setAll(stacks, i -> new ItemStack(list.func_150305_b(i)));
            return new GTRecipeItemInput(stacks, amount);
        }
        if (tag.func_74764_b("ore")) {
            return new GTRecipeOreInput(tag.func_74762_e("ore"), amount);
        }
        if (tag.func_74764_b("fluid")) {
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("fluid"));
            return new GTRecipeFluidInput(Objects.requireNonNull(stack), amount);
        }
        GTLog.logger.warn("unable to read tag!: " + tag);
        return null;
    }

    protected static class TagToStack
    implements Object2ObjectMap.Entry<NBTTagCompound, ItemStack> {
        NBTTagCompound tag;
        ItemStack stack;

        TagToStack(NBTTagCompound tag, ItemStack stack) {
            this.tag = tag;
            this.stack = stack;
        }

        TagToStack(ItemStack stack) {
            this.tag = stack.func_77978_p();
            this.stack = stack;
        }

        public NBTTagCompound getKey() {
            return this.tag;
        }

        public ItemStack getValue() {
            return this.stack;
        }

        public ItemStack setValue(ItemStack value) {
            this.stack = value;
            return this.stack;
        }
    }

    protected static class MetaToTAGList
    implements Int2ObjectMap.Entry<List<TagToStack>> {
        protected int meta;
        protected List<TagToStack> tagToStack;

        public MetaToTAGList(ItemStack stack) {
            this.meta = stack.func_77960_j();
            this.tagToStack = ObjectLists.singleton((Object)new TagToStack(stack));
        }

        void addStackToList(ItemStack stack) {
            if (this.tagToStack instanceof ObjectLists.Singleton) {
                this.tagToStack = new ObjectArrayList(this.tagToStack);
            }
            this.tagToStack.add(new TagToStack(stack.func_77978_p(), stack));
        }

        public Integer getKey() {
            return this.meta;
        }

        public int getIntKey() {
            return this.meta;
        }

        public List<TagToStack> getValue() {
            return this.tagToStack;
        }

        public List<TagToStack> setValue(List<TagToStack> value) {
            this.tagToStack = value;
            return this.tagToStack;
        }
    }

    protected static class ItemToMetaList
    implements Object2ObjectMap.Entry<Item, List<MetaToTAGList>> {
        protected Item item;
        protected List<MetaToTAGList> metaToTAGList;

        public ItemToMetaList(ItemStack stack) {
            this.item = stack.func_77973_b();
            this.metaToTAGList = ObjectLists.singleton((Object)new MetaToTAGList(stack));
        }

        void addStackToLists(ItemStack stack) {
            if (this.metaToTAGList instanceof ObjectLists.Singleton) {
                this.metaToTAGList = new ObjectArrayList(this.metaToTAGList);
            }
            this.metaToTAGList.add(new MetaToTAGList(stack));
        }

        public Item getKey() {
            return this.item;
        }

        public List<MetaToTAGList> getValue() {
            return this.metaToTAGList;
        }

        public List<MetaToTAGList> setValue(List<MetaToTAGList> value) {
            this.metaToTAGList = value;
            return this.metaToTAGList;
        }
    }
}

