/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.category;

import gregtech.api.recipes.RecipeMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public final class GTRecipeCategory {
    private static final Map<String, GTRecipeCategory> categories = new Object2ObjectOpenHashMap();
    private final String modid;
    private final String name;
    private final String uniqueID;
    private final String translationKey;
    private final RecipeMap<?> recipeMap;
    private Object icon;
    private boolean sortToBack;

    @NotNull
    public static GTRecipeCategory create(@NotNull String modid, @NotNull String categoryName, @NotNull String translationKey, @NotNull RecipeMap<?> recipeMap) {
        return categories.computeIfAbsent(categoryName, k -> new GTRecipeCategory(modid, categoryName, translationKey, recipeMap));
    }

    @Nullable
    public static GTRecipeCategory getByName(@NotNull String categoryName) {
        return categories.get(categoryName);
    }

    @NotNull
    public static @UnmodifiableView Collection<GTRecipeCategory> getCategories() {
        return Collections.unmodifiableCollection(categories.values());
    }

    private GTRecipeCategory(@NotNull String modid, @NotNull String name, @NotNull String translationKey, @NotNull RecipeMap<?> recipeMap) {
        this.modid = modid;
        this.name = name;
        this.uniqueID = modid + '.' + this.name;
        this.translationKey = translationKey;
        this.recipeMap = recipeMap;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getModid() {
        return this.modid;
    }

    @NotNull
    public String getUniqueID() {
        return this.uniqueID;
    }

    @NotNull
    public String getTranslationKey() {
        return this.translationKey;
    }

    @NotNull
    public RecipeMap<?> getRecipeMap() {
        return this.recipeMap;
    }

    @NotNull
    public GTRecipeCategory jeiIcon(@Nullable Object icon) {
        this.icon = icon;
        return this;
    }

    @Nullable
    public Object getJEIIcon() {
        return this.icon;
    }

    @NotNull
    public GTRecipeCategory jeiSortToBack(boolean sortToBack) {
        this.sortToBack = sortToBack;
        return this;
    }

    public boolean shouldSortToBackJEI() {
        return this.sortToBack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GTRecipeCategory that = (GTRecipeCategory)o;
        return this.getUniqueID().equals(that.getUniqueID());
    }

    public int hashCode() {
        return this.getUniqueID().hashCode();
    }

    @NotNull
    public String toString() {
        return "GTRecipeCategory{" + this.uniqueID + '}';
    }
}

