/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.builders;

import gregtech.api.GTValues;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IDataItem;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.builders.AssemblyLineRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.AssemblyLineManager;
import gregtech.api.util.GTStringUtils;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class ResearchRecipeBuilder<T extends ResearchRecipeBuilder<T>> {
    protected ItemStack researchStack;
    protected ItemStack dataStack;
    protected boolean ignoreNBT;
    protected String researchId;
    protected long eut;

    public T researchStack(@NotNull ItemStack researchStack) {
        if (!researchStack.func_190926_b()) {
            this.researchStack = researchStack;
            this.ignoreNBT = true;
        }
        return (T)this;
    }

    public T researchStack(@NotNull ItemStack researchStack, boolean ignoreNBT) {
        if (!researchStack.func_190926_b()) {
            this.researchStack = researchStack;
            this.ignoreNBT = ignoreNBT;
        }
        return (T)this;
    }

    public T researchStack(@NotNull MetaItem.MetaValueItem metaItem) {
        return this.researchStack(metaItem.getStackForm());
    }

    public T researchStack(@NotNull MetaItem.MetaValueItem metaItem, int amount) {
        return this.researchStack(metaItem.getStackForm(amount));
    }

    public T researchStack(@NotNull MetaItem.MetaValueItem metaItem, int amount, boolean ignoreNBT) {
        return this.researchStack(metaItem.getStackForm(amount), ignoreNBT);
    }

    public T researchStack(@NotNull MetaTileEntity mte) {
        return this.researchStack(mte.getStackForm());
    }

    public T researchStack(@NotNull MetaTileEntity mte, int amount) {
        return this.researchStack(mte.getStackForm(amount));
    }

    public T researchStack(@NotNull MetaTileEntity mte, int amount, boolean ignoreNBT) {
        return this.researchStack(mte.getStackForm(amount), ignoreNBT);
    }

    public T researchStack(@NotNull OrePrefix prefix, @NotNull Material material) {
        return this.researchStack(OreDictUnifier.get(prefix, material));
    }

    public T researchStack(@NotNull OrePrefix prefix, @NotNull Material material, int amount) {
        return this.researchStack(OreDictUnifier.get(prefix, material, amount));
    }

    public T researchStack(@NotNull OrePrefix prefix, @NotNull Material material, int amount, boolean ignoreNBT) {
        return this.researchStack(OreDictUnifier.get(prefix, material, amount), ignoreNBT);
    }

    public T researchStack(@NotNull Block block) {
        return this.researchStack(new ItemStack(block));
    }

    public T researchStack(@NotNull Block block, int amount) {
        return this.researchStack(new ItemStack(block, amount));
    }

    public T researchStack(@NotNull Block block, int amount, int meta) {
        return this.researchStack(new ItemStack(block, amount, meta));
    }

    public T researchStack(@NotNull Block block, int amount, boolean ignoreNBT) {
        return this.researchStack(new ItemStack(block, amount), ignoreNBT);
    }

    public T researchStack(@NotNull Block block, int amount, int meta, boolean ignoreNBT) {
        return this.researchStack(new ItemStack(block, amount, meta), ignoreNBT);
    }

    public T dataStack(@NotNull ItemStack dataStack) {
        if (!dataStack.func_190926_b()) {
            this.dataStack = dataStack;
        }
        return (T)this;
    }

    public T researchId(String researchId) {
        this.researchId = researchId;
        return (T)this;
    }

    public T EUt(long eut) {
        this.eut = eut;
        return (T)this;
    }

    protected void validateResearchItem() {
        if (this.researchStack == null) {
            throw new IllegalArgumentException("Research stack cannot be null or empty!");
        }
        if (this.researchId == null) {
            this.researchId = GTStringUtils.itemStackToString(this.researchStack);
        }
        if (this.dataStack == null) {
            this.dataStack = this.getDefaultDataItem();
        }
        boolean foundBehavior = false;
        Item item = this.dataStack.func_77973_b();
        if (item instanceof MetaItem) {
            MetaItem metaItem = (MetaItem)item;
            for (IItemBehaviour behaviour : metaItem.getBehaviours(this.dataStack)) {
                if (!(behaviour instanceof IDataItem)) continue;
                foundBehavior = true;
                this.dataStack = this.dataStack.func_77946_l();
                this.dataStack.func_190920_e(1);
                break;
            }
        }
        if (!foundBehavior) {
            throw new IllegalArgumentException("Data ItemStack must have the IDataItem behavior");
        }
    }

    protected abstract ItemStack getDefaultDataItem();

    protected abstract AssemblyLineRecipeBuilder.ResearchRecipeEntry build();

    public static class StationRecipeBuilder
    extends ResearchRecipeBuilder<StationRecipeBuilder> {
        public static final int DEFAULT_STATION_EUT = GTValues.VA[6];
        public static final int DEFAULT_STATION_TOTAL_CWUT = 4000;
        private int cwut;
        private int totalCWU;

        StationRecipeBuilder() {
        }

        public StationRecipeBuilder CWUt(int cwut) {
            this.cwut = cwut;
            this.totalCWU = cwut * 4000;
            return this;
        }

        public StationRecipeBuilder CWUt(int cwut, int totalCWU) {
            this.cwut = cwut;
            this.totalCWU = totalCWU;
            return this;
        }

        @Override
        protected ItemStack getDefaultDataItem() {
            return AssemblyLineManager.getDefaultResearchStationItem(this.cwut);
        }

        @Override
        protected AssemblyLineRecipeBuilder.ResearchRecipeEntry build() {
            this.validateResearchItem();
            if (this.cwut <= 0 || this.totalCWU <= 0) {
                throw new IllegalArgumentException("CWU/t and total CWU must both be set, and non-zero!");
            }
            if (this.cwut > this.totalCWU) {
                throw new IllegalArgumentException("Total CWU cannot be greater than CWU/t!");
            }
            int duration = this.totalCWU;
            if (this.eut <= 0L) {
                this.eut = DEFAULT_STATION_EUT;
            }
            return new AssemblyLineRecipeBuilder.ResearchRecipeEntry(this.researchId, this.researchStack, this.dataStack, this.ignoreNBT, duration, this.eut, this.cwut);
        }
    }

    public static class ScannerRecipeBuilder
    extends ResearchRecipeBuilder<ScannerRecipeBuilder> {
        public static final int DEFAULT_SCANNER_DURATION = 1200;
        public static final int DEFAULT_SCANNER_EUT = GTValues.VA[3];
        private int duration;

        ScannerRecipeBuilder() {
        }

        public ScannerRecipeBuilder duration(int duration) {
            this.duration = duration;
            return this;
        }

        @Override
        protected ItemStack getDefaultDataItem() {
            return AssemblyLineManager.getDefaultScannerItem();
        }

        @Override
        protected AssemblyLineRecipeBuilder.ResearchRecipeEntry build() {
            this.validateResearchItem();
            if (this.duration <= 0) {
                this.duration = 1200;
            }
            if (this.eut <= 0L) {
                this.eut = DEFAULT_SCANNER_EUT;
            }
            return new AssemblyLineRecipeBuilder.ResearchRecipeEntry(this.researchId, this.researchStack, this.dataStack, this.ignoreNBT, this.duration, this.eut, 0);
        }
    }
}

