/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.builders;

import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.ingredients.GTRecipeItemInput;
import gregtech.api.recipes.properties.impl.ImplosionExplosiveProperty;
import gregtech.api.util.EnumValidationResult;
import gregtech.api.util.GTLog;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import stanhebben.zenscript.annotations.ZenMethod;

public class ImplosionRecipeBuilder
extends RecipeBuilder<ImplosionRecipeBuilder> {
    public ImplosionRecipeBuilder() {
    }

    public ImplosionRecipeBuilder(Recipe recipe, RecipeMap<ImplosionRecipeBuilder> recipeMap) {
        super(recipe, recipeMap);
    }

    public ImplosionRecipeBuilder(RecipeBuilder<ImplosionRecipeBuilder> recipeBuilder) {
        super(recipeBuilder);
    }

    @Override
    public ImplosionRecipeBuilder copy() {
        return new ImplosionRecipeBuilder(this);
    }

    @Override
    public boolean applyPropertyCT(@NotNull String key, @NotNull Object value) {
        if (key.equals("explosives")) {
            if (value instanceof ItemStack) {
                ItemStack stack = (ItemStack)value;
                return this.applyProperty(ImplosionExplosiveProperty.getInstance(), stack);
            }
            if (value instanceof Number) {
                Number number = (Number)value;
                return this.applyProperty(ImplosionExplosiveProperty.getInstance(), number.intValue());
            }
            return false;
        }
        return super.applyPropertyCT(key, value);
    }

    @ZenMethod
    public ImplosionRecipeBuilder explosives(int amount) {
        return this.explosives(new ItemStack(Blocks.field_150335_W, amount));
    }

    @ZenMethod
    public ImplosionRecipeBuilder explosives(@NotNull ItemStack explosive) {
        if (explosive.func_190926_b()) {
            GTLog.logger.error("Cannot use empty explosives", new Throwable());
            this.recipeStatus = EnumValidationResult.INVALID;
            return this;
        }
        int count = explosive.func_190916_E();
        if (count < 1 || count > 64) {
            GTLog.logger.error("Amount of explosives should be from 1 to 64 inclusive", new Throwable());
            this.recipeStatus = EnumValidationResult.INVALID;
            return this;
        }
        if (this.applyProperty(ImplosionExplosiveProperty.getInstance(), explosive)) {
            this.inputs.add(new GTRecipeItemInput(explosive));
        }
        return this;
    }

    @NotNull
    public ItemStack getExplosives() {
        return this.recipePropertyStorage.get(ImplosionExplosiveProperty.getInstance(), ItemStack.field_190927_a);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append(ImplosionExplosiveProperty.getInstance().getKey(), (Object)this.getExplosives()).toString();
    }
}

