/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.builders;

import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.properties.impl.ComputationProperty;
import gregtech.api.recipes.properties.impl.TotalComputationProperty;
import gregtech.api.util.EnumValidationResult;
import gregtech.api.util.GTLog;
import org.jetbrains.annotations.NotNull;

public class ComputationRecipeBuilder
extends RecipeBuilder<ComputationRecipeBuilder> {
    public ComputationRecipeBuilder() {
    }

    public ComputationRecipeBuilder(Recipe recipe, RecipeMap<ComputationRecipeBuilder> recipeMap) {
        super(recipe, recipeMap);
    }

    public ComputationRecipeBuilder(RecipeBuilder<ComputationRecipeBuilder> recipeBuilder) {
        super(recipeBuilder);
    }

    @Override
    public ComputationRecipeBuilder copy() {
        return new ComputationRecipeBuilder(this);
    }

    @Override
    public boolean applyPropertyCT(@NotNull String key, @NotNull Object value) {
        if (key.equals("computation_per_tick")) {
            this.CWUt(((Number)value).intValue());
            return true;
        }
        if (key.equals("total_computation")) {
            this.totalCWU(((Number)value).intValue());
            return true;
        }
        return super.applyPropertyCT(key, value);
    }

    public ComputationRecipeBuilder CWUt(int cwut) {
        if (cwut < 0) {
            GTLog.logger.error("CWU/t cannot be less than 0", new Throwable());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        this.applyProperty(ComputationProperty.getInstance(), cwut);
        return this;
    }

    public ComputationRecipeBuilder totalCWU(int totalCWU) {
        if (totalCWU < 0) {
            GTLog.logger.error("Total CWU cannot be less than 0", new Throwable());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        this.applyProperty(TotalComputationProperty.getInstance(), totalCWU);
        return (ComputationRecipeBuilder)this.duration(totalCWU);
    }
}

