/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.builders;

import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.builders.ResearchRecipeBuilder;
import gregtech.api.recipes.properties.impl.ResearchProperty;
import gregtech.api.recipes.properties.impl.ResearchPropertyData;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.AssemblyLineManager;
import gregtech.api.util.EnumValidationResult;
import gregtech.api.util.GTLog;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.UnaryOperator;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class AssemblyLineRecipeBuilder
extends RecipeBuilder<AssemblyLineRecipeBuilder> {
    private final Collection<ResearchRecipeEntry> recipeEntries = new ArrayList<ResearchRecipeEntry>();
    private boolean generatingRecipes = true;

    public AssemblyLineRecipeBuilder() {
    }

    public AssemblyLineRecipeBuilder(Recipe recipe, RecipeMap<AssemblyLineRecipeBuilder> recipeMap) {
        super(recipe, recipeMap);
    }

    public AssemblyLineRecipeBuilder(@NotNull AssemblyLineRecipeBuilder builder) {
        super(builder);
        this.recipeEntries.addAll(builder.getRecipeEntries());
        this.generatingRecipes = builder.generatingRecipes;
    }

    @Override
    public AssemblyLineRecipeBuilder copy() {
        return new AssemblyLineRecipeBuilder(this);
    }

    @Override
    public boolean applyPropertyCT(@NotNull String key, @NotNull Object value) {
        if (key.equals("research")) {
            if (value instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)value;
                this.scannerResearch(itemStack);
                return true;
            }
            return false;
        }
        return super.applyPropertyCT(key, value);
    }

    private boolean applyResearchProperty(ResearchPropertyData.ResearchEntry researchEntry) {
        if (!ConfigHolder.machines.enableResearch) {
            return false;
        }
        if (researchEntry == null) {
            GTLog.logger.error("Assembly Line Research Entry cannot be empty.", new Throwable());
            this.recipeStatus = EnumValidationResult.INVALID;
            return false;
        }
        if (!this.generatingRecipes) {
            GTLog.logger.error("Cannot generate recipes when using researchWithoutRecipe()", new Throwable());
            this.recipeStatus = EnumValidationResult.INVALID;
            return false;
        }
        ResearchPropertyData property = this.recipePropertyStorage.get(ResearchProperty.getInstance(), null);
        if (property != null) {
            property.add(researchEntry);
            return true;
        }
        property = new ResearchPropertyData();
        if (this.applyProperty(ResearchProperty.getInstance(), property)) {
            property.add(researchEntry);
            return true;
        }
        return false;
    }

    public AssemblyLineRecipeBuilder researchWithoutRecipe(@NotNull String researchId) {
        return this.researchWithoutRecipe(researchId, AssemblyLineManager.getDefaultScannerItem());
    }

    public AssemblyLineRecipeBuilder researchWithoutRecipe(@NotNull String researchId, @NotNull ItemStack dataStack) {
        this.applyResearchProperty(new ResearchPropertyData.ResearchEntry(researchId, dataStack));
        this.generatingRecipes = false;
        return this;
    }

    public AssemblyLineRecipeBuilder scannerResearch(UnaryOperator<ResearchRecipeBuilder.ScannerRecipeBuilder> research) {
        ResearchRecipeEntry entry = ((ResearchRecipeBuilder.ScannerRecipeBuilder)research.apply(new ResearchRecipeBuilder.ScannerRecipeBuilder())).build();
        if (this.applyResearchProperty(new ResearchPropertyData.ResearchEntry(entry.researchId, entry.dataStack))) {
            this.recipeEntries.add(entry);
        }
        return this;
    }

    public AssemblyLineRecipeBuilder scannerResearch(@NotNull ItemStack researchStack) {
        return this.scannerResearch(b -> (ResearchRecipeBuilder.ScannerRecipeBuilder)b.researchStack(researchStack));
    }

    public AssemblyLineRecipeBuilder scannerResearch(@NotNull MetaItem.MetaValueItem metaItem) {
        return this.scannerResearch(b -> (ResearchRecipeBuilder.ScannerRecipeBuilder)b.researchStack(metaItem));
    }

    public AssemblyLineRecipeBuilder scannerResearch(@NotNull MetaItem.MetaValueItem metaItem, int amount) {
        return this.scannerResearch(b -> (ResearchRecipeBuilder.ScannerRecipeBuilder)b.researchStack(metaItem, amount));
    }

    public AssemblyLineRecipeBuilder scannerResearch(@NotNull MetaItem.MetaValueItem metaItem, int amount, boolean ignoreNBT) {
        return this.scannerResearch(b -> (ResearchRecipeBuilder.ScannerRecipeBuilder)b.researchStack(metaItem, amount, ignoreNBT));
    }

    public AssemblyLineRecipeBuilder scannerResearch(@NotNull MetaTileEntity mte) {
        return this.scannerResearch(b -> (ResearchRecipeBuilder.ScannerRecipeBuilder)b.researchStack(mte));
    }

    public AssemblyLineRecipeBuilder scannerResearch(@NotNull MetaTileEntity mte, int amount) {
        return this.scannerResearch(b -> (ResearchRecipeBuilder.ScannerRecipeBuilder)b.researchStack(mte, amount));
    }

    public AssemblyLineRecipeBuilder scannerResearch(@NotNull MetaTileEntity mte, int amount, boolean ignoreNBT) {
        return this.scannerResearch(b -> (ResearchRecipeBuilder.ScannerRecipeBuilder)b.researchStack(mte, amount, ignoreNBT));
    }

    public AssemblyLineRecipeBuilder scannerResearch(@NotNull OrePrefix prefix, @NotNull Material material) {
        return this.scannerResearch(b -> (ResearchRecipeBuilder.ScannerRecipeBuilder)b.researchStack(prefix, material));
    }

    public AssemblyLineRecipeBuilder scannerResearch(@NotNull OrePrefix prefix, @NotNull Material material, int amount) {
        return this.scannerResearch(b -> (ResearchRecipeBuilder.ScannerRecipeBuilder)b.researchStack(prefix, material, amount));
    }

    public AssemblyLineRecipeBuilder scannerResearch(@NotNull OrePrefix prefix, @NotNull Material material, int amount, boolean ignoreNBT) {
        return this.scannerResearch(b -> (ResearchRecipeBuilder.ScannerRecipeBuilder)b.researchStack(prefix, material, amount, ignoreNBT));
    }

    public AssemblyLineRecipeBuilder scannerResearch(@NotNull Block block) {
        return this.scannerResearch(b -> (ResearchRecipeBuilder.ScannerRecipeBuilder)b.researchStack(block));
    }

    public AssemblyLineRecipeBuilder scannerResearch(@NotNull Block block, int amount) {
        return this.scannerResearch(b -> (ResearchRecipeBuilder.ScannerRecipeBuilder)b.researchStack(block, amount));
    }

    public AssemblyLineRecipeBuilder scannerResearch(@NotNull Block block, int amount, int meta) {
        return this.scannerResearch(b -> (ResearchRecipeBuilder.ScannerRecipeBuilder)b.researchStack(block, amount, meta));
    }

    public AssemblyLineRecipeBuilder scannerResearch(@NotNull Block block, int amount, boolean ignoreNBT) {
        return this.scannerResearch(b -> (ResearchRecipeBuilder.ScannerRecipeBuilder)b.researchStack(block, amount, ignoreNBT));
    }

    public AssemblyLineRecipeBuilder scannerResearch(@NotNull Block block, int amount, int meta, boolean ignoreNBT) {
        return this.scannerResearch(b -> (ResearchRecipeBuilder.ScannerRecipeBuilder)b.researchStack(block, amount, meta, ignoreNBT));
    }

    public AssemblyLineRecipeBuilder stationResearch(UnaryOperator<ResearchRecipeBuilder.StationRecipeBuilder> research) {
        ResearchRecipeEntry entry = ((ResearchRecipeBuilder.StationRecipeBuilder)research.apply(new ResearchRecipeBuilder.StationRecipeBuilder())).build();
        if (this.applyResearchProperty(new ResearchPropertyData.ResearchEntry(entry.researchId, entry.dataStack))) {
            this.recipeEntries.add(entry);
        }
        return this;
    }

    @NotNull
    public Collection<ResearchRecipeEntry> getRecipeEntries() {
        return this.recipeEntries;
    }

    public static class ResearchRecipeEntry {
        private final String researchId;
        private final ItemStack researchStack;
        private final ItemStack dataStack;
        private final boolean ignoreNBT;
        private final int duration;
        private final long EUt;
        private final int CWUt;

        public ResearchRecipeEntry(@NotNull String researchId, @NotNull ItemStack researchStack, @NotNull ItemStack dataStack, int duration, long EUt, int CWUt) {
            this.researchId = researchId;
            this.researchStack = researchStack;
            this.dataStack = dataStack;
            this.duration = duration;
            this.EUt = EUt;
            this.CWUt = CWUt;
            this.ignoreNBT = true;
        }

        public ResearchRecipeEntry(@NotNull String researchId, @NotNull ItemStack researchStack, @NotNull ItemStack dataStack, boolean ignoreNBT, int duration, long EUt, int CWUt) {
            this.researchId = researchId;
            this.researchStack = researchStack;
            this.dataStack = dataStack;
            this.ignoreNBT = ignoreNBT;
            this.duration = duration;
            this.EUt = EUt;
            this.CWUt = CWUt;
        }

        @NotNull
        public String getResearchId() {
            return this.researchId;
        }

        @NotNull
        public ItemStack getResearchStack() {
            return this.researchStack;
        }

        @NotNull
        public ItemStack getDataStack() {
            return this.dataStack;
        }

        public boolean getIgnoreNBT() {
            return this.ignoreNBT;
        }

        public int getDuration() {
            return this.duration;
        }

        public long getEUt() {
            return this.EUt;
        }

        public int getCWUt() {
            return this.CWUt;
        }
    }
}

