/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes;

import gregtech.api.GregTechAPI;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.MarkerMaterial;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.unification.stack.RecyclingData;
import gregtech.api.unification.stack.UnificationEntry;
import it.unimi.dsi.fastutil.chars.Char2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecyclingHandler {
    @Nullable
    public static RecyclingData getRecyclingIngredients(int outputCount, Object ... recipe) {
        Object object;
        Char2IntOpenHashMap inputCountMap = new Char2IntOpenHashMap();
        Object2LongOpenHashMap materialStacksExploded = new Object2LongOpenHashMap();
        int itr = 0;
        while ((object = recipe[itr]) instanceof String) {
            String s = (String)object;
            object = s.toCharArray();
            int n = ((Object)object).length;
            for (int i = 0; i < n; ++i) {
                Object c = object[i];
                if (ToolHelper.getToolFromSymbol(Character.valueOf((char)c)) != null) continue;
                int count = (Integer)inputCountMap.getOrDefault((Object)Character.valueOf((char)c), (Object)0);
                inputCountMap.put((char)c, count + 1);
            }
            ++itr;
        }
        char lastChar = ' ';
        for (int i = itr; i < recipe.length; ++i) {
            ItemStack stack;
            Object ingredient = recipe[i];
            if (ingredient instanceof Character) {
                lastChar = ((Character)ingredient).charValue();
                continue;
            }
            if (lastChar == ' ') {
                return null;
            }
            if (ingredient instanceof MetaItem.MetaValueItem) {
                stack = ((MetaItem.MetaValueItem)ingredient).getStackForm();
            } else if (ingredient instanceof UnificationEntry) {
                stack = OreDictUnifier.get((UnificationEntry)ingredient);
            } else if (ingredient instanceof ItemStack) {
                stack = (ItemStack)ingredient;
            } else if (ingredient instanceof Item) {
                stack = new ItemStack((Item)ingredient, 1);
            } else if (ingredient instanceof Block) {
                stack = new ItemStack((Block)ingredient, 1);
            } else {
                if (!(ingredient instanceof String)) continue;
                stack = OreDictUnifier.get((String)ingredient);
            }
            RecyclingHandler.addItemStackToMaterialStacks(stack, (Object2LongMap<Material>)materialStacksExploded, inputCountMap.get(lastChar));
        }
        return new RecyclingData(materialStacksExploded.entrySet().stream().map(e -> new MaterialStack((Material)e.getKey(), (Long)e.getValue() / (long)outputCount)).sorted(Comparator.comparingLong(m -> -m.amount)).collect(Collectors.toList()));
    }

    @Nullable
    public static RecyclingData getRecyclingIngredients(List<GTRecipeInput> inputs, int outputCount) {
        Object2LongOpenHashMap materialStacksExploded = new Object2LongOpenHashMap();
        for (GTRecipeInput input : inputs) {
            ItemStack[] inputStacks;
            if (input == null || input.isNonConsumable() || (inputStacks = input.getInputStacks()) == null || inputStacks.length == 0) continue;
            ItemStack inputStack = inputStacks[0];
            RecyclingHandler.addItemStackToMaterialStacks(inputStack, (Object2LongMap<Material>)materialStacksExploded, inputStack.func_190916_E());
        }
        return new RecyclingData(materialStacksExploded.entrySet().stream().map(e -> new MaterialStack((Material)e.getKey(), (Long)e.getValue() / (long)outputCount)).sorted(Comparator.comparingLong(m -> -m.amount)).collect(Collectors.toList()));
    }

    private static void addItemStackToMaterialStacks(@NotNull ItemStack itemStack, @NotNull Object2LongMap<Material> materialStacksExploded, int inputCount) {
        OrePrefix prefix;
        RecyclingData data = GregTechAPI.RECYCLING_MANAGER.getRecyclingData(itemStack);
        if (data != null) {
            for (MaterialStack ms : data.getMaterials()) {
                if (ms.material instanceof MarkerMaterial) continue;
                RecyclingHandler.addMaterialStack(materialStacksExploded, inputCount, ms);
            }
            return;
        }
        MaterialStack materialStack = OreDictUnifier.getMaterial(itemStack);
        if (materialStack != null && !(materialStack.material instanceof MarkerMaterial)) {
            RecyclingHandler.addMaterialStack(materialStacksExploded, inputCount, materialStack);
        }
        if ((prefix = OreDictUnifier.getPrefix(itemStack)) != null && !prefix.secondaryMaterials.isEmpty()) {
            for (MaterialStack ms : prefix.secondaryMaterials) {
                RecyclingHandler.addMaterialStack(materialStacksExploded, inputCount, ms);
            }
        }
    }

    private static void addMaterialStack(@NotNull Object2LongMap<Material> materialStacksExploded, int inputCount, @NotNull MaterialStack ms) {
        long amount = (Long)materialStacksExploded.getOrDefault((Object)ms.material, (Object)0L);
        materialStacksExploded.put((Object)ms.material, ms.amount * (long)inputCount + amount);
    }
}

