/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes;

import crafttweaker.annotations.ZenRegister;
import gregtech.api.GTValues;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMapBuilder;
import gregtech.api.recipes.builders.AssemblyLineRecipeBuilder;
import gregtech.api.recipes.builders.BlastRecipeBuilder;
import gregtech.api.recipes.builders.CircuitAssemblerRecipeBuilder;
import gregtech.api.recipes.builders.ComputationRecipeBuilder;
import gregtech.api.recipes.builders.FuelRecipeBuilder;
import gregtech.api.recipes.builders.FusionRecipeBuilder;
import gregtech.api.recipes.builders.ImplosionRecipeBuilder;
import gregtech.api.recipes.builders.PrimitiveRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.recipes.builders.UniversalDistillationRecipeBuilder;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.machines.RecipeMapAssemblyLine;
import gregtech.api.recipes.machines.RecipeMapFluidCanner;
import gregtech.api.recipes.machines.RecipeMapFormingPress;
import gregtech.api.recipes.machines.RecipeMapFurnace;
import gregtech.api.recipes.machines.RecipeMapResearchStation;
import gregtech.api.recipes.machines.RecipeMapScanner;
import gregtech.api.recipes.ui.RecipeMapUI;
import gregtech.api.recipes.ui.impl.AssemblyLineUI;
import gregtech.api.recipes.ui.impl.CokeOvenUI;
import gregtech.api.recipes.ui.impl.CrackerUnitUI;
import gregtech.api.recipes.ui.impl.DistillationTowerUI;
import gregtech.api.recipes.ui.impl.FormingPressUI;
import gregtech.api.recipes.ui.impl.ResearchStationUI;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.AssemblyLineManager;
import gregtech.api.util.GTUtility;
import gregtech.core.sound.GTSoundEvents;
import java.util.List;
import net.minecraft.init.SoundEvents;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenProperty;

@ZenClass(value="mods.gregtech.recipe.RecipeMaps")
@ZenRegister
public final class RecipeMaps {
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> ALLOY_SMELTER_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("alloy_smelter", new SimpleRecipeBuilder()).itemInputs(2).itemOutputs(1).itemSlotOverlay(GuiTextures.FURNACE_OVERLAY_1, false).progressBar(GuiTextures.PROGRESS_BAR_ARROW).sound(GTSoundEvents.FURNACE).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> ARC_FURNACE_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("arc_furnace", new SimpleRecipeBuilder()).itemInputs(1).itemOutputs(9).fluidInputs(1).fluidOutputs(1).progressBar(GuiTextures.PROGRESS_BAR_ARC_FURNACE).sound(GTSoundEvents.ARC).onBuild(GTUtility.gregtechId("arc_furnace_oxygen"), recipeBuilder -> {
        if (recipeBuilder.getFluidInputs().isEmpty()) {
            recipeBuilder.fluidInputs(Materials.Oxygen.getFluid(recipeBuilder.getDuration()));
        }
    }).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> ASSEMBLER_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("assembler", new SimpleRecipeBuilder()).itemInputs(9).itemOutputs(1).fluidInputs(1).itemSlotOverlay(GuiTextures.CIRCUIT_OVERLAY, false).progressBar(GuiTextures.PROGRESS_BAR_CIRCUIT).sound(GTSoundEvents.ASSEMBLER).onBuild(GTUtility.gregtechId("assembler_solder"), recipeBuilder -> {
        List<GTRecipeInput> fluidInputs = recipeBuilder.getFluidInputs();
        if (fluidInputs.size() == 1 && fluidInputs.get(0).getInputFluidStack().getFluid() == Materials.SolderingAlloy.getFluid()) {
            int amount = fluidInputs.get((int)0).getInputFluidStack().amount;
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)recipeBuilder.copy().clearFluidInputs()).fluidInputs(Materials.Tin.getFluid(amount * 2))).buildAndRegister();
        }
    }).build();
    @ZenProperty
    public static final RecipeMap<AssemblyLineRecipeBuilder> ASSEMBLY_LINE_RECIPES = new RecipeMapAssemblyLine<AssemblyLineRecipeBuilder>("assembly_line", new AssemblyLineRecipeBuilder(), AssemblyLineUI::new).onRecipeBuild(GTUtility.gregtechId("default_research_recipe"), AssemblyLineManager::createDefaultResearchRecipe);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> AUTOCLAVE_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("autoclave", new SimpleRecipeBuilder()).itemInputs(2).itemOutputs(2).fluidInputs(1).fluidOutputs(1).itemSlotOverlay(GuiTextures.DUST_OVERLAY, false).itemSlotOverlay(GuiTextures.CRYSTAL_OVERLAY, true).progressBar(GuiTextures.PROGRESS_BAR_CRYSTALLIZATION).sound(GTSoundEvents.FURNACE).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> BENDER_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("bender", new SimpleRecipeBuilder()).itemInputs(2).itemOutputs(1).itemSlotOverlay(GuiTextures.BENDER_OVERLAY, false, false).itemSlotOverlay(GuiTextures.INT_CIRCUIT_OVERLAY, false, true).progressBar(GuiTextures.PROGRESS_BAR_BENDING).sound(GTSoundEvents.MOTOR).build();
    @ZenProperty
    public static final RecipeMap<BlastRecipeBuilder> BLAST_RECIPES = new RecipeMapBuilder<BlastRecipeBuilder>("electric_blast_furnace", new BlastRecipeBuilder()).itemInputs(3).itemOutputs(3).fluidInputs(1).fluidOutputs(1).sound(GTSoundEvents.FURNACE).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> BREWING_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("brewery", (SimpleRecipeBuilder)((SimpleRecipeBuilder)new SimpleRecipeBuilder().duration(128)).EUt(4L)).itemInputs(1).fluidInputs(1).fluidOutputs(1).itemSlotOverlay(GuiTextures.BREWER_OVERLAY, false).progressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE).sound(GTSoundEvents.CHEMICAL_REACTOR).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> CANNER_RECIPES = new RecipeMapFluidCanner("canner", new SimpleRecipeBuilder(), recipeMap -> {
        RecipeMapUI<RecipeMap> ui = new RecipeMapUI<RecipeMap>(recipeMap, true, true, true, true, false);
        ui.setItemSlotOverlay(GuiTextures.CANNER_OVERLAY, false, false);
        ui.setItemSlotOverlay(GuiTextures.CANISTER_OVERLAY, false, true);
        ui.setItemSlotOverlay(GuiTextures.CANISTER_OVERLAY, true);
        ui.setFluidSlotOverlay(GuiTextures.DARK_CANISTER_OVERLAY, false);
        ui.setFluidSlotOverlay(GuiTextures.DARK_CANISTER_OVERLAY, true);
        ui.setProgressBar(GuiTextures.PROGRESS_BAR_CANNER, ProgressWidget.MoveType.HORIZONTAL);
        return ui;
    });
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> CENTRIFUGE_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("centrifuge", (SimpleRecipeBuilder)new SimpleRecipeBuilder().EUt(5L)).itemInputs(2).itemOutputs(6).fluidInputs(1).fluidOutputs(6).itemSlotOverlay(GuiTextures.EXTRACTOR_OVERLAY, false, false).itemSlotOverlay(GuiTextures.CANISTER_OVERLAY, false, true).fluidSlotOverlay(GuiTextures.CENTRIFUGE_OVERLAY, false, true).progressBar(GuiTextures.PROGRESS_BAR_EXTRACT).sound(GTSoundEvents.CENTRIFUGE).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> CHEMICAL_BATH_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("chemical_bath", new SimpleRecipeBuilder()).itemInputs(1).itemOutputs(6).fluidInputs(1).fluidOutputs(1).itemSlotOverlay(GuiTextures.BREWER_OVERLAY, false, true).itemSlotOverlay(GuiTextures.DUST_OVERLAY, true).progressBar(GuiTextures.PROGRESS_BAR_MIXER, ProgressWidget.MoveType.CIRCULAR).sound(GTSoundEvents.BATH).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> CHEMICAL_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("chemical_reactor", (SimpleRecipeBuilder)new SimpleRecipeBuilder().EUt(GTValues.VA[1])).itemInputs(2).itemOutputs(2).fluidInputs(3).fluidOutputs(2).itemSlotOverlay(GuiTextures.MOLECULAR_OVERLAY_1, false, false).itemSlotOverlay(GuiTextures.MOLECULAR_OVERLAY_2, false, true).itemSlotOverlay(GuiTextures.VIAL_OVERLAY_1, true).fluidSlotOverlay(GuiTextures.MOLECULAR_OVERLAY_3, false, false).fluidSlotOverlay(GuiTextures.MOLECULAR_OVERLAY_4, false, true).fluidSlotOverlay(GuiTextures.VIAL_OVERLAY_2, true).progressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE).sound(GTValues.FOOLS.get() != false ? GTSoundEvents.SCIENCE : GTSoundEvents.CHEMICAL_REACTOR).onBuild(GTUtility.gregtechId("lcr_copy"), recipeBuilder -> ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)LARGE_CHEMICAL_RECIPES.recipeBuilder().inputs(recipeBuilder.getInputs().toArray(new GTRecipeInput[0]))).fluidInputs(recipeBuilder.getFluidInputs())).outputs(recipeBuilder.getOutputs())).chancedOutputs(recipeBuilder.getChancedOutputs())).fluidOutputs(recipeBuilder.getFluidOutputs())).chancedFluidOutputs(recipeBuilder.getChancedFluidOutputs())).cleanroom(recipeBuilder.getCleanroom())).duration(recipeBuilder.getDuration())).EUt(recipeBuilder.getEUt())).buildAndRegister()).build();
    @ZenProperty
    public static final RecipeMap<CircuitAssemblerRecipeBuilder> CIRCUIT_ASSEMBLER_RECIPES = new RecipeMapBuilder<CircuitAssemblerRecipeBuilder>("circuit_assembler", new CircuitAssemblerRecipeBuilder()).itemInputs(6).itemOutputs(1).fluidInputs(1).itemSlotOverlay(GuiTextures.CIRCUIT_OVERLAY, false).progressBar(GuiTextures.PROGRESS_BAR_CIRCUIT_ASSEMBLER).sound(GTSoundEvents.ASSEMBLER).onBuild(GTUtility.gregtechId("circuit_assembler_solder"), recipeBuilder -> {
        if (recipeBuilder.getFluidInputs().isEmpty()) {
            ((CircuitAssemblerRecipeBuilder)recipeBuilder.copy().fluidInputs(Materials.SolderingAlloy.getFluid(Math.max(1, 72 * recipeBuilder.getSolderMultiplier())))).buildAndRegister();
            recipeBuilder.fluidInputs(Materials.Tin.getFluid(Math.max(1, 144 * recipeBuilder.getSolderMultiplier())));
        }
    }).build();
    @ZenProperty
    public static final RecipeMap<PrimitiveRecipeBuilder> COKE_OVEN_RECIPES = new RecipeMapBuilder<PrimitiveRecipeBuilder>("coke_oven", new PrimitiveRecipeBuilder()).itemInputs(1).itemOutputs(1).fluidOutputs(1).ui(CokeOvenUI::new).sound(GTSoundEvents.FIRE).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> COMPRESSOR_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("compressor", (SimpleRecipeBuilder)((SimpleRecipeBuilder)new SimpleRecipeBuilder().duration(200)).EUt(2L)).itemInputs(1).itemOutputs(1).itemSlotOverlay(GuiTextures.COMPRESSOR_OVERLAY, false).progressBar(GuiTextures.PROGRESS_BAR_COMPRESS).sound(GTSoundEvents.COMPRESSOR).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> CRACKING_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("cracker", new SimpleRecipeBuilder()).itemInputs(1).fluidInputs(2).fluidOutputs(2).ui(CrackerUnitUI::new).sound(GTSoundEvents.FIRE).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> CUTTER_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("cutter", new SimpleRecipeBuilder()).itemInputs(1).itemOutputs(2).fluidInputs(1).itemSlotOverlay(GuiTextures.SAWBLADE_OVERLAY, false).itemSlotOverlay(GuiTextures.CUTTER_OVERLAY, true, false).itemSlotOverlay(GuiTextures.DUST_OVERLAY, true, true).progressBar(GuiTextures.PROGRESS_BAR_SLICE).sound(GTSoundEvents.CUT).onBuild(GTUtility.gregtechId("cutter_fluid"), recipeBuilder -> {
        if (recipeBuilder.getFluidInputs().isEmpty()) {
            int duration = recipeBuilder.getDuration();
            long eut = recipeBuilder.getEUt();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)recipeBuilder.copy().fluidInputs(Materials.Water.getFluid(GTUtility.safeCastLongToInt(Math.max(4L, Math.min(1000L, (long)duration * eut / 320L)))))).duration(duration * 2)).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)recipeBuilder.copy().fluidInputs(Materials.DistilledWater.getFluid(GTUtility.safeCastLongToInt(Math.max(3L, Math.min(750L, (long)duration * eut / 426L)))))).duration((int)((double)duration * 1.5))).buildAndRegister();
            ((SimpleRecipeBuilder)recipeBuilder.fluidInputs(Materials.Lubricant.getFluid(GTUtility.safeCastLongToInt(Math.max(1L, Math.min(250L, (long)duration * eut / 1280L)))))).duration(Math.max(1, duration));
        }
    }).build();
    @ZenProperty
    public static final RecipeMap<UniversalDistillationRecipeBuilder> DISTILLATION_RECIPES = new RecipeMapBuilder<UniversalDistillationRecipeBuilder>("distillation_tower", new UniversalDistillationRecipeBuilder()).itemOutputs(1).fluidInputs(1).fluidOutputs(12).ui(DistillationTowerUI::new).sound(GTSoundEvents.CHEMICAL_REACTOR).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> DISTILLERY_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("distillery", new SimpleRecipeBuilder()).itemInputs(1).itemOutputs(1).fluidInputs(1).fluidOutputs(1).itemSlotOverlay(GuiTextures.INT_CIRCUIT_OVERLAY, false, true).itemSlotOverlay(GuiTextures.DUST_OVERLAY, true).fluidSlotOverlay(GuiTextures.BEAKER_OVERLAY_1, false).fluidSlotOverlay(GuiTextures.BEAKER_OVERLAY_4, true).progressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE).sound(GTSoundEvents.BOILER).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> ELECTROLYZER_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("electrolyzer", new SimpleRecipeBuilder()).itemInputs(2).itemOutputs(6).fluidInputs(1).fluidOutputs(6).itemSlotOverlay(GuiTextures.LIGHTNING_OVERLAY_1, false, false).itemSlotOverlay(GuiTextures.CANISTER_OVERLAY, false, true).fluidSlotOverlay(GuiTextures.LIGHTNING_OVERLAY_2, false).progressBar(GuiTextures.PROGRESS_BAR_EXTRACT).sound(GTSoundEvents.ELECTROLYZER).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> ELECTROMAGNETIC_SEPARATOR_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("electromagnetic_separator", new SimpleRecipeBuilder()).itemInputs(1).itemOutputs(4).itemSlotOverlay(GuiTextures.CRUSHED_ORE_OVERLAY, false).itemSlotOverlay(GuiTextures.DUST_OVERLAY, true).progressBar(GuiTextures.PROGRESS_BAR_MAGNET).sound(GTSoundEvents.ARC).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> EXTRACTOR_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("extractor", (SimpleRecipeBuilder)((SimpleRecipeBuilder)new SimpleRecipeBuilder().duration(400)).EUt(2L)).itemInputs(1).itemOutputs(1).fluidOutputs(1).itemSlotOverlay(GuiTextures.EXTRACTOR_OVERLAY, false).progressBar(GuiTextures.PROGRESS_BAR_EXTRACT).sound(GTSoundEvents.COMPRESSOR).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> EXTRUDER_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("extruder", new SimpleRecipeBuilder()).itemInputs(2).itemOutputs(1).itemSlotOverlay(GuiTextures.MOLD_OVERLAY, false, true).progressBar(GuiTextures.PROGRESS_BAR_EXTRUDER).sound(GTSoundEvents.ARC).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> FERMENTING_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("fermenter", (SimpleRecipeBuilder)new SimpleRecipeBuilder().EUt(2L)).itemInputs(1).itemOutputs(1).fluidInputs(1).fluidOutputs(1).itemSlotOverlay(GuiTextures.DUST_OVERLAY, false, true).itemSlotOverlay(GuiTextures.DUST_OVERLAY, true, true).sound(GTSoundEvents.CHEMICAL_REACTOR).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> FLUID_HEATER_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("fluid_heater", new SimpleRecipeBuilder()).itemInputs(1).fluidInputs(1).fluidOutputs(1).itemSlotOverlay(GuiTextures.INT_CIRCUIT_OVERLAY, false, true).fluidSlotOverlay(GuiTextures.HEATING_OVERLAY_1, false).fluidSlotOverlay(GuiTextures.HEATING_OVERLAY_2, true).sound(GTSoundEvents.BOILER).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> FLUID_SOLIDFICATION_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("fluid_solidifier", new SimpleRecipeBuilder()).itemInputs(1).itemOutputs(1).fluidInputs(1).itemSlotOverlay(GuiTextures.SOLIDIFIER_OVERLAY, false).sound(GTSoundEvents.COOLING).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> FORGE_HAMMER_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("forge_hammer", new SimpleRecipeBuilder()).itemInputs(1).itemOutputs(1).itemSlotOverlay(GuiTextures.HAMMER_OVERLAY, false).specialTexture(GuiTextures.PROGRESS_BAR_HAMMER_BASE, 78, 42, 20, 6).progressBar(GuiTextures.PROGRESS_BAR_HAMMER, ProgressWidget.MoveType.VERTICAL_DOWNWARDS).sound(GTSoundEvents.FORGE_HAMMER).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> FORMING_PRESS_RECIPES = new RecipeMapFormingPress("forming_press", new SimpleRecipeBuilder(), FormingPressUI::new);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> FURNACE_RECIPES = new RecipeMapFurnace("electric_furnace", new SimpleRecipeBuilder(), recipeMap -> {
        RecipeMapUI<RecipeMap> ui = new RecipeMapUI<RecipeMap>(recipeMap, true, true, true, true, false);
        ui.setItemSlotOverlay(GuiTextures.FURNACE_OVERLAY_1, false);
        ui.setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressWidget.MoveType.HORIZONTAL);
        return ui;
    });
    @ZenProperty
    public static final RecipeMap<FusionRecipeBuilder> FUSION_RECIPES = new RecipeMapBuilder<FusionRecipeBuilder>("fusion_reactor", new FusionRecipeBuilder()).fluidInputs(2).fluidOutputs(1).progressBar(GuiTextures.PROGRESS_BAR_FUSION).sound(GTSoundEvents.ARC).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> GAS_COLLECTOR_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("gas_collector", new SimpleRecipeBuilder()).itemInputs(1).fluidOutputs(1).itemSlotOverlay(GuiTextures.INT_CIRCUIT_OVERLAY, false, true).fluidSlotOverlay(GuiTextures.CENTRIFUGE_OVERLAY, true).progressBar(GuiTextures.PROGRESS_BAR_GAS_COLLECTOR).sound(GTSoundEvents.COOLING).build();
    @ZenProperty
    public static final RecipeMap<ImplosionRecipeBuilder> IMPLOSION_RECIPES = new RecipeMapBuilder<ImplosionRecipeBuilder>("implosion_compressor", (ImplosionRecipeBuilder)((ImplosionRecipeBuilder)new ImplosionRecipeBuilder().duration(20)).EUt(GTValues.VA[1])).itemInputs(3).itemOutputs(2).itemSlotOverlay(GuiTextures.IMPLOSION_OVERLAY_1, false, true).itemSlotOverlay(GuiTextures.IMPLOSION_OVERLAY_2, false, false).itemSlotOverlay(GuiTextures.DUST_OVERLAY, true, true).progressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE).sound(SoundEvents.field_187539_bB).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> LARGE_CHEMICAL_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("large_chemical_reactor", (SimpleRecipeBuilder)new SimpleRecipeBuilder().EUt(GTValues.VA[1])).itemInputs(3).itemOutputs(3).fluidInputs(5).fluidOutputs(4).itemSlotOverlay(GuiTextures.MOLECULAR_OVERLAY_1, false, false).itemSlotOverlay(GuiTextures.MOLECULAR_OVERLAY_2, false, true).itemSlotOverlay(GuiTextures.VIAL_OVERLAY_1, true).fluidSlotOverlay(GuiTextures.MOLECULAR_OVERLAY_3, false, false).fluidSlotOverlay(GuiTextures.MOLECULAR_OVERLAY_4, false, true).fluidSlotOverlay(GuiTextures.VIAL_OVERLAY_2, true).progressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE).sound(GTSoundEvents.CHEMICAL_REACTOR).build().setSmallRecipeMap(CHEMICAL_RECIPES);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> LASER_ENGRAVER_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("laser_engraver", new SimpleRecipeBuilder()).itemInputs(2).itemOutputs(1).itemSlotOverlay(GuiTextures.LENS_OVERLAY, false, true).sound(GTSoundEvents.ELECTROLYZER).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> LATHE_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("lathe", new SimpleRecipeBuilder()).itemInputs(1).itemOutputs(2).itemSlotOverlay(GuiTextures.PIPE_OVERLAY_1, false).itemSlotOverlay(GuiTextures.PIPE_OVERLAY_2, true, false).itemSlotOverlay(GuiTextures.DUST_OVERLAY, true, true).specialTexture(GuiTextures.PROGRESS_BAR_LATHE_BASE, 98, 24, 5, 18).progressBar(GuiTextures.PROGRESS_BAR_LATHE).sound(GTSoundEvents.CUT).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> MACERATOR_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("macerator", (SimpleRecipeBuilder)((SimpleRecipeBuilder)new SimpleRecipeBuilder().duration(150)).EUt(2L)).itemInputs(1).itemOutputs(4).itemSlotOverlay(GuiTextures.CRUSHED_ORE_OVERLAY, false).itemSlotOverlay(GuiTextures.DUST_OVERLAY, true).progressBar(GuiTextures.PROGRESS_BAR_MACERATE).sound(GTSoundEvents.MACERATOR).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> MASS_FABRICATOR_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("mass_fabricator", new SimpleRecipeBuilder()).itemInputs(1).fluidInputs(1).fluidOutputs(2).itemSlotOverlay(GuiTextures.ATOMIC_OVERLAY_1, false).fluidSlotOverlay(GuiTextures.ATOMIC_OVERLAY_2, false).fluidSlotOverlay(GuiTextures.POSITIVE_MATTER_OVERLAY, true).fluidSlotOverlay(GuiTextures.NEUTRAL_MATTER_OVERLAY, true, true).progressBar(GuiTextures.PROGRESS_BAR_MASS_FAB).sound(GTSoundEvents.REPLICATOR).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> MIXER_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("mixer", new SimpleRecipeBuilder()).itemInputs(6).itemOutputs(1).fluidInputs(2).fluidOutputs(1).itemSlotOverlay(GuiTextures.DUST_OVERLAY, false).itemSlotOverlay(GuiTextures.DUST_OVERLAY, true).progressBar(GuiTextures.PROGRESS_BAR_MIXER, ProgressWidget.MoveType.CIRCULAR).sound(GTSoundEvents.MIXER).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> ORE_WASHER_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("ore_washer", (SimpleRecipeBuilder)((SimpleRecipeBuilder)new SimpleRecipeBuilder().duration(400)).EUt(16L)).itemInputs(2).itemOutputs(3).fluidInputs(1).itemSlotOverlay(GuiTextures.CRUSHED_ORE_OVERLAY, false).itemSlotOverlay(GuiTextures.DUST_OVERLAY, true).progressBar(GuiTextures.PROGRESS_BAR_BATH, ProgressWidget.MoveType.CIRCULAR).sound(GTSoundEvents.BATH).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> PACKER_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("packer", (SimpleRecipeBuilder)((SimpleRecipeBuilder)new SimpleRecipeBuilder().EUt(12L)).duration(10)).itemInputs(2).itemOutputs(2).itemSlotOverlay(GuiTextures.BOX_OVERLAY, false, true).itemSlotOverlay(GuiTextures.BOXED_OVERLAY, true).progressBar(GuiTextures.PROGRESS_BAR_UNPACKER).sound(GTSoundEvents.ASSEMBLER).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> POLARIZER_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("polarizer", new SimpleRecipeBuilder()).itemInputs(1).itemOutputs(1).progressBar(GuiTextures.PROGRESS_BAR_MAGNET).sound(GTSoundEvents.ARC).build();
    @ZenProperty
    public static final RecipeMap<PrimitiveRecipeBuilder> PRIMITIVE_BLAST_FURNACE_RECIPES = new RecipeMapBuilder<PrimitiveRecipeBuilder>("primitive_blast_furnace", new PrimitiveRecipeBuilder()).itemInputs(3).modifyItemInputs(false).itemOutputs(3).modifyItemOutputs(false).modifyFluidInputs(false).modifyFluidOutputs(false).sound(GTSoundEvents.FIRE).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> PYROLYSE_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("pyrolyse_oven", new SimpleRecipeBuilder()).itemInputs(2).itemOutputs(1).fluidInputs(1).fluidOutputs(1).sound(GTSoundEvents.FIRE).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> REPLICATOR_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("replicator", new SimpleRecipeBuilder()).itemInputs(1).itemOutputs(1).fluidInputs(2).fluidOutputs(1).itemSlotOverlay(GuiTextures.DATA_ORB_OVERLAY, false).itemSlotOverlay(GuiTextures.ATOMIC_OVERLAY_1, true).fluidSlotOverlay(GuiTextures.NEUTRAL_MATTER_OVERLAY, false).fluidSlotOverlay(GuiTextures.POSITIVE_MATTER_OVERLAY, false, true).fluidSlotOverlay(GuiTextures.ATOMIC_OVERLAY_2, true).progressBar(GuiTextures.PROGRESS_BAR_REPLICATOR).sound(GTSoundEvents.REPLICATOR).build();
    @ZenProperty
    public static final RecipeMap<ComputationRecipeBuilder> RESEARCH_STATION_RECIPES = new RecipeMapResearchStation<ComputationRecipeBuilder>("research_station", new ComputationRecipeBuilder(), ResearchStationUI::new);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> ROCK_BREAKER_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("rock_breaker", new SimpleRecipeBuilder()).itemInputs(1).itemOutputs(4).itemSlotOverlay(GuiTextures.DUST_OVERLAY, false).itemSlotOverlay(GuiTextures.CRUSHED_ORE_OVERLAY, true).progressBar(GuiTextures.PROGRESS_BAR_MACERATE).sound(GTSoundEvents.FIRE).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> SCANNER_RECIPES = new RecipeMapScanner("scanner", new SimpleRecipeBuilder(), recipeMap -> {
        RecipeMapUI<RecipeMap> ui = new RecipeMapUI<RecipeMap>(recipeMap, true, true, true, true, false);
        ui.setItemSlotOverlay(GuiTextures.DATA_ORB_OVERLAY, false, false);
        ui.setItemSlotOverlay(GuiTextures.SCANNER_OVERLAY, false, true);
        ui.setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressWidget.MoveType.HORIZONTAL);
        return ui;
    });
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> SIFTER_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("sifter", new SimpleRecipeBuilder()).itemInputs(1).itemOutputs(6).progressBar(GuiTextures.PROGRESS_BAR_SIFT, ProgressWidget.MoveType.VERTICAL_DOWNWARDS).sound(SoundEvents.field_187753_eE).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> THERMAL_CENTRIFUGE_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("thermal_centrifuge", (SimpleRecipeBuilder)((SimpleRecipeBuilder)new SimpleRecipeBuilder().duration(400)).EUt(30L)).itemInputs(1).itemOutputs(3).itemSlotOverlay(GuiTextures.CRUSHED_ORE_OVERLAY, false).itemSlotOverlay(GuiTextures.DUST_OVERLAY, true).progressBar(GuiTextures.PROGRESS_BAR_MACERATE).sound(GTSoundEvents.CENTRIFUGE).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> VACUUM_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("vacuum_freezer", (SimpleRecipeBuilder)new SimpleRecipeBuilder().EUt(GTValues.VA[2])).itemInputs(1).itemOutputs(1).fluidInputs(2).fluidOutputs(1).sound(GTSoundEvents.COOLING).build();
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> WIREMILL_RECIPES = new RecipeMapBuilder<SimpleRecipeBuilder>("wiremill", new SimpleRecipeBuilder()).itemInputs(2).itemOutputs(1).itemSlotOverlay(GuiTextures.WIREMILL_OVERLAY, false).itemSlotOverlay(GuiTextures.INT_CIRCUIT_OVERLAY, false, true).progressBar(GuiTextures.PROGRESS_BAR_WIREMILL).sound(GTSoundEvents.MOTOR).build();
    @ZenProperty
    public static final RecipeMap<FuelRecipeBuilder> COMBUSTION_GENERATOR_FUELS = new RecipeMapBuilder<FuelRecipeBuilder>("combustion_generator", new FuelRecipeBuilder()).fluidInputs(1).fluidSlotOverlay(GuiTextures.FURNACE_OVERLAY_2, false).progressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE).sound(GTSoundEvents.COMBUSTION).allowEmptyOutputs().generator().build();
    @ZenProperty
    public static final RecipeMap<FuelRecipeBuilder> GAS_TURBINE_FUELS = new RecipeMapBuilder<FuelRecipeBuilder>("gas_turbine", new FuelRecipeBuilder()).fluidInputs(1).fluidSlotOverlay(GuiTextures.DARK_CANISTER_OVERLAY, false).progressBar(GuiTextures.PROGRESS_BAR_GAS_COLLECTOR).sound(GTSoundEvents.TURBINE).allowEmptyOutputs().generator().build();
    @ZenProperty
    public static final RecipeMap<FuelRecipeBuilder> STEAM_TURBINE_FUELS = new RecipeMapBuilder<FuelRecipeBuilder>("steam_turbine", new FuelRecipeBuilder()).fluidInputs(1).fluidOutputs(1).fluidSlotOverlay(GuiTextures.CENTRIFUGE_OVERLAY, false).progressBar(GuiTextures.PROGRESS_BAR_GAS_COLLECTOR).sound(GTSoundEvents.TURBINE).allowEmptyOutputs().generator().build();
    @ZenProperty
    public static final RecipeMap<FuelRecipeBuilder> SEMI_FLUID_GENERATOR_FUELS = new RecipeMapBuilder<FuelRecipeBuilder>("semi_fluid_generator", new FuelRecipeBuilder()).fluidInputs(1).fluidSlotOverlay(GuiTextures.FURNACE_OVERLAY_2, false).progressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE).sound(GTSoundEvents.COMBUSTION).allowEmptyOutputs().generator().build();
    @ZenProperty
    public static final RecipeMap<FuelRecipeBuilder> PLASMA_GENERATOR_FUELS = new RecipeMapBuilder<FuelRecipeBuilder>("plasma_generator", new FuelRecipeBuilder()).fluidInputs(1).fluidOutputs(1).fluidSlotOverlay(GuiTextures.CENTRIFUGE_OVERLAY, false).progressBar(GuiTextures.PROGRESS_BAR_GAS_COLLECTOR).sound(GTSoundEvents.TURBINE).allowEmptyOutputs().generator().build();

    private RecipeMaps() {
    }
}

