/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes;

import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.recipes.RecipeBuildAction;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.ui.RecipeMapUI;
import gregtech.api.recipes.ui.RecipeMapUIFunction;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectArrayMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeMapBuilder<B extends RecipeBuilder<B>> {
    private final String unlocalizedName;
    private final B defaultRecipeBuilder;
    private final Byte2ObjectMap<TextureArea> slotOverlays = new Byte2ObjectArrayMap();
    private int itemInputs;
    private boolean modifyItemInputs = true;
    private int itemOutputs;
    private boolean modifyItemOutputs = true;
    private int fluidInputs;
    private boolean modifyFluidInputs = true;
    private int fluidOutputs;
    private boolean modifyFluidOutputs = true;
    private boolean isGenerator;
    @Nullable
    private TextureArea progressBar;
    @Nullable
    private ProgressWidget.MoveType moveType;
    @Nullable
    private TextureArea specialTexture;
    private int @Nullable [] specialTextureLocation;
    private RecipeMapUIFunction recipeMapUIFunction = this::buildUI;
    private SoundEvent sound;
    private boolean allowEmptyOutputs;
    @Nullable
    private Map<ResourceLocation, RecipeBuildAction<B>> buildActions;
    private boolean sortToBack;

    public RecipeMapBuilder(@NotNull String unlocalizedName, @NotNull B defaultRecipeBuilder) {
        this.unlocalizedName = unlocalizedName;
        this.defaultRecipeBuilder = defaultRecipeBuilder;
    }

    @NotNull
    public RecipeMapBuilder<B> itemInputs(int itemInputs) {
        this.itemInputs = itemInputs;
        return this;
    }

    @NotNull
    public RecipeMapBuilder<B> modifyItemInputs(boolean modifyItemInputs) {
        this.modifyItemInputs = modifyItemInputs;
        return this;
    }

    @NotNull
    public RecipeMapBuilder<B> itemOutputs(int itemOutputs) {
        this.itemOutputs = itemOutputs;
        return this;
    }

    @NotNull
    public RecipeMapBuilder<B> modifyItemOutputs(boolean modifyItemOutputs) {
        this.modifyItemOutputs = modifyItemOutputs;
        return this;
    }

    @NotNull
    public RecipeMapBuilder<B> fluidInputs(int fluidInputs) {
        this.fluidInputs = fluidInputs;
        return this;
    }

    @NotNull
    public RecipeMapBuilder<B> modifyFluidInputs(boolean modifyFluidInputs) {
        this.modifyFluidInputs = modifyFluidInputs;
        return this;
    }

    @NotNull
    public RecipeMapBuilder<B> fluidOutputs(int fluidOutputs) {
        this.fluidOutputs = fluidOutputs;
        return this;
    }

    @NotNull
    public RecipeMapBuilder<B> modifyFluidOutputs(boolean modifyFluidOutputs) {
        this.modifyFluidOutputs = modifyFluidOutputs;
        return this;
    }

    @NotNull
    public RecipeMapBuilder<B> generator() {
        this.isGenerator = true;
        return this;
    }

    @NotNull
    public RecipeMapBuilder<B> progressBar(@Nullable TextureArea progressBar) {
        this.progressBar = progressBar;
        return this;
    }

    @NotNull
    public RecipeMapBuilder<B> progressBar(@Nullable TextureArea progressBar, @Nullable ProgressWidget.MoveType moveType) {
        this.progressBar = progressBar;
        this.moveType = moveType;
        return this;
    }

    @NotNull
    public RecipeMapBuilder<B> itemSlotOverlay(@NotNull TextureArea texture, boolean isOutput) {
        this.slotOverlays.put(RecipeMapUI.computeOverlayKey(isOutput, false, false), (Object)texture);
        this.slotOverlays.put(RecipeMapUI.computeOverlayKey(isOutput, false, true), (Object)texture);
        return this;
    }

    @NotNull
    public RecipeMapBuilder<B> itemSlotOverlay(@NotNull TextureArea texture, boolean isOutput, boolean isLastSlot) {
        this.slotOverlays.put(RecipeMapUI.computeOverlayKey(isOutput, false, isLastSlot), (Object)texture);
        return this;
    }

    @NotNull
    public RecipeMapBuilder<B> fluidSlotOverlay(@NotNull TextureArea texture, boolean isOutput) {
        this.slotOverlays.put(RecipeMapUI.computeOverlayKey(isOutput, true, false), (Object)texture);
        this.slotOverlays.put(RecipeMapUI.computeOverlayKey(isOutput, true, true), (Object)texture);
        return this;
    }

    @NotNull
    public RecipeMapBuilder<B> fluidSlotOverlay(@NotNull TextureArea texture, boolean isOutput, boolean isLastSlot) {
        this.slotOverlays.put(RecipeMapUI.computeOverlayKey(isOutput, true, isLastSlot), (Object)texture);
        return this;
    }

    @NotNull
    public RecipeMapBuilder<B> specialTexture(@NotNull TextureArea texture, int x, int y, int width, int height) {
        this.specialTexture = texture;
        this.specialTextureLocation = new int[]{x, y, width, height};
        return this;
    }

    @NotNull
    public RecipeMapBuilder<B> ui(@NotNull RecipeMapUIFunction recipeMapUIFunction) {
        this.recipeMapUIFunction = recipeMapUIFunction;
        return this;
    }

    @NotNull
    private RecipeMapUI<?> buildUI(@NotNull RecipeMap<?> recipeMap) {
        RecipeMapUI ui = new RecipeMapUI(recipeMap, this.modifyItemInputs, this.modifyItemOutputs, this.modifyFluidInputs, this.modifyFluidOutputs, this.isGenerator);
        if (this.progressBar != null) {
            ui.setProgressBarTexture(this.progressBar);
        }
        if (this.moveType != null) {
            ui.setProgressBarMoveType(this.moveType);
        }
        if (this.specialTexture != null && this.specialTextureLocation != null) {
            ui.setSpecialTexture(this.specialTexture, this.specialTextureLocation);
        }
        for (Byte2ObjectMap.Entry entry : this.slotOverlays.byte2ObjectEntrySet()) {
            ui.setSlotOverlay(entry.getByteKey(), (TextureArea)entry.getValue());
        }
        return ui;
    }

    @NotNull
    public RecipeMapBuilder<B> sound(@NotNull SoundEvent sound) {
        this.sound = sound;
        return this;
    }

    @NotNull
    public RecipeMapBuilder<B> allowEmptyOutputs() {
        this.allowEmptyOutputs = true;
        return this;
    }

    @NotNull
    public RecipeMapBuilder<B> onBuild(@NotNull ResourceLocation name, @NotNull RecipeBuildAction<B> action) {
        if (this.buildActions == null) {
            this.buildActions = new Object2ObjectOpenHashMap();
        } else if (this.buildActions.containsKey(name)) {
            throw new IllegalArgumentException("Cannot register RecipeBuildAction with duplicate name: " + name);
        }
        this.buildActions.put(name, action);
        return this;
    }

    @NotNull
    public RecipeMapBuilder<B> jeiSortToBack(boolean sortToBack) {
        this.sortToBack = sortToBack;
        return this;
    }

    @NotNull
    public RecipeMap<B> build() {
        RecipeMap<B> recipeMap = new RecipeMap<B>(this.unlocalizedName, this.defaultRecipeBuilder, this.recipeMapUIFunction, this.itemInputs, this.itemOutputs, this.fluidInputs, this.fluidOutputs);
        recipeMap.setSound(this.sound);
        if (this.allowEmptyOutputs) {
            recipeMap.allowEmptyOutput();
        }
        if (this.buildActions != null) {
            recipeMap.onRecipeBuild(this.buildActions);
        }
        recipeMap.getPrimaryRecipeCategory().jeiSortToBack(this.sortToBack);
        return recipeMap;
    }
}

