/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes;

import crafttweaker.mc1120.actions.ActionAddFurnaceRecipe;
import crafttweaker.mc1120.furnace.MCFurnaceManager;
import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.toolitem.IGTTool;
import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.recipes.RecyclingHandler;
import gregtech.api.recipes.recipes.DummyRecipe;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.unification.stack.RecyclingData;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.DummyContainer;
import gregtech.api.util.GTLog;
import gregtech.api.util.LocalizationUtils;
import gregtech.api.util.Mods;
import gregtech.api.util.world.DummyWorld;
import gregtech.common.ConfigHolder;
import gregtech.common.crafting.FluidReplaceRecipe;
import gregtech.common.crafting.GTShapedOreRecipe;
import gregtech.common.crafting.GTShapelessOreRecipe;
import gregtech.common.crafting.ShapedOreEnergyTransferRecipe;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModHandler {
    public static final boolean ERROR_ON_INVALID_RECIPE = GTValues.isDeobfEnvironment() || !ConfigHolder.misc.ignoreErrorOrInvalidRecipes;
    public static boolean hasInvalidRecipe = false;

    private ModHandler() {
    }

    public static void postInit() {
        if (ERROR_ON_INVALID_RECIPE && hasInvalidRecipe) {
            throw new IllegalStateException("Invalid Recipes Found. See earlier log entries for details.");
        }
    }

    public static boolean isMaterialWood(@Nullable Material material) {
        return material != null && material.hasProperty(PropertyKey.WOOD);
    }

    public static ItemStack getBurningFuelRemainder(ItemStack fuelStack) {
        float remainderChance;
        ItemStack remainder;
        if (OreDictUnifier.hasOreDictionary(fuelStack, "fuelCoke")) {
            remainder = OreDictUnifier.get(OrePrefix.dust, Materials.Ash);
            remainderChance = 0.5f;
        } else {
            MaterialStack materialStack = OreDictUnifier.getMaterial(fuelStack);
            if (materialStack == null) {
                return ItemStack.field_190927_a;
            }
            if (materialStack.material == Materials.Charcoal) {
                remainder = OreDictUnifier.get(OrePrefix.dust, Materials.Ash);
                remainderChance = 0.3f;
            } else if (materialStack.material == Materials.Coal) {
                remainder = OreDictUnifier.get(OrePrefix.dust, Materials.DarkAsh);
                remainderChance = 0.35f;
            } else if (materialStack.material == Materials.Coke) {
                remainder = OreDictUnifier.get(OrePrefix.dust, Materials.Ash);
                remainderChance = 0.5f;
            } else {
                return ItemStack.field_190927_a;
            }
        }
        return GTValues.RNG.nextFloat() <= remainderChance ? remainder : ItemStack.field_190927_a;
    }

    public static void addSmeltingRecipe(@NotNull UnificationEntry input, @NotNull ItemStack output) {
        ModHandler.addSmeltingRecipe(input, output, 0.0f);
    }

    public static void addSmeltingRecipe(@NotNull ItemStack input, @NotNull ItemStack output) {
        ModHandler.addSmeltingRecipe(input, output, 0.0f);
    }

    public static void addSmeltingRecipe(@NotNull UnificationEntry input, @NotNull ItemStack output, float experience) {
        for (ItemStack inputStack : OreDictUnifier.getAll(input)) {
            ModHandler.addSmeltingRecipe(inputStack, output, experience);
        }
    }

    public static void addSmeltingRecipe(@NotNull ItemStack input, @NotNull ItemStack output, float experience) {
        if (input.func_190926_b() && ModHandler.setErroredInvalidRecipe("Furnace Recipe Input cannot be an empty ItemStack")) {
            return;
        }
        if (output.func_190926_b() && ModHandler.setErroredInvalidRecipe("Furnace Recipe Output cannot be an empty ItemStack")) {
            return;
        }
        FurnaceRecipes recipes = FurnaceRecipes.func_77602_a();
        if (recipes.func_151395_a(input).func_190926_b()) {
            recipes.func_151394_a(input, output, experience);
        } else {
            ModHandler.logInvalidRecipe(String.format("Tried to register duplicate Furnace Recipe: %sx %s:%s -> %sx %s:%s, %sexp", input.func_190916_E(), Objects.requireNonNull(input.func_77973_b().getRegistryName()).func_110624_b(), input.func_82833_r(), output.func_190916_E(), Objects.requireNonNull(output.func_77973_b().getRegistryName()).func_110624_b(), output.func_82833_r(), Float.valueOf(experience)));
        }
    }

    @NotNull
    public static ItemStack getSmeltingOutput(@NotNull ItemStack input) {
        if (input.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        return OreDictUnifier.getUnificated(FurnaceRecipes.func_77602_a().func_151395_a(input));
    }

    public static void addShapedRecipe(@NotNull String regName, @NotNull ItemStack result, Object ... recipe) {
        ModHandler.addShapedRecipe(false, regName, result, false, false, recipe);
    }

    public static void addFluidReplaceRecipe(String regName, ItemStack result, Object ... recipe) {
        ModHandler.addFluidReplaceRecipe(regName, result, false, recipe);
    }

    public static void addShapedNBTClearingRecipe(String regName, ItemStack result, Object ... recipe) {
        ModHandler.addShapedRecipe(false, regName, result, true, false, recipe);
    }

    public static void addShapedRecipe(boolean withUnificationData, String regName, ItemStack result, Object ... recipe) {
        ModHandler.addShapedRecipe(withUnificationData, regName, result, false, false, recipe);
    }

    public static void addMirroredShapedRecipe(String regName, ItemStack result, Object ... recipe) {
        ModHandler.addShapedRecipe(false, regName, result, false, true, recipe);
    }

    public static void addShapedRecipe(boolean withUnificationData, @NotNull String regName, @NotNull ItemStack result, boolean isNBTClearing, boolean isMirrored, Object ... recipe) {
        RecyclingData data;
        if (!ModHandler.validateRecipeWithOutput(regName, result, recipe)) {
            return;
        }
        ModHandler.addRecipe(regName, result, isNBTClearing, isMirrored, recipe);
        if (withUnificationData && (data = RecyclingHandler.getRecyclingIngredients(result.func_190916_E(), recipe)) != null) {
            GregTechAPI.RECYCLING_MANAGER.registerRecyclingData(result, data);
        }
    }

    public static void addFluidReplaceRecipe(String regName, ItemStack result, boolean isNBTClearing, Object ... recipe) {
        if (!ModHandler.validateRecipeWithOutput(regName, result, recipe)) {
            return;
        }
        IRecipe shapedOreRecipe = (IRecipe)new FluidReplaceRecipe(isNBTClearing, null, result.func_77946_l(), ModHandler.finalizeShapedRecipeInput(recipe)).setMirrored(false).setRegistryName(regName);
        ModHandler.registerRecipe(shapedOreRecipe);
    }

    public static void addShapedEnergyTransferRecipe(String regName, ItemStack result, Predicate<ItemStack> chargePredicate, boolean overrideCharge, boolean transferMaxCharge, Object ... recipe) {
        if (!ModHandler.validateRecipeWithOutput(regName, result, recipe)) {
            return;
        }
        IRecipe shapedOreRecipe = (IRecipe)new ShapedOreEnergyTransferRecipe(null, result.func_77946_l(), chargePredicate, overrideCharge, transferMaxCharge, ModHandler.finalizeShapedRecipeInput(recipe)).setMirrored(false).setRegistryName(regName);
        ModHandler.registerRecipe(shapedOreRecipe);
    }

    private static boolean validateRecipeWithOutput(@NotNull String regName, @NotNull ItemStack result, Object ... recipe) {
        if (result.func_190926_b() && ModHandler.setErroredInvalidRecipe("Recipe output cannot be an empty ItemStack. Recipe: " + regName)) {
            return false;
        }
        return ModHandler.validateRecipe(regName, recipe);
    }

    private static void addRecipe(@NotNull String regName, @NotNull ItemStack result, boolean isNBTClearing, boolean isMirrored, Object ... recipe) {
        IRecipe shapedOreRecipe = (IRecipe)new GTShapedOreRecipe(isNBTClearing, null, result.func_77946_l(), ModHandler.finalizeShapedRecipeInput(recipe)).setMirrored(isMirrored).setRegistryName(regName);
        ModHandler.registerRecipe(shapedOreRecipe);
    }

    private static void registerRecipe(@NotNull IRecipe recipe) {
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
    }

    private static boolean validateRecipe(String regName, Object ... recipe) {
        if (recipe == null) {
            return !ModHandler.setErroredInvalidRecipe("Recipe cannot be null");
        }
        if (recipe.length == 0) {
            return !ModHandler.setErroredInvalidRecipe("Recipe cannot be empty");
        }
        if (Arrays.asList(recipe).contains(null) || Arrays.asList(recipe).contains(ItemStack.field_190927_a)) {
            String recipeMessage = Arrays.stream(recipe).map(o -> o == null ? "NULL" : o).map(o -> o == ItemStack.field_190927_a ? "EMPTY STACK" : o).map(Object::toString).map(s -> "\"" + s + "\"").collect(Collectors.joining(", "));
            return !ModHandler.setErroredInvalidRecipe("Recipe cannot contain null elements or Empty ItemStacks. Recipe: " + recipeMessage);
        }
        ModContainer container = Loader.instance().activeModContainer();
        if (ForgeRegistries.RECIPES.containsKey(new ResourceLocation(container == null ? "gregtech" : container.getModId().toLowerCase(), regName))) {
            String recipeMessage = Arrays.stream(recipe).map(Object::toString).map(s -> "\"" + s + "\"").collect(Collectors.joining(", "));
            ModHandler.logInvalidRecipe("Tried to register recipe, " + regName + ", with duplicate key. Recipe: " + recipeMessage);
            return false;
        }
        return true;
    }

    public static Object @NotNull [] finalizeShapedRecipeInput(Object ... recipe) {
        for (int i = 0; i < recipe.length; i = (int)((byte)(i + 1))) {
            recipe[i] = ModHandler.finalizeIngredient(recipe[i]);
        }
        int idx = 0;
        ArrayList<Object> recipeList = new ArrayList<Object>(Arrays.asList(recipe));
        while (recipe[idx] instanceof String) {
            StringBuilder s = new StringBuilder((String)recipe[idx++]);
            while (s.length() < 3) {
                s.append(" ");
            }
            if (s.length() > 3) {
                throw new IllegalArgumentException("Recipe row cannot be larger than 3. Index: " + idx);
            }
            for (char c : s.toString().toCharArray()) {
                IGTTool tool = ToolHelper.getToolFromSymbol(Character.valueOf(c));
                if (tool == null || tool.getOreDictName() == null) continue;
                recipeList.add(Character.valueOf(c));
                recipeList.add(tool.getOreDictName());
            }
        }
        return recipeList.toArray();
    }

    @NotNull
    public static Object finalizeIngredient(@NotNull Object ingredient) {
        if (ingredient instanceof MetaItem.MetaValueItem) {
            MetaItem.MetaValueItem metaValueItem = (MetaItem.MetaValueItem)ingredient;
            ingredient = metaValueItem.getStackForm();
        } else if (ingredient instanceof Enum) {
            Enum anEnum = (Enum)ingredient;
            ingredient = anEnum.name();
        } else if (ingredient instanceof OrePrefix) {
            OrePrefix orePrefix = (OrePrefix)ingredient;
            ingredient = orePrefix.name();
        } else if (ingredient instanceof UnificationEntry) {
            UnificationEntry entry = (UnificationEntry)ingredient;
            if (ConfigHolder.misc.debug && entry.material != null && !entry.orePrefix.isIgnored(entry.material) && !entry.orePrefix.doGenerateItem(entry.material)) {
                ModHandler.logInvalidRecipe("Attempted to create recipe for invalid/missing Unification Entry " + ingredient);
            }
            ingredient = ingredient.toString();
        } else if (!(ingredient instanceof ItemStack || ingredient instanceof Item || ingredient instanceof Block || ingredient instanceof String || ingredient instanceof Character || ingredient instanceof Boolean || ingredient instanceof Ingredient)) {
            throw new IllegalArgumentException(ingredient.getClass().getSimpleName() + " type is not suitable for crafting input.");
        }
        return ingredient;
    }

    public static void addShapelessRecipe(@NotNull String regName, @NotNull ItemStack result, Object ... recipe) {
        ModHandler.addShapelessRecipe(regName, result, false, recipe);
    }

    public static void addShapelessNBTClearingRecipe(@NotNull String regName, @NotNull ItemStack result, Object ... recipe) {
        ModHandler.addShapelessRecipe(regName, result, true, recipe);
    }

    public static void addShapelessRecipe(String regName, ItemStack result, boolean isNBTClearing, Object ... recipe) {
        if (!ModHandler.validateRecipeWithOutput(regName, result, recipe)) {
            return;
        }
        for (int i = 0; i < recipe.length; i = (int)((byte)(i + 1))) {
            if (recipe[i] instanceof MetaItem.MetaValueItem) {
                recipe[i] = ((MetaItem.MetaValueItem)recipe[i]).getStackForm();
                continue;
            }
            if (recipe[i] instanceof Enum) {
                recipe[i] = ((Enum)recipe[i]).name();
                continue;
            }
            if (recipe[i] instanceof OrePrefix) {
                recipe[i] = ((OrePrefix)recipe[i]).name();
                continue;
            }
            if (recipe[i] instanceof UnificationEntry) {
                recipe[i] = recipe[i].toString();
                continue;
            }
            if (recipe[i] instanceof Character) {
                IGTTool tool = ToolHelper.getToolFromSymbol(Character.valueOf(((Character)recipe[i]).charValue()));
                if (tool == null || tool.getOreDictName() == null) {
                    throw new IllegalArgumentException("Tool name is not found for char " + recipe[i]);
                }
                recipe[i] = tool.getOreDictName();
                continue;
            }
            if (recipe[i] instanceof ItemStack || recipe[i] instanceof Item || recipe[i] instanceof Block || recipe[i] instanceof String) continue;
            throw new IllegalArgumentException(recipe.getClass().getSimpleName() + " type is not suitable for crafting input.");
        }
        IRecipe shapelessRecipe = (IRecipe)new GTShapelessOreRecipe(isNBTClearing, null, result.func_77946_l(), recipe).setRegistryName(regName);
        try {
            Field field = ShapelessOreRecipe.class.getDeclaredField("isSimple");
            field.setAccessible(true);
            field.setBoolean(shapelessRecipe, false);
        }
        catch (ReflectiveOperationException exception) {
            GTLog.logger.error("Failed to mark shapeless recipe as complex", (Throwable)exception);
        }
        ModHandler.registerRecipe(shapelessRecipe);
    }

    public static boolean removeFurnaceSmelting(@NotNull UnificationEntry input) {
        boolean result = false;
        for (ItemStack inputStack : OreDictUnifier.getAll(input)) {
            result = result || ModHandler.removeFurnaceSmelting(inputStack);
        }
        return result;
    }

    public static boolean removeFurnaceSmelting(@NotNull ItemStack input) {
        if (input.func_190926_b() && ModHandler.setErroredInvalidRecipe("Cannot remove furnace recipe with empty input.")) {
            return false;
        }
        boolean wasRemoved = FurnaceRecipes.func_77602_a().func_77599_b().keySet().removeIf(currentStack -> currentStack.func_77973_b() == input.func_77973_b() && (currentStack.func_77960_j() == Short.MAX_VALUE || currentStack.func_77960_j() == input.func_77960_j()));
        if (ConfigHolder.misc.debug) {
            if (wasRemoved) {
                GTLog.logger.info("Removed Smelting Recipe for Input: {}", (Object)input.func_82833_r());
            } else {
                GTLog.logger.error("Failed to Remove Smelting Recipe for Input: {}", (Object)input.func_82833_r());
            }
        }
        return wasRemoved;
    }

    public static int removeRecipeByOutput(@NotNull ItemStack output) {
        int recipesRemoved = ModHandler.removeRecipeByOutput((IRecipe recipe) -> ItemStack.func_77989_b((ItemStack)recipe.func_77571_b(), (ItemStack)output));
        if (ConfigHolder.misc.debug) {
            if (recipesRemoved != 0) {
                GTLog.logger.info("Removed {} Recipe(s) with Output: {}", (Object)recipesRemoved, (Object)output.func_82833_r());
            } else {
                GTLog.logger.error("Failed to Remove Recipe with Output: {}", (Object)output.func_82833_r());
            }
        }
        return recipesRemoved;
    }

    public static int removeRecipeByOutput(Predicate<IRecipe> predicate) {
        int recipesRemoved = 0;
        IForgeRegistry registry = ForgeRegistries.RECIPES;
        ArrayList<IRecipe> toRemove = new ArrayList<IRecipe>();
        for (IRecipe recipe2 : registry) {
            if (!predicate.test(recipe2)) continue;
            toRemove.add(recipe2);
            ++recipesRemoved;
        }
        toRemove.forEach(recipe -> {
            if (recipe.getRegistryName() != null) {
                registry.register((IForgeRegistryEntry)((IRecipe)new DummyRecipe().setRegistryName(recipe.getRegistryName())));
            }
        });
        return recipesRemoved;
    }

    public static void removeRecipeByName(@NotNull ResourceLocation location) {
        if (ConfigHolder.misc.debug) {
            String recipeName = location.toString();
            if (ForgeRegistries.RECIPES.containsKey(location)) {
                GTLog.logger.info("Removed Recipe with Name: {}", (Object)recipeName);
            } else {
                GTLog.logger.error("Failed to Remove Recipe with Name: {}", (Object)recipeName);
            }
        }
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)((IRecipe)new DummyRecipe().setRegistryName(location)));
    }

    public static void removeRecipeByName(String recipeName) {
        ModHandler.removeRecipeByName(new ResourceLocation(recipeName));
    }

    public static void removeTieredRecipeByName(@NotNull String recipeName, int startTier, int endTier) {
        for (int i = startTier; i <= endTier; ++i) {
            ModHandler.removeRecipeByName(String.format("%s%s", recipeName, GTValues.VN[i].toLowerCase()));
        }
    }

    @NotNull
    public static Pair<IRecipe, ItemStack> getRecipeOutput(@Nullable World world, ItemStack ... recipe) {
        if (recipe == null || recipe.length == 0) {
            return ImmutablePair.of(null, (Object)ItemStack.field_190927_a);
        }
        if (world == null) {
            world = DummyWorld.INSTANCE;
        }
        InventoryCrafting craftingGrid = new InventoryCrafting((Container)new DummyContainer(), 3, 3);
        for (int i = 0; i < 9 && i < recipe.length; ++i) {
            ItemStack recipeStack = recipe[i];
            if (recipeStack.func_190926_b()) continue;
            craftingGrid.func_70299_a(i, recipeStack);
        }
        for (IRecipe tmpRecipe : CraftingManager.field_193380_a) {
            if (!tmpRecipe.func_77569_a(craftingGrid, world)) continue;
            ItemStack itemStack = tmpRecipe.func_77572_b(craftingGrid);
            return ImmutablePair.of((Object)tmpRecipe, (Object)itemStack);
        }
        return ImmutablePair.of(null, (Object)ItemStack.field_190927_a);
    }

    public static void removeSmeltingEBFMetals() {
        Field actionAddFurnaceRecipe$output = null;
        Map furnaceList = FurnaceRecipes.func_77602_a().func_77599_b();
        Iterator recipeIterator = furnaceList.entrySet().iterator();
        block4: while (recipeIterator.hasNext()) {
            Material material;
            Map.Entry recipe = recipeIterator.next();
            ItemStack output = (ItemStack)recipe.getValue();
            ItemStack input = (ItemStack)recipe.getKey();
            MaterialStack ms = OreDictUnifier.getMaterial(output);
            if (ms == null || !(material = ms.material).hasProperty(PropertyKey.BLAST)) continue;
            ItemStack dust = OreDictUnifier.get(OrePrefix.dust, material);
            ItemStack ingot = OreDictUnifier.get(OrePrefix.ingot, material);
            if (!ingot.func_77969_a(output) || !dust.func_77969_a(input)) continue;
            if (Mods.CraftTweaker.isModLoaded()) {
                if (actionAddFurnaceRecipe$output == null) {
                    try {
                        actionAddFurnaceRecipe$output = ActionAddFurnaceRecipe.class.getDeclaredField("output");
                        actionAddFurnaceRecipe$output.setAccessible(true);
                    }
                    catch (NoSuchFieldException e) {
                        GTLog.logger.error("Could not reflect Furnace output field", (Throwable)e);
                        return;
                    }
                }
                for (ActionAddFurnaceRecipe aafr : MCFurnaceManager.recipesToAdd) {
                    try {
                        if (actionAddFurnaceRecipe$output.get(aafr) != output) continue;
                        if (!ConfigHolder.misc.debug) continue block4;
                        GTLog.logger.info("Not removing Smelting Recipe for EBF material {} as it is added via CT", (Object)LocalizationUtils.format(material.getUnlocalizedName(), new Object[0]));
                        continue block4;
                    }
                    catch (IllegalAccessException e) {
                        GTLog.logger.error("Could not get Furnace recipe output from field", (Throwable)e);
                    }
                }
            }
            recipeIterator.remove();
            if (!ConfigHolder.misc.debug) continue;
            GTLog.logger.info("Removing Smelting Recipe for EBF material {}", (Object)LocalizationUtils.format(material.getUnlocalizedName(), new Object[0]));
        }
    }

    public static boolean setErroredInvalidRecipe(@NotNull String message) throws IllegalArgumentException {
        hasInvalidRecipe = true;
        ModHandler.logInvalidRecipe(message);
        return ERROR_ON_INVALID_RECIPE;
    }

    public static void logInvalidRecipe(@NotNull String message) {
        GTLog.logger.warn("Invalid Recipe Found: {}", (Object)message, (Object)new Throwable());
    }
}

