/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet.tile;

import gregtech.api.GregTechAPI;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.cover.Cover;
import gregtech.api.metatileentity.NeighborCacheTileEntityBase;
import gregtech.api.metatileentity.SyncedTileEntityBase;
import gregtech.api.pipenet.PipeNet;
import gregtech.api.pipenet.WorldPipeNet;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.IPipeType;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.PipeCoverableImplementation;
import gregtech.api.unification.material.Material;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TileEntityPipeBase<PipeType extends Enum<PipeType>, NodeDataType>
extends NeighborCacheTileEntityBase
implements IPipeTile<PipeType, NodeDataType> {
    protected final PipeCoverableImplementation coverableImplementation = new PipeCoverableImplementation(this);
    protected int paintingColor = -1;
    private int connections = 0;
    private int blockedConnections = 0;
    private NodeDataType cachedNodeData;
    private BlockPipe<PipeType, NodeDataType, ?> pipeBlock;
    private PipeType pipeType = ((Enum[])this.getPipeTypeClass().getEnumConstants())[0];
    @Nullable
    private Material frameMaterial;
    private TileEntityPipeBase<PipeType, NodeDataType> tickingPipe;

    public void setPipeData(BlockPipe<PipeType, NodeDataType, ?> pipeBlock, PipeType pipeType) {
        this.pipeBlock = pipeBlock;
        this.pipeType = pipeType;
        if (!this.func_145831_w().field_72995_K) {
            this.writeCustomData(GregtechDataCodes.UPDATE_PIPE_TYPE, this::writePipeProperties);
        }
    }

    @Override
    public void transferDataFrom(IPipeTile<PipeType, NodeDataType> tileEntity) {
        this.pipeType = tileEntity.getPipeType();
        this.paintingColor = tileEntity.getPaintingColor();
        this.connections = tileEntity.getConnections();
        if (tileEntity instanceof SyncedTileEntityBase) {
            SyncedTileEntityBase pipeBase = (SyncedTileEntityBase)((Object)tileEntity);
            this.addPacketsFrom(pipeBase);
        }
        tileEntity.getCoverableImplementation().transferDataTo(this.coverableImplementation);
        this.setFrameMaterial(tileEntity.getFrameMaterial());
    }

    public abstract Class<PipeType> getPipeTypeClass();

    @Override
    @Nullable
    public Material getFrameMaterial() {
        return this.frameMaterial;
    }

    public void setFrameMaterial(@Nullable Material frameMaterial) {
        this.frameMaterial = frameMaterial;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.writeCustomData(GregtechDataCodes.UPDATE_FRAME_MATERIAL, buf -> {
                buf.func_150787_b(frameMaterial == null ? -1 : frameMaterial.getRegistry().getNetworkId());
                buf.func_150787_b(frameMaterial == null ? -1 : frameMaterial.getId());
            });
        }
    }

    @Override
    public boolean supportsTicking() {
        return this instanceof ITickable;
    }

    @Override
    public World getPipeWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getPipePos() {
        return this.func_174877_v();
    }

    public void func_70296_d() {
        if (this.func_145831_w() != null && this.func_174877_v() != null) {
            this.func_145831_w().func_175646_b(this.func_174877_v(), (TileEntity)this);
        }
    }

    @Override
    public PipeCoverableImplementation getCoverableImplementation() {
        return this.coverableImplementation;
    }

    @Override
    public boolean canPlaceCoverOnSide(EnumFacing side) {
        return true;
    }

    @Override
    public IPipeTile<PipeType, NodeDataType> setSupportsTicking() {
        if (this.supportsTicking()) {
            return this;
        }
        if (this.tickingPipe != null) {
            return this.tickingPipe;
        }
        TileEntityPipeBase<PipeType, NodeDataType> newTile = this.getPipeBlock().createNewTileEntity(true);
        if (!newTile.supportsTicking()) {
            throw new IllegalStateException("Expected pipe to be ticking, but isn't!");
        }
        newTile.transferDataFrom(this);
        this.func_145831_w().func_175690_a(this.func_174877_v(), newTile);
        this.tickingPipe = newTile;
        return newTile;
    }

    @Override
    public BlockPipe<PipeType, NodeDataType, ?> getPipeBlock() {
        if (this.pipeBlock == null) {
            BlockPipe blockPipe;
            Block block = this.getBlockState().func_177230_c();
            this.pipeBlock = block instanceof BlockPipe ? (blockPipe = (BlockPipe)block) : null;
        }
        return this.pipeBlock;
    }

    @Override
    public int getConnections() {
        return this.connections;
    }

    @Override
    public int getNumConnections() {
        int count = 0;
        for (int connections = this.getConnections(); connections > 0; connections &= connections - 1) {
            ++count;
        }
        return count;
    }

    @Override
    public int getBlockedConnections() {
        return this.canHaveBlockedFaces() ? this.blockedConnections : 0;
    }

    @Override
    public int getPaintingColor() {
        return this.isPainted() ? this.paintingColor : this.getDefaultPaintingColor();
    }

    @Override
    public void setPaintingColor(int paintingColor) {
        this.paintingColor = paintingColor;
        if (!this.func_145831_w().field_72995_K) {
            ((WorldPipeNet)((Object)this.getPipeBlock().getWorldPipeNet(this.func_145831_w()))).updateMark(this.func_174877_v(), this.getCableMark());
            this.writeCustomData(GregtechDataCodes.UPDATE_INSULATION_COLOR, buffer -> buffer.writeInt(paintingColor));
            this.func_70296_d();
        }
    }

    @Override
    public boolean isPainted() {
        return this.paintingColor != -1;
    }

    @Override
    public int getDefaultPaintingColor() {
        return 0xFFFFFF;
    }

    @Override
    public boolean isConnected(EnumFacing side) {
        return TileEntityPipeBase.isConnected(this.connections, side);
    }

    public static boolean isConnected(int connections, EnumFacing side) {
        return (connections & 1 << side.func_176745_a()) > 0;
    }

    @Override
    public void setConnection(EnumFacing side, boolean connected, boolean fromNeighbor) {
        if (!this.func_145831_w().field_72995_K) {
            IPipeTile pipeTile;
            if (this.isConnected(side) == connected) {
                return;
            }
            TileEntity tile = this.getNeighbor(side);
            if (connected && tile instanceof IPipeTile && (pipeTile = (IPipeTile)tile).getPipeType().getClass() != this.getPipeType().getClass()) {
                return;
            }
            this.connections = this.withSideConnection(this.connections, side, connected);
            this.updateNetworkConnection(side, connected);
            this.writeCustomData(GregtechDataCodes.UPDATE_CONNECTIONS, buffer -> buffer.func_150787_b(this.connections));
            this.func_70296_d();
            if (!fromNeighbor && tile instanceof IPipeTile) {
                pipeTile = (IPipeTile)tile;
                this.syncPipeConnections(side, pipeTile);
            }
        }
    }

    private void syncPipeConnections(EnumFacing side, IPipeTile<?, ?> pipe) {
        EnumFacing oppositeSide = side.func_176734_d();
        boolean neighbourOpen = pipe.isConnected(oppositeSide);
        if (this.isConnected(side) == neighbourOpen) {
            return;
        }
        if (!neighbourOpen || pipe.getCoverableImplementation().getCoverAtSide(oppositeSide) == null) {
            pipe.setConnection(oppositeSide, !neighbourOpen, true);
        }
    }

    private void updateNetworkConnection(EnumFacing side, boolean connected) {
        Object worldPipeNet = this.getPipeBlock().getWorldPipeNet(this.func_145831_w());
        ((WorldPipeNet)((Object)worldPipeNet)).updateBlockedConnections(this.func_174877_v(), side, !connected);
    }

    protected int withSideConnection(int blockedConnections, EnumFacing side, boolean connected) {
        int index = 1 << side.func_176745_a();
        if (connected) {
            return blockedConnections | index;
        }
        return blockedConnections & ~index;
    }

    @Override
    public void setFaceBlocked(EnumFacing side, boolean blocked) {
        if (!this.field_145850_b.field_72995_K && this.canHaveBlockedFaces()) {
            this.blockedConnections = this.withSideConnection(this.blockedConnections, side, blocked);
            this.writeCustomData(GregtechDataCodes.UPDATE_BLOCKED_CONNECTIONS, buf -> buf.func_150787_b(this.blockedConnections));
            this.func_70296_d();
            Object worldPipeNet = this.getPipeBlock().getWorldPipeNet(this.func_145831_w());
            Object net = ((WorldPipeNet)((Object)worldPipeNet)).getNetFromPos(this.field_174879_c);
            if (net != null) {
                ((PipeNet)net).onPipeConnectionsUpdate();
            }
        }
    }

    @Override
    public boolean isFaceBlocked(EnumFacing side) {
        if (side == null) {
            return true;
        }
        return TileEntityPipeBase.isFaceBlocked(this.blockedConnections, side);
    }

    public static boolean isFaceBlocked(int blockedConnections, EnumFacing side) {
        return (blockedConnections & 1 << side.func_176745_a()) > 0;
    }

    @Override
    public PipeType getPipeType() {
        return this.pipeType;
    }

    @Override
    public NodeDataType getNodeData() {
        if (this.cachedNodeData == null) {
            this.cachedNodeData = this.getPipeBlock().createProperties(this);
        }
        return this.cachedNodeData;
    }

    private int getCableMark() {
        return this.paintingColor == -1 ? 0 : this.paintingColor;
    }

    @Override
    public int getVisualConnections() {
        int connections = this.getConnections();
        float selfThickness = ((IPipeType)this.getPipeType()).getThickness();
        for (EnumFacing facing : EnumFacing.values()) {
            IPipeTile pipeTile;
            if (!this.isConnected(facing)) continue;
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (tileEntity instanceof IPipeTile && (pipeTile = (IPipeTile)tileEntity).isConnected(facing.func_176734_d()) && ((IPipeType)pipeTile.getPipeType()).getThickness() < selfThickness) {
                connections |= 1 << facing.func_176745_a() + 6;
            }
            if (this.getCoverableImplementation().getCoverAtSide(facing) == null) continue;
            connections |= 1 << facing.func_176745_a() + 12;
        }
        return connections;
    }

    @Override
    public <T> T getCapabilityInternal(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == GregtechTileCapabilities.CAPABILITY_COVER_HOLDER) {
            return (T)GregtechTileCapabilities.CAPABILITY_COVER_HOLDER.cast((Object)this.getCoverableImplementation());
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    @Nullable
    public final <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
        Cover cover;
        T pipeCapability;
        T t = pipeCapability = this.getPipeBlock() == null ? null : (T)this.getCapabilityInternal(capability, facing);
        if (capability == GregtechTileCapabilities.CAPABILITY_COVER_HOLDER) {
            return pipeCapability;
        }
        Cover cover2 = cover = facing == null ? null : this.coverableImplementation.getCoverAtSide(facing);
        if (cover == null) {
            if (facing == null || this.isConnected(facing)) {
                return pipeCapability;
            }
            return null;
        }
        T coverCapability = cover.getCapability(capability, pipeCapability);
        if (coverCapability == pipeCapability) {
            if (this.isConnected(facing)) {
                return pipeCapability;
            }
            return null;
        }
        return coverCapability;
    }

    public final boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        super.func_189515_b(compound);
        BlockPipe<PipeType, NodeDataType, ?> pipeBlock = this.getPipeBlock();
        if (pipeBlock != null) {
            compound.func_74778_a("PipeBlock", pipeBlock.getRegistryName().toString());
        }
        compound.func_74768_a("PipeType", ((Enum)this.pipeType).ordinal());
        compound.func_74768_a("Connections", this.connections);
        compound.func_74768_a("BlockedConnections", this.blockedConnections);
        if (this.isPainted()) {
            compound.func_74768_a("InsulationColor", this.paintingColor);
        }
        compound.func_74778_a("FrameMaterial", this.frameMaterial == null ? "" : this.frameMaterial.getRegistryName());
        this.coverableImplementation.writeToNBT(compound);
        return compound;
    }

    public void func_145839_a(@NotNull NBTTagCompound compound) {
        String frameMaterialName;
        if (this.tickingPipe != null) {
            this.tickingPipe.func_145839_a(compound);
            return;
        }
        super.func_145839_a(compound);
        if (compound.func_150297_b("PipeBlock", 8)) {
            BlockPipe blockPipe;
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(compound.func_74779_i("PipeBlock")));
            this.pipeBlock = block instanceof BlockPipe ? (blockPipe = (BlockPipe)block) : null;
        }
        this.pipeType = ((Enum[])this.getPipeTypeClass().getEnumConstants())[compound.func_74762_e("PipeType")];
        if (compound.func_74764_b("Connections")) {
            this.connections = compound.func_74762_e("Connections");
        } else if (compound.func_74764_b("BlockedConnectionsMap")) {
            this.connections = 0;
            NBTTagCompound blockedConnectionsTag = compound.func_74775_l("BlockedConnectionsMap");
            for (String attachmentTypeKey : blockedConnectionsTag.func_150296_c()) {
                int blockedConnections = blockedConnectionsTag.func_74762_e(attachmentTypeKey);
                this.connections |= blockedConnections;
            }
        }
        this.blockedConnections = compound.func_74762_e("BlockedConnections");
        if (compound.func_74764_b("InsulationColor")) {
            this.paintingColor = compound.func_74762_e("InsulationColor");
        }
        if (!(frameMaterialName = compound.func_74779_i("FrameMaterial")).isEmpty()) {
            this.frameMaterial = GregTechAPI.materialManager.getMaterial(frameMaterialName);
        }
        this.coverableImplementation.readFromNBT(compound);
        if (this.tickingPipe != null && this.coverableImplementation.hasAnyCover()) {
            this.coverableImplementation.transferDataTo(this.tickingPipe.coverableImplementation);
        }
    }

    public void onLoad() {
        super.onLoad();
        this.coverableImplementation.onLoad();
    }

    protected void writePipeProperties(PacketBuffer buf) {
        buf.func_150787_b(((Enum)this.pipeType).ordinal());
    }

    protected void readPipeProperties(PacketBuffer buf) {
        this.pipeType = ((Enum[])this.getPipeTypeClass().getEnumConstants())[buf.func_150792_a()];
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        this.writePipeProperties(buf);
        buf.func_150787_b(this.connections);
        buf.func_150787_b(this.blockedConnections);
        buf.writeInt(this.paintingColor);
        buf.func_150787_b(this.frameMaterial == null ? -1 : this.frameMaterial.getRegistry().getNetworkId());
        buf.func_150787_b(this.frameMaterial == null ? -1 : this.frameMaterial.getId());
        this.coverableImplementation.writeInitialSyncData(buf);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        if (this.tickingPipe != null) {
            this.tickingPipe.receiveInitialSyncData(buf);
            return;
        }
        this.readPipeProperties(buf);
        this.connections = buf.func_150792_a();
        this.blockedConnections = buf.func_150792_a();
        this.paintingColor = buf.readInt();
        int registryId = buf.func_150792_a();
        int frameMaterialId = buf.func_150792_a();
        this.frameMaterial = registryId >= 0 && frameMaterialId >= 0 ? (Material)GregTechAPI.materialManager.getRegistry(registryId).func_148754_a(frameMaterialId) : null;
        this.coverableImplementation.readInitialSyncData(buf);
        if (this.tickingPipe != null && this.coverableImplementation.hasAnyCover()) {
            this.coverableImplementation.transferDataTo(this.tickingPipe.coverableImplementation);
        }
    }

    @Override
    public void receiveCustomData(int discriminator, PacketBuffer buf) {
        if (this.tickingPipe != null) {
            this.tickingPipe.receiveCustomData(discriminator, buf);
            return;
        }
        if (discriminator == GregtechDataCodes.UPDATE_INSULATION_COLOR) {
            this.paintingColor = buf.readInt();
            this.scheduleChunkForRenderUpdate();
        } else if (discriminator == GregtechDataCodes.UPDATE_CONNECTIONS) {
            this.connections = buf.func_150792_a();
            this.scheduleChunkForRenderUpdate();
        } else if (discriminator == GregtechDataCodes.SYNC_COVER_IMPLEMENTATION) {
            this.coverableImplementation.readCustomData(buf.func_150792_a(), buf);
        } else if (discriminator == GregtechDataCodes.UPDATE_PIPE_TYPE) {
            this.readPipeProperties(buf);
            this.scheduleChunkForRenderUpdate();
        } else if (discriminator == GregtechDataCodes.UPDATE_BLOCKED_CONNECTIONS) {
            this.blockedConnections = buf.func_150792_a();
            this.scheduleChunkForRenderUpdate();
        } else if (discriminator == GregtechDataCodes.UPDATE_FRAME_MATERIAL) {
            int registryId = buf.func_150792_a();
            int frameMaterialId = buf.func_150792_a();
            this.frameMaterial = registryId >= 0 && frameMaterialId >= 0 ? (Material)GregTechAPI.materialManager.getRegistry(registryId).func_148754_a(frameMaterialId) : null;
            this.scheduleChunkForRenderUpdate();
        }
    }

    @Override
    public void writeCoverCustomData(int id, Consumer<PacketBuffer> writer) {
        this.writeCustomData(GregtechDataCodes.SYNC_COVER_IMPLEMENTATION, buffer -> {
            buffer.func_150787_b(id);
            writer.accept((PacketBuffer)buffer);
        });
    }

    @Override
    public void scheduleChunkForRenderUpdate() {
        BlockPos pos = this.func_174877_v();
        this.func_145831_w().func_147458_c(pos.func_177958_n() - 1, pos.func_177956_o() - 1, pos.func_177952_p() - 1, pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p() + 1);
    }

    @Override
    public void notifyBlockUpdate() {
        this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
        this.getPipeBlock().updateActiveNodeStatus(this.func_145831_w(), this.func_174877_v(), this);
    }

    @Override
    public void markAsDirty() {
        this.func_70296_d();
    }

    @Override
    public boolean isValidTile() {
        return !this.func_145837_r();
    }

    public boolean shouldRefresh(@NotNull World world, @NotNull BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Override
    @MustBeInvokedByOverriders
    public void onChunkUnload() {
        Object worldPipeNet;
        Object net;
        super.onChunkUnload();
        if (!this.field_145850_b.field_72995_K && (net = ((WorldPipeNet)((Object)(worldPipeNet = this.getPipeBlock().getWorldPipeNet(this.func_145831_w())))).getNetFromPos(this.field_174879_c)) != null) {
            ((PipeNet)net).onChunkUnload();
        }
    }

    public void doExplosion(float explosionPower) {
        this.func_145831_w().func_175698_g(this.func_174877_v());
        if (!this.func_145831_w().field_72995_K) {
            ((WorldServer)this.func_145831_w()).func_175739_a(EnumParticleTypes.SMOKE_LARGE, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, 10, 0.2, 0.2, 0.2, 0.0, new int[0]);
        }
        this.func_145831_w().func_72876_a(null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, explosionPower, false);
    }
}

