/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet.longdist;

import gregtech.api.pipenet.longdist.ILDEndpoint;
import gregtech.api.pipenet.longdist.ILDNetworkPart;
import gregtech.api.pipenet.longdist.LongDistanceNetwork;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;

public class NetworkBuilder
extends Thread {
    private final ObjectList<BlockPos> starts = new ObjectArrayList();
    private final LongDistanceNetwork.WorldData worldData;
    private final LongDistanceNetwork originalNetwork;
    private LongDistanceNetwork network;
    private final World world;
    private final ObjectList<BlockPos> currentPoints = new ObjectArrayList();
    private final ObjectOpenHashSet<BlockPos> walked = new ObjectOpenHashSet();
    private final List<BlockPos> pipes = new ArrayList<BlockPos>();
    private final List<ILDEndpoint> endpoints = new ArrayList<ILDEndpoint>();
    private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
    private final ObjectOpenHashSet<Chunk> loadedChunks = new ObjectOpenHashSet();

    public NetworkBuilder(LongDistanceNetwork.WorldData worldData, LongDistanceNetwork network, Collection<BlockPos> starts) {
        this.worldData = Objects.requireNonNull(worldData);
        this.originalNetwork = Objects.requireNonNull(network);
        this.network = network;
        this.world = worldData.getWorld();
        this.starts.addAll(starts);
    }

    @Override
    public void run() {
        if (this.starts.isEmpty()) {
            return;
        }
        BlockPos start = (BlockPos)this.starts.remove(0);
        this.checkNetwork(start);
        while (!this.starts.isEmpty()) {
            start = (BlockPos)this.starts.remove(0);
            LongDistanceNetwork ldn = this.worldData.getNetwork(start);
            if (ldn == this.originalNetwork) continue;
            this.network = this.network.getPipeType().createNetwork(this.worldData);
            this.currentPoints.clear();
            this.walked.clear();
            this.pipes.clear();
            this.endpoints.clear();
            this.checkNetwork(start);
        }
        IChunkProvider chunkProvider = this.world.func_72863_F();
        if (chunkProvider instanceof ChunkProviderServer) {
            ChunkProviderServer chunkProviderServer = (ChunkProviderServer)chunkProvider;
            this.loadedChunks.forEach(arg_0 -> ((ChunkProviderServer)chunkProviderServer).func_189549_a(arg_0));
        }
    }

    private void checkNetwork(BlockPos start) {
        this.checkPos(this.world.func_180495_p(start), start);
        while (!this.currentPoints.isEmpty()) {
            BlockPos current = (BlockPos)this.currentPoints.remove(0);
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                IBlockState blockState;
                this.pos.func_189533_g((Vec3i)current).func_189536_c(facing);
                if (this.walked.contains((Object)this.pos) || (blockState = this.getBlockState((BlockPos)this.pos)).func_177230_c().isAir(blockState, (IBlockAccess)this.world, (BlockPos)this.pos)) continue;
                this.checkPos(blockState, (BlockPos)this.pos);
            }
        }
        this.network.setData(this.pipes, this.endpoints);
    }

    private void checkPos(IBlockState blockState, BlockPos pos) {
        LongDistanceNetwork network = LongDistanceNetwork.get(this.world, pos);
        if (network != null && network != this.network) {
            network.invalidateNetwork(true);
        }
        BlockPos bp = pos.func_185334_h();
        this.walked.add((Object)bp);
        ILDNetworkPart part = ILDNetworkPart.tryGet(this.world, pos, blockState);
        if (part != null) {
            this.pipes.add(bp);
            if (part instanceof ILDEndpoint) {
                ILDEndpoint endpoint = (ILDEndpoint)part;
                this.endpoints.add(endpoint);
            } else {
                this.currentPoints.add((Object)bp);
            }
        }
    }

    private IBlockState getBlockState(BlockPos pos) {
        if (this.world.func_189509_E(pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        IChunkProvider chunkProvider = this.world.func_72863_F();
        Chunk chunk = chunkProvider.func_186026_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        if (chunk == null) {
            if (!chunkProvider.func_191062_e(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) {
                return Blocks.field_150350_a.func_176223_P();
            }
            chunk = chunkProvider.func_186025_d(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            this.loadedChunks.add((Object)chunk);
        }
        return chunk.func_177435_g(pos);
    }
}

