/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet.longdist;

import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.interfaces.INeighborCache;
import gregtech.api.pipenet.longdist.ILDNetworkPart;
import gregtech.api.pipenet.longdist.LongDistancePipeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ILDEndpoint
extends ILDNetworkPart,
INeighborCache {
    @NotNull
    public IOType getIoType();

    public void setIoType(IOType var1);

    default public boolean isInput() {
        return this.getIoType() == IOType.INPUT;
    }

    default public boolean isOutput() {
        return this.getIoType() == IOType.OUTPUT;
    }

    @Nullable
    public ILDEndpoint getLink();

    public void invalidateLink();

    @NotNull
    public EnumFacing getFrontFacing();

    @NotNull
    public EnumFacing getOutputFacing();

    @Override
    @NotNull
    public LongDistancePipeType getPipeType();

    public BlockPos getPos();

    public World getWorld();

    public boolean isValid();

    @Nullable
    public static ILDEndpoint tryGet(World world, BlockPos pos) {
        IGregTechTileEntity gte;
        MetaTileEntity metaTileEntity;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IGregTechTileEntity && (metaTileEntity = (gte = (IGregTechTileEntity)te).getMetaTileEntity()) instanceof ILDEndpoint) {
            ILDEndpoint endpoint = (ILDEndpoint)((Object)metaTileEntity);
            return endpoint;
        }
        return null;
    }

    public static enum IOType {
        NONE,
        INPUT,
        OUTPUT;

    }
}

